<?php

namespace Modules\Pd\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class DailyProduction extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'pd_daily_productions';
    protected $primaryKey = 'daily_production_id';

    protected $fillable = [];
    protected static $logAttributes = [
        'daily_production_id',
        'date',
        'supervisor_id',
        'customer_order_plan_id',
        'product_id',
        'machine_id',
        'refferance_no',
        'day_quantity',
        'night_quantity',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "pd_daily_productions";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
   
}
