<?php

namespace Modules\Pd\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class FinishedGoodsHeader extends Model
{
    use HasFactory,LogsActivity;

    protected $fillable = [];
    protected $table = 'pd_finished_goods_headers';
    protected $primaryKey = 'internal_id';
    protected static $logAttributes = [
        'internal_id',
        'external_id',
        'ref_internal_id',
        'ref_external_id',
        'trans_date',
        'store_id',
        'customer_order_plan_id',
        'manufacturing_order_number',
        'remarks',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "pd_finished_goods_headers";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }

}
