<?php

namespace Modules\Pd\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class PallatizingHeader extends Model
{
    use HasFactory,LogsActivity;

    protected $fillable = [];
    protected $table = 'pd_pallatizing_headers';
    protected $primaryKey = 'pallatizing_header_id';
    protected static $logAttributes = ['*'];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "pd_pallatizing_headers";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    
    protected static function newFactory()
    {
        return \Modules\Pd\Database\factories\PallatizingHeaderFactory::new();
    }
}
