<?php

namespace Modules\Pd\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class ProductionMachineBreakdown extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'pd_production_machine_breakdowns';
    protected $fillable = [];

    protected static $logAttributes = [
        'id',
        'date',
        'site_id',
        'machinery_id',
        'breakdown_time',
        'breakdown_reason_id',
        'note',
        'recovered_time',
        'recovery_details',
        'technical_instruction',
        'status',
       

    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "pd_production_machine_breakdowns";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    

}
