<?php

namespace Modules\Pd\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class ReasonOfBreakdown extends Model
{
    use HasFactory,LogsActivity;

    protected $fillable = [];
    protected $table = 'pd_reason_of_breakdown_supervisor';
    protected static $logAttributes = [
        'id',
        'customer_order_plan_data_id',
        'date',
        'machinery_id',
        'product_primary_id',
        'employee_id',
        'shift_id',
        'breakdown_time',
        'reason_of_breakdown',
        'recovered_time',
        'recovery_details',
        'technical_instruction',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "pd_reason_of_breakdown_supervisor";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    
    /*protected static function newFactory()
    {
        return \Modules\Pd\Database\factories\ReasonOfBreakdownFactory::new();
    }*/
}
