<?php

namespace Modules\Pd\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class ScheduleCustomerOrderPlan extends Model
{
    use HasFactory,LogsActivity;

    protected $fillable = [];
    protected $table = 'pd_schedule_customer_order_plans';
    protected $primaryKey = 'schedule_customer_order_plan_id';
    protected static $logAttributes = [
        'schedule_customer_order_plan_id',
        'customer_order_plan_id',
        'order_id',
        'manufacturing_order_number',
        'trans_date',
        'from_date',
        'to_date',
        'description',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "pd_schedule_customer_order_plans";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
 
}
