<?php

namespace Modules\Pd\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class ScheduleMachineryPlan extends Model
{
    use HasFactory,LogsActivity;

    protected $fillable = [];
    protected $table = 'pd_schedule_machinery_plans';
    protected $primaryKey = 'schedule_machinery_plan_id';

    protected static $logAttributes = [
        'schedule_machinery_plan_id',
        'machinery_plan_id',
        'customer_order_plan_data_id',
        'machinery_id',
        'product_primary_id',
        'date',
        'from',
        'to',
        'quantity',
        'shift_id',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "pd_schedule_machinery_plans";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
