<?php

namespace Modules\Pd\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class ScheduleOrderResourceBom extends Model
{
    use HasFactory,LogsActivity;

    protected $fillable = [];
    protected $table = 'pd_schedule_order_resource_boms';
    protected $primaryKey = 'schedule_order_resource_bom_id';
    protected static $logAttributes = [
        'schedule_order_resource_bom_id',
        'order_resource_bom_id',
        'customer_order_plan_data_id',
        'fg_product_id',
        'rm_product_id',
        'quantity',
        'uom',
        'tolerance',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "pd_schedule_order_resource_boms";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
