<?php

namespace Modules\Pd\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Pd\Entities\ScheduleMachineryPlan;

class DailyProductionReportController extends Controller
{
    public function sites()
    {

        try {
            $sites = EmployeeSite::all();

            $responseBody = $this->responseBody(true, "DailyProductionReportController", "sites", $sites);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "DailyProductionReportController", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function dailyProductionReport($search_option)
    {

        try {
            $search_option_aaray =  json_decode($search_option);
            $site = $search_option_aaray->site;
            $year = $search_option_aaray->year;
            $month = $search_option_aaray->month;

            /* $query = 'SELECT  CONCAT(pp_machinery.machinery_no," - ",pp_machinery.machinery_name) AS `name`,
            pp_customer_order_plans.manufacturing_order_number AS order_no,
            pp_machinery.machinery_id,
            "" AS plan,
            "" AS actual
            FROM pp_machinery_plans
            INNER JOIN pp_machinery ON pp_machinery_plans.machinery_id = pp_machinery.machinery_id
            INNER JOIN pp_customer_order_plans_data ON pp_machinery_plans.customer_order_plan_data_id = pp_customer_order_plans_data.customer_order_plan_data_id
            INNER JOIN pp_customer_order_plans ON pp_customer_order_plans_data.customer_order_plan_id = pp_customer_order_plans.customer_order_plan_id
            WHERE YEAR(pp_machinery_plans.date) = "' . $year . '" AND MONTH(pp_machinery_plans.date) = "' . $month . '" GROUP BY pp_machinery_plans.machinery_id';*/

            $query = 'SELECT DISTINCT  CONCAT(pp_machinery.machinery_no," - ",pp_machinery.machinery_name) AS `name`,
            pp_customer_order_plans.manufacturing_order_number AS order_no,
            pp_customer_order_plans_data.customer_order_plan_data_id,
            pd_schedule_machinery_plans.machinery_id,
            "" AS plan,
            "" AS actual
            FROM pd_schedule_machinery_plans
            LEFT JOIN pp_machinery ON pd_schedule_machinery_plans.machinery_id = pp_machinery.machinery_id
            LEFT JOIN pp_customer_order_plans_data ON pd_schedule_machinery_plans.customer_order_plan_data_id = pp_customer_order_plans_data.customer_order_plan_data_id
            LEFT JOIN pp_customer_order_plans ON pp_customer_order_plans_data.customer_order_plan_id = pp_customer_order_plans.customer_order_plan_id
            WHERE YEAR(pd_schedule_machinery_plans.date) = "' . $year . '" AND MONTH(pd_schedule_machinery_plans.date) = "' . $month . '" ';

            if ($site) {
                $query .= 'AND pp_machinery.site_id = "' . $site . '" ';
            }
            //$query.='GROUP BY pd_schedule_machinery_plans.machinery_id';
            $daily_productions = DB::select($query);

            foreach ($daily_productions as $daily_production) {
                $plan = [
                    '01' => 0, '02' => 0, '03' => 0, '04' => 0, '05' => 0, '06' => 0, '07' => 0, '08' => 0, '09' => 0, '10' => 0,
                    '11' => 0, '12' => 0, '13' => 0, '14' => 0, '15' => 0, '16' => 0, '17' => 0, '18' => 0, '19' => 0, '20' => 0,
                    '21' => 0, '22' => 0, '23' => 0, '24' => 0, '25' => 0, '26' => 0, '27' => 0, '28' => 0, '29' => 0, '30' => 0,
                    '31' => 0,
                ];
                $machinery_plans = ScheduleMachineryPlan::where('machinery_id', '=', $daily_production->machinery_id)->whereYear('date', '=', $year)->whereMonth('date', '=', $month)->get();
                foreach ($machinery_plans as $machinery_plan) {
                    $date = $machinery_plan->date;
                    $day = explode("-", $date)[2];
                    $plan[$day] = $machinery_plan->quantity;
                }
                $daily_production->plan = $plan;
            }



            foreach ($daily_productions as $daily_production) {
                $actual = [
                    '01' => 0, '02' => 0, '03' => 0, '04' => 0, '05' => 0, '06' => 0, '07' => 0, '08' => 0, '09' => 0, '10' => 0,
                    '11' => 0, '12' => 0, '13' => 0, '14' => 0, '15' => 0, '16' => 0, '17' => 0, '18' => 0, '19' => 0, '20' => 0,
                    '21' => 0, '22' => 0, '23' => 0, '24' => 0, '25' => 0, '26' => 0, '27' => 0, '28' => 0, '29' => 0, '30' => 0,
                    '31' => 0,
                ];
                $query2 = 'SELECT *FROM pd_production_records_supervisor 
                WHERE pd_production_records_supervisor.machinery_id = "' . $daily_production->machinery_id . '" 
                AND YEAR(pd_production_records_supervisor.date) = "' . $year . '"
                AND MONTH(pd_production_records_supervisor.date) = "' . $month . '"';
                $actual_plans = DB::select($query2);
                foreach ($actual_plans as $actual_plan) {
                    $date = $actual_plan->date;
                    $day = explode("-", $date)[2];
                    $actual[$day] = $actual_plan->quantity;
                }
                $daily_production->actual = $actual;
            }

            $responseBody = $this->responseBody(true, "DailyProductionReportController", "dailyProductionReport", $daily_productions);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "DailyProductionReportController", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
