<?php

namespace Modules\Pd\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\EmployeeSite;

class DashBoardController extends Controller
{
    public function tableProducedQuantity($date)
    {

        $query = 'SELECT  POD.customer_order_plan_data_id , OH.purchase_order As purchase_order , OH.factory_po_num , 
        C.customer_name , P.product_name , POD.quantity as ordered_quantity  , 
        IF(ISNULL(PRD.prodction_quantity), 0,PRD.prodction_quantity) AS producedQuantity   FROM 
          pp_customer_orders  OH 
        INNER JOIN pp_customer_order_plans POH ON OH.order_id=POH.order_id
        INNER JOIN pp_customer_order_plans_data POD  ON  POH.customer_order_plan_id=POD.customer_order_plan_id
        INNER JOIN st_products P ON P.product_primary_id=POD.product_id 
        INNER JOIN st_customers C ON C.customer_id=OH.customer_id 
        
        INNER JOIN
        (SELECT DISTINCT customer_order_plan_data_id  FROM pd_schedule_machinery_plans 
        WHERE `date`="'.$date.'") PS ON POD.customer_order_plan_data_id=PS.customer_order_plan_data_id
        LEFT JOIN 
        
        (SELECT customer_order_plan_data_id , SUM(quantity) AS prodction_quantity  FROM pd_production_records_supervisor 
        WHERE date="'.$date.'" 
        GROUP BY customer_order_plan_data_id ) PRD  ON PRD.customer_order_plan_data_id=POD.customer_order_plan_data_id';

        $result = DB::select($query);

        return response()->json(
            [
                "result" => $result
            ]
        );
    }




    public function tableScheduleOnGoing($date)
    {

        $query = 'SELECT  POD.customer_order_plan_data_id , OH.purchase_order As purchase_order , OH.factory_po_num , 
        C.customer_name , P.product_name , POD.quantity as ordered_quantity  , 
        IF(ISNULL(PRD.prodction_quantity), 0,PRD.prodction_quantity) AS producedQuantity,
        IF(ISNULL(PRD.today_quantity), 0,PRD.today_quantity) AS todayQuantity FROM 
          pp_customer_orders  OH 
        INNER JOIN pp_customer_order_plans POH ON OH.order_id=POH.order_id
        INNER JOIN pp_customer_order_plans_data POD  ON  POH.customer_order_plan_id=POD.customer_order_plan_id
        INNER JOIN st_products P ON P.product_primary_id=POD.product_id 
        INNER JOIN st_customers C ON C.customer_id=OH.customer_id 
        
        INNER JOIN
        (SELECT DISTINCT customer_order_plan_data_id  FROM pd_schedule_machinery_plans 
        WHERE `date`="'.$date.'") PS ON POD.customer_order_plan_data_id=PS.customer_order_plan_data_id
        LEFT JOIN 
        
        (SELECT customer_order_plan_data_id , SUM(quantity) AS prodction_quantity, SUM(IF(CURDATE() = "'.$date.'",quantity,0)) AS today_quantity  FROM pd_production_records_supervisor 
        WHERE date="'.$date.'"
        GROUP BY customer_order_plan_data_id ) PRD  ON PRD.customer_order_plan_data_id=POD.customer_order_plan_data_id
        
        WHERE POD.production_status=3';

        $result = DB::select($query);

        return response()->json(
            [
                "result" => $result
            ]
        );
    }



    public function createTabsToSites()
    {

        $result = EmployeeSite::all();

        return response()->json(
            [
                "result" => $result
            ]
        );
    }
}
