<?php

namespace Modules\Pd\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Pd\Entities\FinishedGoodsData;
use Modules\Pd\Entities\FinishedGoodsHeader;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;

class FinishedGoodsListController extends Controller
{
    public function allFinishedGoods()
    {
        try {
            $query = 'SELECT pd_finished_goods_headers.internal_id,
            pd_finished_goods_headers.external_id,
            st_customers.customer_name,
            pd_finished_goods_headers.status,
            pd_finished_goods_headers.trans_date
            FROM pd_finished_goods_headers
            INNER JOIN pp_customer_order_plans ON pd_finished_goods_headers.manufacturing_order_number = pp_customer_order_plans.manufacturing_order_number
            INNER JOIN pp_customer_orders ON pp_customer_order_plans.order_id = pp_customer_orders.order_id
            INNER JOIN st_customers ON pp_customer_orders.customer_id = st_customers.customer_id ORDER BY pd_finished_goods_headers.internal_id DESC';
            $finishedGoods = DB::select($query);
            $responseBody = $this->responseBody(true, "FinishedGoodsListController", "allFinishedGoods", $finishedGoods);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "FinishedGoodsListController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function deleteFinishedGoods($id)
    {
        try {

            FinishedGoodsData::where('internal_id', '=', $id)->delete();
            $purchase = FinishedGoodsHeader::find($id);
            $purchase->delete();


            $responseBody = $this->responseBody(true, "FinishedGoodsListController", "deleteFinishedGoods", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "FinishedGoodsListController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
