<?php

namespace Modules\Pd\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;

class PendingMachineBreakdownController extends Controller
{
    public function allPendingMachineBreakdown()
    {

        try {

            $query = 'SELECT pd_production_machine_breakdowns.id,
            pd_production_machine_breakdowns.breakdown_time,
            pd_production_machine_breakdowns.status,
            pp_machinery.machinery_id,
            pp_machinery.machinery_name,
            hr_employee_sites.site,
			SUM(1) AS orders
            FROM pd_production_machine_breakdowns
            INNER JOIN pp_machinery ON pd_production_machine_breakdowns.machinery_id = pp_machinery.machinery_id
            INNER JOIN hr_employee_sites ON pd_production_machine_breakdowns.site_id = hr_employee_sites.site_id
			INNER JOIN pd_schedule_machinery_plans ON pd_production_machine_breakdowns.machinery_id = pd_schedule_machinery_plans.machinery_id
			INNER JOIN pp_customer_order_plans_data ON pd_schedule_machinery_plans.customer_order_plan_data_id = pp_customer_order_plans_data.customer_order_plan_data_id
			INNER JOIN pp_customer_orders ON pp_customer_order_plans_data.manufacturing_order_no = pp_customer_orders.factory_po_num WHERE pp_customer_orders.production_status = "2" AND pd_production_machine_breakdowns.status = "0"
            ORDER BY pd_production_machine_breakdowns.id DESC';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "ReasonOfBreakdownController", "allDailyProduction", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReasonOfBreakdownController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }



    public function getPendingMachineBreakdownData($id)
    {

        try {

            $query = 'SELECT pp_customer_orders.factory_po_num,
            st_products.product_id,
            st_products.product_name,
            pd_schedule_machinery_plans.quantity,
            pd_schedule_machinery_plans.date,
            hr_att_shifts.shift_name
            FROM pd_production_machine_breakdowns
            INNER JOIN pd_schedule_machinery_plans ON pd_production_machine_breakdowns.machinery_id = pd_schedule_machinery_plans.machinery_id
            INNER JOIN hr_att_shifts ON pd_schedule_machinery_plans.shift_id = hr_att_shifts.shift_id
            INNER JOIN pp_customer_order_plans_data ON pd_schedule_machinery_plans.customer_order_plan_data_id = pp_customer_order_plans_data.customer_order_plan_data_id
            INNER JOIN pp_customer_orders ON pp_customer_order_plans_data.manufacturing_order_no = pp_customer_orders.factory_po_num 
            INNER JOIN st_products ON pd_schedule_machinery_plans.product_primary_id = st_products.product_primary_id WHERE pp_customer_orders.production_status = "2" AND pd_production_machine_breakdowns.status = "0" AND pd_production_machine_breakdowns.id = "' . $id . '"
            ORDER BY pd_production_machine_breakdowns.id DESC';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "ReasonOfBreakdownController", "getPendingMachineBreakdownData", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReasonOfBreakdownController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
