<?php

namespace Modules\Pd\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\AttShift;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Pd\Entities\ScheduleCustomerOrderPlan;
use Modules\Pp\Entities\BomHeader;
use Modules\Pp\Entities\CustomerOrder;
use Modules\Pp\Entities\CustomerOrderData;
use Modules\Pp\Entities\CustomerPlanData;
use Modules\Pp\Entities\Machinary;
use Modules\Pp\Entities\MachinaryProduct;
use Modules\Pd\Entities\ScheduleMachineryPlan;
use Modules\Pp\Entities\OrderResourceBom;
use Modules\Pp\Entities\OrderResourceHr;
use Modules\St\Entities\Factory;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;

class ProductionAllocateMachineController extends Controller
{
    public function allOrderPlan(){

        try {
            // $customerPlan =  CustomerPlan::orderBy('order_id')->get();
            /*$query = "SELECT pp_customer_orders.purchase_order,pp_customer_orders.delivery_date, pp_customer_order_plans.* FROM pp_customer_order_plans
            INNER JOIN pp_customer_orders ON pp_customer_order_plans.order_id = pp_customer_orders.order_id";*/

            $query = "SELECT pp_customer_orders.purchase_order,pp_customer_orders.delivery_date, pp_customer_order_plans.* FROM pp_customer_order_plans
            INNER JOIN pp_customer_orders ON pp_customer_order_plans.order_id = pp_customer_orders.order_id WHERE  pp_customer_orders.production_status < 2";
            $customerPlan = DB::select($query);

            $customerPlanArray = array();
            foreach ($customerPlan as $data) {
                $schedule = ScheduleCustomerOrderPlan::where('customer_order_plan_id', '=', $data->customer_order_plan_id)->first();
                if (!$schedule) {
                    array_push($customerPlanArray, $data);
                }
            }
            $responseBody = $this->responseBody(true, "CustomerPlan", "all", $customerPlan);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionAllocateMachineController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    function allOrderPlanForSelect(){
        try {
            $cus_orders_arr = [];
            $query = "SELECT pp_customer_orders.purchase_order,pp_customer_orders.delivery_date, pp_customer_order_plans.* FROM pp_customer_order_plans
                        INNER JOIN pp_customer_orders 
                        ON pp_customer_order_plans.order_id = pp_customer_orders.order_id 
                        WHERE  pp_customer_orders.production_status < 2";
            $customerPlan = DB::select($query);
           
            foreach ($customerPlan as $cus_order) {

                // $id = $cus_order['customer_order_plan_id'];
                // $manufacturing_order_number = $cus_order['manufacturing_order_number'];
                // $purchase_order = $cus_order['purchase_order'];
                // array_push($cus_orders_arr, ["img" => "", "id" => $cus_order['customer_order_plan_id'], "value" => "2"]);

                $id = $cus_order->customer_order_plan_id;
                $manufacturing_order_number = $cus_order->manufacturing_order_number;
                $purchase_order = $cus_order->purchase_order;
            
                array_push($cus_orders_arr, [
                    "img" => "", 
                    "id" => $id,
                    "value" => $manufacturing_order_number . ' - ' . $purchase_order // Added meaningful value
                ]);
            }
            $responseBody = $this->responseBody(true, "allCusOrders", "Found", $cus_orders_arr);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "allCusOrders", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function allOrderPlanData($id){
        try {
            //$customerPlanData = CustomerPlanData::find($id);
            $query = 'SELECT pp_customer_order_plans_data.*,st_products.product_primary_id FROM pp_customer_order_plans_data 
            INNER JOIN st_products ON pp_customer_order_plans_data.product_id = st_products.product_primary_id 
            WHERE pp_customer_order_plans_data.customer_order_plan_id = "' . $id . '"  AND pp_customer_order_plans_data.production_schedule = "0"';
            $customerPlanData =  DB::select($query);
            $responseBody = $this->responseBody(true, "ProductionAllocateMachineController", "all", $customerPlanData);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionAllocateMachineController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function getSelectedProductData($customer_order_plan_data_id, $product_primary_id, $bom_header_id){
        try {
            $allocated_qty = $this->getAllocatedQuantity($customer_order_plan_data_id, $product_primary_id, '');
            $bom_header_qty = $this->getBomHeaderQuantityProduct($bom_header_id);
            $customerPlanData =  CustomerPlanData::find($customer_order_plan_data_id);
            if ($customerPlanData) {
                $customerPlanData->factory_po = "";
                $customerPlanData->customer_po = "";
                $customerPlanData->product_code = "";
                $customerPlanData->allocated_quantity = $allocated_qty;
                $customerPlanData->bom_header_quantity = $bom_header_qty;
                $orderData = CustomerOrderData::find($customerPlanData->order_data_id);
                if ($orderData) {
                    $customerOrder = CustomerOrder::find($orderData->order_id);
                    if ($customerOrder) {
                        $customerPlanData->factory_po = $customerOrder->factory_po_num;
                        $customerPlanData->customer_po = $customerOrder->purchase_order;
                    }
                }
                $product = Product::find($customerPlanData->product_id);
                if ($product) {
                    $customerPlanData->product_code = $product->product_id;
                }
            }
            $responseBody = $this->responseBody(true, "CustomerPlanData", "getSelectedProductData", $customerPlanData);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionAllocateMachineController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    function getAllocatedQuantity($order_id, $product_id, $machine_id){
        $quantity = 0;
        //$machineProduct =  MachineryPlan::where([['customer_order_plan_data_id', '=', $order_id], ['product_primary_id', '=', $product_id], ['machinery_id', '!=', $machine_id], ['date', '=', $date], ['from', '=', $from]])->first();
        $query = 'SELECT SUM(pd_schedule_machinery_plans.quantity) AS quantity FROM pd_schedule_machinery_plans 
            WHERE pd_schedule_machinery_plans.customer_order_plan_data_id = "' . $order_id . '" AND pd_schedule_machinery_plans.product_primary_id = "' . $product_id . '"';
        $result = DB::select($query);
        foreach ($result as $res) {
            $quantity = $res->quantity;
        }
        if (!$quantity) {
            $quantity = 0;
        }
        return $quantity;
    }

    function getBomHeaderQuantityProduct($bom_header_id){
        $quantity = 0;
        $query = 'SELECT pp_bom_header.quantity FROM pp_bom_header WHERE pp_bom_header.pp_bom_header_id = "' . $bom_header_id . '"';
        $result = DB::select($query);
        foreach ($result as $res) {
            $quantity = $res->quantity;
        }
        if (!$quantity) {
            $quantity = 0;
        }
        return $quantity;
    }

    public function loadMachinesToFactory($factory_id){
        try {
            //$machines =  Machinary::where('factory_id', $id)->get();
            $machines = [];
            if ($factory_id == 'any') {
                $machines =  DB::select('SELECT pp_machinery.*,
                st_factories.`name` AS factory
                from pp_machinery
                INNER JOIN st_factories on pp_machinery.factory_id = st_factories.factory_id ORDER BY st_factories.`name` ');
            } else {
                $machines =  DB::select('SELECT pp_machinery.*,
                st_factories.`name` AS factory,
                0 AS quantity
                from pp_machinery
                INNER JOIN st_factories on pp_machinery.factory_id = st_factories.factory_id 
                WHERE pp_machinery.factory_id = "' . $factory_id . '" ');
            }
            return $this->responseBody(true, "loadMachinesToFactory", "found", ["machine" => $machines]);
        } catch (\Exception $exception) {
            return $this->responseBody(false, "loadMachinesToFactory", "error", $exception->getMessage());
        }
    }

    function quantityPerHour($id, $product_primary_id){
        try {
            $quantity = 0;
            $machineProduct =  MachinaryProduct::where([['machinery_id', '=', $id], ['product_id', '=', $product_primary_id]])->first();
            if ($machineProduct) {
                $quantity = $machineProduct->quantity;
            }
            $responseBody = $this->responseBody(true, "quantityPerHour", "Found", $quantity);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "quantityPerHour", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    function getAllocatedData($order_id, $product_id, $machinery_id){
        try {
            $machineProducts =  ScheduleMachineryPlan::where([  ['customer_order_plan_data_id', '=', $order_id], 
                                                        ['product_primary_id', '=', $product_id], 
                                                        ['machinery_id', '=', $machinery_id]])->get();
                                                        
            $responseBody = $this->responseBody(true, "getAllocatedData", "Found", $machineProducts);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getAllocatedData", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    //check allocated machine data for a specific order and product
    function checkAllocatedData($order_id, $product_id){
        
        try {
            $allocated_data =  ScheduleMachineryPlan::where([
                                ['customer_order_plan_data_id', '=', $order_id], 
                                ['product_primary_id', '=', $product_id]
                                ])->get();

            $machinery_ids = $allocated_data->pluck('machinery_id')->toArray();

            if (empty($machinery_ids)) {
                return response()->json(["data" => $this->responseBody(false, "getAllocatedData", "No data found", [])]);
            }

            $query = 'SELECT pp_machinery.machinery_id,
                         pp_machinery.machinery_no,
                         pp_machinery.machinery_name,
                         st_factories.factory_id,
                         st_factories.name AS factory_name
                  FROM pp_machinery 
                  INNER JOIN st_factories ON pp_machinery.factory_id = st_factories.factory_id
                  WHERE pp_machinery.machinery_id IN (' . implode(',', $machinery_ids) . ')';

            $result = DB::select($query);

            $responseBody = $this->responseBody(true, "getAllocatedData", "Found", $result);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getAllocatedData", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    function factories(){
        try {
            $factory = Factory::all();
            $responseBody = $this->responseBody(true, "Factory", "Found", $factory);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "Factory", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function loadMachinePlan($factory_id, $machine_id, $fromDate, $toDate){
        try {
            //$machines =  Machinary::where('factory_id', $id)->get();
            $query = 'SELECT pp_machinery.*,
            st_factories.`name` AS factory,
            0 AS quantity
            from pp_machinery
            INNER JOIN st_factories on pp_machinery.factory_id = st_factories.factory_id WHERE';

            $factory_filter = '';
            $machine_filter = '';
            if ($factory_id != 'any') {
                $factory_filter = ' st_factories.factory_id = "' . $factory_id . '" AND ';
            }
            if ($machine_id != "null") {
                if ($machine_id != "any") {
                    $machine_filter = ' pp_machinery.machinery_id = "' . $machine_id . '" AND ';
                }
            }

            $query .= $factory_filter;
            $query .= $machine_filter;
            $query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
            //dd($query);

            $machines = DB::select($query);

            $machineryPlan = DB::select('SELECT pd_schedule_machinery_plans.machinery_id,
            pd_schedule_machinery_plans.date,
            pd_schedule_machinery_plans.shift_id,
            SUM(pd_schedule_machinery_plans.quantity) AS quantity 
            from pd_schedule_machinery_plans 
            INNER JOIN hr_att_shifts on pd_schedule_machinery_plans.shift_id = hr_att_shifts.shift_id 
            where pd_schedule_machinery_plans.date between "' . $fromDate . '" and  "' . $toDate . '" 
            GROUP BY pd_schedule_machinery_plans.machinery_id,pd_schedule_machinery_plans.shift_id,pd_schedule_machinery_plans.date');

            $holiday = DB::select("SELECT hr_atd_holidays.holyday_date 
            FROM hr_atd_holidays
            WHERE hr_atd_holidays.holyday_date BETWEEN '" . $fromDate . "' AND '" . $toDate . "'");
            return $this->responseBody(true, "loadMachinesToFactory", "found", ["machine" => $machines, "allocated" => $machineryPlan, "holiday" => $holiday]);
        } catch (\Exception $exception) {
            return $this->responseBody(false, "loadMachinesToFactory", "error", $exception->getMessage());
        }
    }

    function getMachineAllocatedQuantity($id, $date){
        try {
            $quantity = 0;
            $machinePlan =  ScheduleMachineryPlan::where([['machinery_id', '=', $id], ['date', '=', $date]])->first();
            if ($machinePlan) {
                $quantity = $machinePlan->quantity;
            }
            $responseBody = $this->responseBody(true, "getMachineAllocatedQuantity", "Found", $quantity);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getMachineAllocatedQuantity", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    function allShift(){
        try {
            $shift = AttShift::where('status', '=', 1)->get();

            $responseBody = $this->responseBody(true, "allShift", "Found", $shift);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "allShift", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function get_from_to($shift_id){
        try {
            $shift = AttShift::where('shift_id', '=', $shift_id)->first();
            $responseBody = $this->responseBody(true, "ProductionAllocateMachineController", "getProductUnits", ["from" => 0, "to" => 0]);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getMachineryShifts", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    function getAllocatedQuantityFromDate($order_id, $product_id, $machine_id, $date, $from, $to){
        try {
            $quantity = 0;
            //$machineProduct =  MachineryPlan::where([['customer_order_plan_data_id', '=', $order_id], ['product_primary_id', '=', $product_id], ['machinery_id', '!=', $machine_id], ['date', '=', $date], ['from', '=', $from]])->first();
            $query = 'SELECT SUM(pd_schedule_machinery_plans.quantity) AS quantity 
            FROM pd_schedule_machinery_plans 
            WHERE pd_schedule_machinery_plans.customer_order_plan_data_id = "' . $order_id . '" 
            AND pd_schedule_machinery_plans.product_primary_id = "' . $product_id . '"
            AND pd_schedule_machinery_plans.machinery_id != "' . $machine_id . '" 
            AND pd_schedule_machinery_plans.date = "' . $date . '" 
            AND (pd_schedule_machinery_plans.`from` >= "' . $from . '" 
            AND pd_schedule_machinery_plans.`to` <= "' . $to . '")';
            $result = DB::select($query);
            foreach ($result as $res) {
                $quantity = $res->quantity;
            }
            $responseBody = $this->responseBody(true, "getAllocatedQuantityFromDate", "Found", $quantity);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getAllocatedQuantityFromDate", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    function getAllocatedQuantityData($machine_id, $shift_id, $date){
        try {
            $machinePlan =  ScheduleMachineryPlan::where([['machinery_id', '=', $machine_id], ['shift_id', '=', $shift_id], ['date', '=', $date]])->get();
            $responseBody = $this->responseBody(true, "getAllocatedQuantityData", "Found", $machinePlan);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getAllocatedQuantityData", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    function saveAllocateToMachine(Request $request){
        try {
            $customer_order_plan_data_id = $request->get("customer_order_plan_data_id");
            $machinery_id = $request->get("machinery_id");
            $product_primary_id = $request->get("product_primary_id");
            $data = $request->get("data");
            ScheduleMachineryPlan::where([['customer_order_plan_data_id', '=', $customer_order_plan_data_id], ['machinery_id', '=', $machinery_id], ['product_primary_id', '=', $product_primary_id]])->delete();
            for ($i = 0; $i < count($data); $i++) {
                $dd = json_decode($data[$i]);

                if ($dd->date && $dd->from && $dd->to) {
                    $machineryPlan = new ScheduleMachineryPlan();
                    $machineryPlan->customer_order_plan_data_id = $customer_order_plan_data_id;
                    $machineryPlan->machinery_id = $machinery_id;
                    $machineryPlan->product_primary_id = $product_primary_id;
                    $machineryPlan->date = $dd->date;
                    $machineryPlan->from = $dd->from;
                    $machineryPlan->to = $dd->to;
                    $machineryPlan->quantity = $dd->quantity;
                    $machineryPlan->shift_id = $dd->shift;
                    $machineryPlan->save();
                }
            }
            $responseBody = $this->responseBody(true, "saveAllocateToMachine", "Found", true);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "saveAllocateToMachine", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }
    
    public function addorderPurchaceOrder(){
        try {
            $allOrders = CustomerOrder::where([['order_status', '=', '1'], ['production_status', '=', '0']])->get();
            $responseBody = $this->responseBody(true, "ProductionAllocateMachineController", "all", $allOrders);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionAllocateMachineController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }
 
    function allBomName($product_id){
        try {
            $bom = BomHeader::all();
            $responseBody = $this->responseBody(true, "allBomName", "Found", $bom);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "allBomName", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    function allBomNameForSelect($product_id){
        try {
            $bom_arr = [];
            $bom_data = BomHeader::all();
            foreach ($bom_data as $bom) {
                array_push($bom_arr, ["img" => "", "id" => $bom['pp_bom_header_id'], "value" => $bom['bom_name']]);
            }
            $responseBody = $this->responseBody(true, "allBomName", "Found", $bom_arr);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "allBomName", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    function getAllocatedBOMData($product_code, $bom_header_id){
        try {
            $query = 'SELECT pp_bom_data.* FROM pp_bom_data INNER JOIN pp_bom_header ON pp_bom_data.pp_bom_header_id = pp_bom_header.pp_bom_header_id
            WHERE pp_bom_header.pp_bom_header_id = "' . $bom_header_id . '"';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "getAllocatedBOMData", "Found", $result);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getAllocatedBOMData", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function allRawMaterialProducts(){
        try {
            $products =  Product::select('product_primary_id As id', 'product_name As value0')->get();
            return $this->responseBody(true, "ProductionAllocateMachineController", "allRawMaterialProducts", $products);
        } catch (\Exception $exception) {
            return $this->responseBody(false, "ProductionAllocateMachineController", "error", $exception);
        }
    }

    function saveAllocateToBOM(Request $request){
        try {
            $customer_order_plan_data_id = $request->get("customer_order_plan_data_id");
            $fg_product_id = $request->get("fg_product_primary_id");
            OrderResourceBom::where([['fg_product_id', '=', $fg_product_id], ['customer_order_plan_data_id', '=', $customer_order_plan_data_id]])->delete();

            $data = $request->get("data");
            for ($i = 0; $i < count($data); $i++) {
                $dd = json_decode($data[$i]);

                if ($dd->rm_product_id != "null") {
                    $bom = new OrderResourceBom();
                    $bom->customer_order_plan_data_id = $customer_order_plan_data_id;
                    $bom->fg_product_id = $fg_product_id;
                    $bom->rm_product_id = $dd->rm_product_id;
                    $bom->quantity = $dd->quantity;
                    $bom->uom = $dd->uom;
                    $bom->tolerance = $dd->tolerance;
                    $bom->save();
                }
            }

            $responseBody = $this->responseBody(true, "saveAllocateToBOM", "Found", $customer_order_plan_data_id);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "saveAllocateToBOM", "error", $data);
        }
        return response()->json(["data" => $responseBody]);
    }

    function getProductionTeam(){
        try {
            $query = 'SELECT hr_employee_designations.designation_id,
            hr_employee_designations.designation 
            FROM hr_employee_designations 
            INNER JOIN pp_production_teams 
            ON hr_employee_designations.designation_id = pp_production_teams.designation_id 
            WHERE pp_production_teams.status = "1"';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "getProductionTeam", "Found", $result);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getProductionTeam", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    function saveAllocateToHR(Request $request){
        try {
            $customer_order_plan_data_id = $request->get("customer_order_plan_data_id");
            $fg_product_id = $request->get("fg_product_id");
            $shift_id = $request->get("shift_id");
            $order = OrderResourceHr::where([['fg_product_id', '=', $fg_product_id], ['customer_order_plan_data_id', '=', $customer_order_plan_data_id], ['shift_id', '=', $shift_id]]);
            if ($order) {
                $order->delete();
            }
            $data = $request->get("data");
            for ($i = 0; $i < count($data); $i++) {
                $dd = json_decode($data[$i]);

                if ($dd->no_of_heads) {
                    $hr = new OrderResourceHr();
                    $hr->customer_order_plan_data_id = $customer_order_plan_data_id;
                    $hr->fg_product_id = $fg_product_id;
                    $hr->shift_id = $shift_id;
                    $hr->designation_id = $dd->designation_id;
                    $hr->no_of_heads = $dd->no_of_heads;
                    $hr->save();
                }
            }

            $responseBody = $this->responseBody(true, "saveAllocateToHR", "Found", true);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "saveAllocateToHR", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    function getSaveProductionTeam($customer_order_plan_data_id, $fg_product_id, $shift_id){
        try {
            $query = 'SELECT hr_employee_designations.designation_id,
            hr_employee_designations.designation,
            pp_order_resource_hrs.no_of_heads,pp_order_resource_hrs.shift_id 
            FROM hr_employee_designations 
            INNER JOIN pp_production_teams 
            ON hr_employee_designations.designation_id = pp_production_teams.designation_id
            INNER JOIN pp_order_resource_hrs 
            ON pp_production_teams.designation_id = pp_order_resource_hrs.designation_id 
            WHERE pp_order_resource_hrs.customer_order_plan_data_id = "' . $customer_order_plan_data_id . '" 
            AND pp_order_resource_hrs.fg_product_id = "' . $fg_product_id . '" 
            AND pp_order_resource_hrs.shift_id="' . $shift_id . '"';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "getSavedProductionTeam", "Found", $result);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getSavedProductionTeam", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    function getSavedAllocatedBOMData($customer_order_plan_data_id, $fg_product_id){
        try {
            $query = 'SELECT DISTINCT pp_order_resource_boms.*,
            pp_bom_data.product_primary_id,
            pp_bom_data.product_name 
            FROM pp_order_resource_boms
            LEFT JOIN pp_bom_data 
            ON pp_order_resource_boms.rm_product_id = pp_bom_data.product_primary_id
            WHERE  pp_order_resource_boms.customer_order_plan_data_id = "' . $customer_order_plan_data_id . '" 
            AND pp_order_resource_boms.fg_product_id = "' . $fg_product_id . '"';

            $result = DB::select($query);
            //$result = OrderResourceBom::where([['customer_order_plan_data_id', '=', $customer_order_plan_data_id], ['fg_product_id', '=', $fg_product_id]])->get();
            $responseBody = $this->responseBody(true, "getSavedAllocatedBOMData", "Found", $result);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getSavedAllocatedBOMData", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    function loadProductionPlanToCalander(){
        try {
            $query = 'SELECT pp_customer_orders.factory_po_num AS factory_po,
            pp_customer_orders.purchase_order AS customer_po,
            SUM(pd_schedule_machinery_plans.quantity) AS quantity,
            st_products.product_id,st_products.product_name,
            pd_schedule_machinery_plans.date AS start_date,
            pd_schedule_machinery_plans.date AS end_date,
            pp_machinery.machinery_no,
            pp_machinery.machinery_name 
            FROM pd_schedule_machinery_plans
            INNER JOIN st_products ON pd_schedule_machinery_plans.product_primary_id = st_products.product_primary_id 
            INNER JOIN pp_machinery ON pd_schedule_machinery_plans.machinery_id = pp_machinery.machinery_id
            LEFT JOIN pp_customer_order_plans_data ON pd_schedule_machinery_plans.customer_order_plan_data_id = pp_customer_order_plans_data.customer_order_plan_data_id
            LEFT JOIN pp_customer_order_plans ON pp_customer_order_plans_data.customer_order_plan_id = pp_customer_order_plans.customer_order_plan_id
            LEFT JOIN pp_customer_orders ON pp_customer_order_plans.order_id = pp_customer_orders.order_id 
            GROUP BY pd_schedule_machinery_plans.date,pd_schedule_machinery_plans.customer_order_plan_data_id,st_products.product_primary_id ';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "loadProductionPlanToCalander", "Found", $result);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "loadProductionPlanToCalander", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    function getMachineryShifts($id){
        try {
            $query = 'SELECT DISTINCT hr_att_shifts.shift_id,
            hr_att_shifts.shift_name 
            FROM hr_att_shifts 
            INNER JOIN pd_schedule_machinery_plans ON hr_att_shifts.shift_id = pd_schedule_machinery_plans.shift_id
            WHERE pd_schedule_machinery_plans.customer_order_plan_data_id = "' . $id . '"';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "getMachineryShifts", "Found", $result);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getMachineryShifts", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function getProductUnits(){
        try {
            $product_units = ProductUnit::all();
            $responseBody = $this->responseBody(true, "ProductionAllocateMachineController", "getProductUnits", $product_units);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "getMachineryShifts", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }


    

}

