<?php

namespace Modules\Pd\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Pp\Entities\Machinary;
use Modules\St\Entities\Product;

class ProductionBreakdownReportController extends Controller
{
    public function allSettings()
    {
        try {

            $machine = Machinary::all();
            $responseBody = $this->responseBody(true, "ProductionBreakdownReportController", "allSettings", $machine);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionBreakdownReportController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }




    public function productionBreakdownReport($search_option, $date_from, $date_to)
    {

        try {
            $search_option_aaray =  json_decode($search_option);
            $machine = $search_option_aaray->machine;
            $status = $search_option_aaray->status;


            // $query = 'SELECT hr_employee_sites.site AS factory,
            // pd_production_machine_breakdowns.date,
            // MONTH(pd_production_machine_breakdowns.date) AS month,
            // pd_production_machine_breakdowns.breakdown_time AS time,
            // CONCAT(pp_machinery.machinery_no,"-",pp_machinery.machinery_name) AS machine_name,
		    // ABS(ROUND(IF(pd_production_machine_breakdowns.`status` = 1,TIMESTAMPDIFF(SECOND, pd_production_machine_breakdowns.breakdown_time, pd_production_machine_breakdowns.recovered_time),TIMESTAMPDIFF(SECOND,pd_production_machine_breakdowns.breakdown_time,NOW())) / 3600,1)) AS hours,
            // pd_breakdown_reasons.reason
            // FROM pd_production_machine_breakdowns
            // INNER JOIN pp_machinery ON pd_production_machine_breakdowns.machinery_id = pp_machinery.machinery_id
            // INNER JOIN hr_employee_sites ON pp_machinery.site_id = hr_employee_sites.site_id
            // INNER JOIN pd_breakdown_reasons ON pd_production_machine_breakdowns.breakdown_reason_id = pd_breakdown_reasons.id
            // WHERE pd_production_machine_breakdowns.date BETWEEN "' . $date_from . '" AND "' . $date_to . '" ';

           $query = 'SELECT st_factories.name AS factory,
                            pd_production_machine_breakdowns.date,
                            pd_production_machine_breakdowns.note,
                            MONTH(pd_production_machine_breakdowns.date) AS month,
                            pd_production_machine_breakdowns.breakdown_time AS time,
                            CONCAT(pp_machinery.machinery_no," - ",pp_machinery.machinery_name) AS machine_name,
                            CONCAT(
                                FLOOR(TIMESTAMPDIFF(SECOND, 
                                    pd_production_machine_breakdowns.breakdown_time, 
                                    IF(pd_production_machine_breakdowns.status = 1, pd_production_machine_breakdowns.recovered_time, NOW())
                                ) / 86400), "d ",
                                FLOOR(MOD(TIMESTAMPDIFF(SECOND, 
                                    pd_production_machine_breakdowns.breakdown_time, 
                                    IF(pd_production_machine_breakdowns.status = 1, pd_production_machine_breakdowns.recovered_time, NOW())
                                ), 86400) / 3600), "h ",
                                FLOOR(MOD(TIMESTAMPDIFF(SECOND, 
                                    pd_production_machine_breakdowns.breakdown_time, 
                                    IF(pd_production_machine_breakdowns.status = 1, pd_production_machine_breakdowns.recovered_time, NOW())
                                ), 3600) / 60), "m"
                            ) AS hours,
                            pd_breakdown_reasons.reason
                    FROM pd_production_machine_breakdowns
                    INNER JOIN pp_machinery ON pd_production_machine_breakdowns.machinery_id = pp_machinery.machinery_id
                    INNER JOIN st_factories ON pp_machinery.factory_id = st_factories.factory_id
                    INNER JOIN pd_breakdown_reasons ON pd_production_machine_breakdowns.breakdown_reason_id = pd_breakdown_reasons.id
                    WHERE pd_production_machine_breakdowns.date BETWEEN "' . $date_from . '" AND "' . $date_to . '"';


            if ($machine) {
                $query .= 'AND pp_machinery.machinery_id = "' . $machine . '" ';
            }

            if ($status) {
                $query .= 'AND pd_production_machine_breakdowns.status = "' . $status . '" ';
            }
            $production_records = DB::select($query);

   

            $responseBody = $this->responseBody(true, "ProductionRecordsReportController", "productionRecordsReport", $production_records);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "ProductionRecordsReportController", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }





    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
