<?php

namespace Modules\Pd\Http\Controllers;

use App\Http\Controllers\OrderStatusHistoryController;
use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Pd\Entities\ProductionRecordSupervisorOutside;
use Modules\Pp\Entities\CustomerOrder;
use Modules\Pp\Entities\CustomerPlanData;
use Modules\St\Entities\OutsideFactory;

class ProductionRecordSupervisorOutsideController extends Controller
{
    public function manufacturingOrderNumber($id)
    {
        try {
            //$result = CustomerPlan::select(['customer_order_plan_id', 'manufacturing_order_number'])->join('pp_customer_orders', 'pp_customer_orders.order_id', 'pp_customer_order_plans.order_id')->where('production_status', '=', '2')->get();

            $query = 'SELECT DISTINCT pd_schedule_customer_order_plans.customer_order_plan_id,
            pd_schedule_customer_order_plan_data.customer_order_plan_data_id,
            pd_schedule_customer_order_plans.manufacturing_order_number,
            st_products.product_name FROM pd_schedule_customer_order_plans
            INNER JOIN pd_schedule_customer_order_plan_data ON pd_schedule_customer_order_plans.customer_order_plan_id = pd_schedule_customer_order_plan_data.customer_order_plan_id
            INNER JOIN pd_schedule_outside_factories ON pd_schedule_customer_order_plan_data.customer_order_plan_data_id = pd_schedule_outside_factories.customer_order_plan_data_id
            INNER JOIN st_products ON pd_schedule_customer_order_plan_data.product_id = st_products.product_primary_id
            WHERE pd_schedule_outside_factories.outside_factory_id = "' . $id . '"';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "ProductionRecordSupervisorOutsideController", "productionSupervisor", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionRecordSupervisorOutsideController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function outsideFactories()
    {
        try {
            $result = OutsideFactory::all();
            $responseBody = $this->responseBody(true, "ProductionRecordSupervisorOutsideController", "outsideFactories", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionRecordSupervisorOutsideController", "outsideFactories", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function save(Request $request)
    {
        try {
            $outside = new ProductionRecordSupervisorOutside();
            $outside->customer_order_plan_data_id = $request->get('manufacturing_order_no');
            $outside->outside_factory_id = $request->get('factory_id');
            $outside->date = $request->get('date');
            $outside->quantity = $request->get('quantity');
            $outside->remark = $request->get('remark');
            if ($outside->save()) {

                $query = 'SELECT pp_customer_orders.order_id,
                pp_customer_orders.production_status
                FROM pp_customer_orders 
                INNER JOIN pp_customer_orders_data ON pp_customer_orders.order_id = pp_customer_orders_data.order_id
                INNER JOIN pd_schedule_customer_order_plan_data ON pp_customer_orders_data.order_data_id = pd_schedule_customer_order_plan_data.order_data_id
                WHERE pd_schedule_customer_order_plan_data.customer_order_plan_data_id = "' . $outside->customer_order_plan_data_id . '"';
                $result = DB::select($query);
                foreach ($result as $res) {
                    if ($res->production_status == 2) {
                        $order = CustomerOrder::find($res->order_id);
                        if ($order) {
                            $order->production_status = 3;
                            $order->update();
                        }

                        $customer_plan_data = CustomerPlanData::find($outside->customer_order_plan_data_id);
                        if($customer_plan_data){
                            $customer_plan_data->production_status = 3;
                            if($customer_plan_data->update()){
                                OrderStatusHistoryController::changeProductionStatus($customer_plan_data);
                            } 
                        }

                    }
                }
            }
            $responseBody = $this->responseBody(true, "ProductionRecordSupervisorOutsideController", "save", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionRecordSupervisorOutsideController", "save", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function update(Request $request, $id)
    {
        try {
            $outside = ProductionRecordSupervisorOutside::find($id);
            $outside->customer_order_plan_data_id = $request->get('manufacturing_order_no');
            $outside->outside_factory_id = $request->get('factory_id');
            $outside->date = $request->get('date');
            $outside->quantity = $request->get('quantity');
            $outside->remark = $request->get('remark');
            $outside->update();
            $responseBody = $this->responseBody(true, "ProductionRecordSupervisorOutsideController", "update", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionRecordSupervisorOutsideController", "update", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function getOutside($id)
    {
        try {
            $outside = ProductionRecordSupervisorOutside::find($id);
            $responseBody = $this->responseBody(true, "ProductionRecordSupervisorOutsideController", "getOutside", $outside);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionRecordSupervisorOutsideController", "getOutside", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function delete($id)
    {
        try {
            $outside = ProductionRecordSupervisorOutside::find($id);
            if ($outside) {
                $outside->delete();
            }
            $responseBody = $this->responseBody(true, "ProductionRecordSupervisorOutsideController", "delete", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionRecordSupervisorOutsideController", "delete", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function allOutsideFactories()
    {
        try {
            $query = 'SELECT pd_production_record_supervisor_outsides.*,
            pp_customer_order_plans_data.manufacturing_order_no,
            st_outside_factories.`name`,
            st_outside_factories.factory_id 
            FROM pd_production_record_supervisor_outsides
            INNER JOIN pp_customer_order_plans_data ON pd_production_record_supervisor_outsides.customer_order_plan_data_id = pp_customer_order_plans_data.customer_order_plan_data_id
            INNER JOIN st_outside_factories ON pd_production_record_supervisor_outsides.outside_factory_id = st_outside_factories.outside_factory_id';
            $outsides = DB::select($query);
            $responseBody = $this->responseBody(true, "ProductionRecordSupervisorOutsideController", "getOutside", $outsides);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionRecordSupervisorOutsideController", "getOutside", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function status_change(Request $request,$id)
    {
        try {
            $outside = ProductionRecordSupervisorOutside::find($id);
            if($outside){
                $outside->status = $request->get('status');
                $outside->update();
            }
            $responseBody = $this->responseBody(true, "ProductionRecordSupervisorOutsideController", "status_change", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionRecordSupervisorOutsideController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
