<?php

namespace Modules\Pd\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\AttShift;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Pp\Entities\CustomerOrder;
use Modules\Pp\Entities\Machinary;
use Modules\St\Entities\Product;

class ProductionRecordsReportController extends Controller
{

    public function allSettings()
    {
        try {
            $factory = EmployeeSite::all();
            //$factory_order = CustomerOrder::all();
            $factory_order = $this->getFactoryPO();
            $factory_po = [];
            foreach ($factory_order as $po) {
                array_push($factory_po, [
                    "img" => "",
                    "id" => $po->factory_po_num,
                    "value" => $po->factory_po_num,
                ]);
            }
            $machine = Machinary::all();
            $officer = Employee::where('designation_id', '26')->get();
            $product = Product::all();
            $responseBody = $this->responseBody(true, "ProductionRecordsReportController", "allSettings", ["factory" => $factory, "factory_order" => $factory_po, "machine" => $machine, "officer" => $officer, "product" => $product]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductionRecordsReportController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }



    public function productionRecordsReport($search_option, $date_from, $date_to)
    {

        try {
            $search_option_aaray =  json_decode($search_option);
            $factory = $search_option_aaray->factory;
            $factory_order = $search_option_aaray->factory_order;
            $machine = $search_option_aaray->machine;
            $officer = $search_option_aaray->officer;
            $product = $search_option_aaray->product;


            $query = 'SELECT
            pd_production_records_supervisor.id,
            pd_production_records_supervisor.date,
            pp_customer_orders.factory_po_num AS factory_po_num,
            pp_machinery.machinery_name,
            hr_employee_sites.site,
            CONCAT(pp_machinery.machinery_no,"-",pp_machinery.machinery_name) AS machinery_name,
            hr_employees.name_withinitial AS officer,
            pd_production_records_supervisor.`hour` AS time_period,
            pd_production_records_supervisor.quantity AS actual_production,
            pd_production_records_supervisor.remark,
            hr_att_shifts.shift_name,
            hr_att_shifts.shift_id,
            "0" AS target_production,
            pd_schedule_machinery_plans.from,
            pd_schedule_machinery_plans.to,
            pd_schedule_machinery_plans.quantity
            FROM pd_production_records_supervisor
            LEFT JOIN pd_schedule_customer_order_plan_data ON pd_production_records_supervisor.customer_order_plan_data_id = pd_schedule_customer_order_plan_data.customer_order_plan_data_id
            LEFT JOIN pd_schedule_customer_order_plans ON pd_schedule_customer_order_plan_data.customer_order_plan_id = pd_schedule_customer_order_plans.customer_order_plan_id
            INNER JOIN pp_customer_orders ON pd_schedule_customer_order_plans.order_id = pp_customer_orders.order_id
            LEFT JOIN pp_machinery ON pd_production_records_supervisor.machinery_id = pp_machinery.machinery_id
            LEFT JOIN hr_employee_sites ON pp_machinery.site_id = hr_employee_sites.site_id
            LEFT JOIN hr_employees ON pd_production_records_supervisor.employee_id = hr_employees.employee_id
            LEFT JOIN pd_schedule_machinery_plans ON pd_production_records_supervisor.machinery_id = pd_schedule_machinery_plans.machinery_id
            LEFT JOIN hr_att_shifts ON pd_production_records_supervisor.shift_id =  hr_att_shifts.shift_id WHERE pd_production_records_supervisor.date BETWEEN "' . $date_from . '" AND "' . $date_to . '" ';
            if ($factory) {
                $query .= 'AND hr_employee_sites.site_id = "' . $factory . '" ';
            }
            if ($factory_order) {
                $query .= 'AND pp_customer_orders.factory_po_num = "' . $factory_order . '" ';
            }
            if ($machine) {
                $query .= 'AND pp_machinery.machinery_id = "' . $machine . '" ';
            }
            if ($officer) {
                $query .= 'AND hr_employees.employee_id = "' . $officer . '" ';
            }
            if ($officer) {
                $query .= 'AND st_products.product_primary_id = "' . $product . '" ';
            }
            $query .= 'GROUP BY pd_production_records_supervisor.id';
            $production_records = DB::select($query);

            foreach ($production_records as $production_record) {

                $att_shift = AttShift::find($production_record->shift_id);
                $from = 0;
                if ($production_record->from != null) {
                    $from = $production_record->from;
                }
                $to = 0;
                if ($production_record->to != null) {
                    $to = $production_record->to;
                }
                $quantity = 0;
                if ($production_record->quantity != null) {
                    $quantity = $production_record->quantity;
                }
                $hours = ($to - $from);
                if ($hours != 0) {
                    if ($att_shift) {
                        $HH = explode(":", $att_shift->start_time)[0];
                        $MM = explode(":", $att_shift->start_time)[1];
                        $SS = explode(":", $att_shift->start_time)[2];
                        $MM += ($SS / 60.0);
                        $HH += ($MM / 60.0);
                        $TO_HH = ($HH + $att_shift->duration);
                        if ($hours >= $TO_HH) {
                            $hours -= $att_shift->break_hours;
                        }
                    }
                    $production_record->target_production = $quantity / $hours;
                }
            }


            $responseBody = $this->responseBody(true, "ProductionRecordsReportController", "productionRecordsReport", $production_records);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "ProductionRecordsReportController", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }


    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }



    private function getFactoryPO()
    {
        $query = 'SELECT
        pp_customer_orders.factory_po_num AS factory_po_num
        FROM pd_production_records_supervisor
        LEFT JOIN pd_schedule_customer_order_plan_data ON pd_production_records_supervisor.customer_order_plan_data_id = pd_schedule_customer_order_plan_data.customer_order_plan_data_id
        LEFT JOIN pd_schedule_customer_order_plans ON pd_schedule_customer_order_plan_data.customer_order_plan_id = pd_schedule_customer_order_plans.customer_order_plan_id
        INNER JOIN pp_customer_orders ON pd_schedule_customer_order_plans.order_id = pp_customer_orders.order_id
        LEFT JOIN st_products ON pd_production_records_supervisor.product_primary_id = st_products.product_primary_id  GROUP BY pp_customer_orders.order_id ORDER BY pd_production_records_supervisor.id DESC';

        return DB::select($query);
    }
}
