<?php

namespace Modules\Pd\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;

class ProductionScheduleCalendarController extends Controller
{
    function loadProductionPlanToCalander()
    {
        try {
            $query = 'SELECT pp_customer_orders.factory_po_num AS factory_po,pp_customer_orders.purchase_order AS customer_po,SUM(pd_schedule_machinery_plans.quantity) AS quantity,
            st_products.product_id,
            st_products.product_name,
            pd_schedule_machinery_plans.date AS start_date,
            pd_schedule_machinery_plans.date AS end_date,
            pp_machinery.machinery_no,pp_machinery.machinery_name,
			(SELECT IF(pd_production_machine_breakdowns.`status` = 0,"(B.D)","")  FROM pd_production_machine_breakdowns WHERE pd_production_machine_breakdowns.machinery_id = pp_machinery.machinery_id AND pd_production_machine_breakdowns.date = pd_schedule_machinery_plans.date ) AS breakdown
            FROM pd_schedule_machinery_plans
            INNER JOIN st_products ON pd_schedule_machinery_plans.product_primary_id = st_products.product_primary_id INNER JOIN pp_machinery ON pd_schedule_machinery_plans.machinery_id = pp_machinery.machinery_id
            LEFT JOIN pd_schedule_customer_order_plan_data ON pd_schedule_machinery_plans.customer_order_plan_data_id = pd_schedule_customer_order_plan_data.customer_order_plan_data_id
            LEFT JOIN pd_schedule_customer_order_plans ON pd_schedule_customer_order_plan_data.customer_order_plan_id = pd_schedule_customer_order_plans.customer_order_plan_id
            LEFT JOIN pp_customer_orders ON pd_schedule_customer_order_plans.order_id = pp_customer_orders.order_id GROUP BY pd_schedule_machinery_plans.date,pd_schedule_machinery_plans.customer_order_plan_data_id,st_products.product_primary_id';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "loadProductionPlanToCalander", "Found", $result);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "loadProductionPlanToCalander", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
