<?php

namespace Modules\Pd\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\AttShift;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Pd\Entities\BreakdownReason;
use Modules\Pd\Entities\DailyProduction;
use Modules\Pd\Entities\ProductionMachineBreakdown;
use Modules\Pd\Entities\ProductionRecordsSupervisor;
use Modules\Pd\Entities\ReasonOfBreakdown;
use Modules\Pp\Entities\CustomerPlan;
use Modules\Pp\Entities\Machinary;
use Modules\St\Entities\Factory;
use Modules\St\Entities\Product;

class ReasonOfBreakdownController extends Controller
{
    public function productionSupervisor()
    {
        try {
            $employees = Employee::all();
            $result = array();
            foreach ($employees as $emp) {
                array_push($result, [
                    "img" => "",
                    "id" => $emp->employee_id,
                    "value" => $emp->name_withinitial,
                ]);
            }
            $responseBody = $this->responseBody(true, "ReasonOfBreakdownController", "productionSupervisor", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReasonOfBreakdownController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function manufacturingOrderNumber($date)
    {
        try {
            //$result = CustomerPlan::select(['customer_order_plan_id', 'manufacturing_order_number'])->join('pp_customer_orders', 'pp_customer_orders.order_id', 'pp_customer_order_plans.order_id')->where('production_status', '=', '2')->get();

            $query = 'SELECT DISTINCT pd_schedule_customer_order_plans.customer_order_plan_id,
            pd_schedule_customer_order_plan_data.customer_order_plan_data_id,
            pd_schedule_customer_order_plans.manufacturing_order_number,
            st_products.product_name
            FROM pd_schedule_customer_order_plans
            INNER JOIN pp_customer_orders ON pd_schedule_customer_order_plans.order_id = pp_customer_orders.order_id
            INNER JOIN pd_schedule_customer_order_plan_data ON pd_schedule_customer_order_plans.customer_order_plan_id = pd_schedule_customer_order_plan_data.customer_order_plan_id
            INNER JOIN pd_schedule_machinery_plans ON pd_schedule_customer_order_plan_data.customer_order_plan_data_id = pd_schedule_machinery_plans.customer_order_plan_data_id
            INNER JOIN st_products ON pd_schedule_customer_order_plan_data.product_id = st_products.product_primary_id
            WHERE pd_schedule_machinery_plans.date = "' . $date . '"';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "ReasonOfBreakdownController", "productionSupervisor", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReasonOfBreakdownController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function product($id)
    {
        try {
            $query = 'SELECT DISTINCT st_products.product_id,st_products.product_primary_id,st_products.product_name FROM pp_machinery_plans INNER JOIN pp_customer_order_plans_data ON pp_machinery_plans.customer_order_plan_data_id = pp_customer_order_plans_data.customer_order_plan_data_id
             INNER JOIN st_products ON pp_machinery_plans.product_primary_id = st_products.product_primary_id
             WHERE pp_customer_order_plans_data.customer_order_plan_data_id = "' . $id . '"';
            $result = DB::select($query);
            $data = [];
            for ($j = 0; $j < count($result); $j++) {
                array_push($data, [
                    "img" => "",
                    "id" => $result[0]->product_primary_id,
                    "value" => $result[0]->product_name,
                ]);
            }
            $responseBody = $this->responseBody(true, "ReasonOfBreakdownController", "product", $data);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReasonOfBreakdownController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function machine($id)
    {
        try {
            $machines =  Machinary::where('factory_id', '=', $id)->get();

            $responseBody = $this->responseBody(true, "ReasonOfBreakdownController", "machine", $machines);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReasonOfBreakdownController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }


    public function save(Request $request)
    {

        try {
            $reasonOfBreakdown = new ProductionMachineBreakdown();
            $factory = Factory::find($request->get('site_id'));
            if ($factory) {
                $reasonOfBreakdown->site_id = $factory->site_id;
            } else {
                $reasonOfBreakdown->site_id = 0;
            }

            $reasonOfBreakdown->machinery_id = $request->get('machine_id');
            $reasonOfBreakdown->date = explode(" ", $request->get('breakdown_time'))[0];
            $reasonOfBreakdown->breakdown_time = $request->get('breakdown_time');
            $reasonOfBreakdown->breakdown_reason_id = $request->get('breakdown_reason_id');
            $reasonOfBreakdown->note = $request->get('note');
            $reasonOfBreakdown->save();
            $responseBody = $this->responseBody(true, "ReasonOfBreakdownController", "save", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReasonOfBreakdownController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }



    public function getDailyProduction($id)
    {
        try {
            $productionRecordsSupervisor = ProductionMachineBreakdown::find($id);

            // $factory = Factory::where('site_id', '=', $productionRecordsSupervisor->site_id)->first();
            // if ($factory) {
            //     $productionRecordsSupervisor->factory_id = $factory->factory_id;
            // }

            if ($productionRecordsSupervisor) {
                // Get machinery record
                $machinery = Machinary::find($productionRecordsSupervisor->machinery_id);
                if ($machinery) {
                    $factory = Factory::find($machinery->factory_id);
                    if ($factory) {
                        $productionRecordsSupervisor->factory_id = $factory->factory_id;
                        $productionRecordsSupervisor->factory = $factory;
                    }
                }
            }

            $responseBody = $this->responseBody(true, "ReasonOfBreakdownController", "getDailyProduction", $productionRecordsSupervisor);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReasonOfBreakdownController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function getShift($id, $date)
    {
        try {
            $query = 'SELECT DISTINCT hr_att_shifts.shift_id,hr_att_shifts.shift_name
            FROM hr_att_shifts INNER JOIN pd_schedule_machinery_plans ON hr_att_shifts.shift_id = pd_schedule_machinery_plans.shift_id 
            WHERE pd_schedule_machinery_plans.machinery_id = "' . $id . '" AND pd_schedule_machinery_plans.date = "' . $date . '"';
            $shift = DB::select($query);
            $responseBody = $this->responseBody(true, "ReasonOfBreakdownController", "getShift", $shift);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReasonOfBreakdownController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function allSite()
    {
        try {
            $factory = Factory::all();
            $responseBody = $this->responseBody(true, "ReasonOfBreakdownController", "allSite", $factory);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReasonOfBreakdownController", "allSite", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function allReason()
    {

        try {
            $reasonOfBreakdowns = BreakdownReason::where('status', '=', 1)->get();
            $responseBody = $this->responseBody(true, "ReasonOfBreakdownController", "allReason", $reasonOfBreakdowns);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReasonOfBreakdownController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }



    public function update(Request $request, $id)
    {

        try {
            $reasonOfBreakdown = ProductionMachineBreakdown::find($id);
            $factory = Factory::find($request->get('site_id'));
            if ($factory) {
                $reasonOfBreakdown->site_id = $factory->site_id;
            } else {
                $reasonOfBreakdown->site_id = 0;
            }
            $reasonOfBreakdown->machinery_id = $request->get('machine_id');
            $reasonOfBreakdown->breakdown_time = $request->get('breakdown_time');
            $reasonOfBreakdown->breakdown_reason_id = $request->get('breakdown_reason_id');
            $reasonOfBreakdown->note = $request->get('note');


            $reasonOfBreakdown->recovered_time = $request->get('recovered_time');
            $reasonOfBreakdown->recovery_details = $request->get('recovery_details');
            $reasonOfBreakdown->technical_instruction = $request->get('technical_instruction');
            $reasonOfBreakdown->status = $request->get('status');
            $reasonOfBreakdown->update();
            $responseBody = $this->responseBody(true, "ReasonOfBreakdownController", "update", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReasonOfBreakdownController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }



    public function allDailyProduction()
    {

        try {
            /*$query = 'SELECT pd_daily_productions.daily_production_id,pd_daily_productions.refferance_no,pp_customer_order_plans.manufacturing_order_number,hr_employees.name_withinitial AS supervisor FROM pd_daily_productions
            INNER JOIN pp_customer_order_plans ON pd_daily_productions.customer_order_plan_id = pp_customer_order_plans.customer_order_plan_id
            INNER JOIN hr_employees ON pd_daily_productions.supervisor_id = hr_employees.employee_id';*/
            $query = 'SELECT pd_production_machine_breakdowns.id,
            pd_production_machine_breakdowns.breakdown_time,
            pd_production_machine_breakdowns.status,
            pp_machinery.machinery_name,
            hr_employee_sites.site
            FROM pd_production_machine_breakdowns
            INNER JOIN pp_machinery ON pd_production_machine_breakdowns.machinery_id = pp_machinery.machinery_id
            INNER JOIN hr_employee_sites ON pd_production_machine_breakdowns.site_id = hr_employee_sites.site_id
            GROUP BY pd_production_machine_breakdowns.id ORDER BY pd_production_machine_breakdowns.id DESC';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "ReasonOfBreakdownController", "allDailyProduction", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReasonOfBreakdownController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }


    public function delete($id)
    {
        try {
            $dailyProduction = ProductionMachineBreakdown::find($id);
            $isDelete = false;
            if ($dailyProduction) {
                $isDelete = $dailyProduction->delete();
            }
            $responseBody = $this->responseBody(true, "ReasonOfBreakdownController", "delete", $isDelete);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReasonOfBreakdownController", "error", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
