<?php

namespace Modules\Pd\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Pd\Entities\ProductionStatus;
use Modules\Pd\Entities\ScheduleCustomerOrderPlan;
use Modules\Pd\Entities\ScheduleCustomerOrderPlanData;
use Modules\Pd\Entities\ScheduleMachineryPlan;
use Modules\Pd\Entities\ScheduleOrderResourceBom;
use Modules\Pd\Entities\ScheduleOrderResourceHr;
use Modules\Pp\Entities\CustomerOrder;
use Modules\Pp\Entities\CustomerPlan;
use Modules\Pp\Entities\CustomerPlanData;

class ScheduleStatusController extends Controller
{
    public function productionPlan()
    {
        try {
            $query = 'SELECT 
            pd_schedule_customer_order_plans.trans_date,
            pd_schedule_customer_order_plans.customer_order_plan_id,
            pp_customer_orders.purchase_order,
            pp_customer_orders.factory_po_num,
            pp_customer_orders.order_id,
            pp_customer_orders.production_status,
            st_products.product_id,
            st_products.product_name,
            MIN(pd_schedule_machinery_plans.date) AS from_date,
            MAX(pd_schedule_machinery_plans.date) AS to_date,
            hr_employee_sites.site AS factory,
            pd_schedule_machinery_plans.machinery_plan_id,
            pd_schedule_machinery_plans.machinery_id,
            pd_schedule_machinery_plans.product_primary_id,
            pd_schedule_machinery_plans.customer_order_plan_data_id
            FROM pd_schedule_customer_order_plans
            LEFT JOIN pp_customer_orders ON pd_schedule_customer_order_plans.order_id = pp_customer_orders.order_id
            LEFT JOIN pd_schedule_customer_order_plan_data ON pd_schedule_customer_order_plans.customer_order_plan_id = pd_schedule_customer_order_plan_data.customer_order_plan_id
            LEFT JOIN st_products ON pd_schedule_customer_order_plan_data.product_id = st_products.product_primary_id
            LEFT JOIN pd_schedule_machinery_plans ON pd_schedule_customer_order_plan_data.customer_order_plan_data_id = pd_schedule_machinery_plans.customer_order_plan_data_id
            LEFT JOIN pp_machinery ON pd_schedule_machinery_plans.machinery_id = pp_machinery.machinery_id
            LEFT JOIN hr_employee_sites ON pp_machinery.site_id = hr_employee_sites.site_id WHERE pp_customer_orders.production_status >= "2" GROUP BY pd_schedule_customer_order_plans.schedule_customer_order_plan_id ORDER BY pd_schedule_customer_order_plans.customer_order_plan_id DESC';
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "ScheduleStatusController", "productionPlan", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ScheduleStatusController", "productionPlan", $exception->getMessage());
        }

        return response()->json(["data" => $responseBody]);
    }



    public function production_status_start(Request $request)
    {
        try {

            $id = $request->get('id');
            $customer_order = CustomerOrder::find($id);
            if ($customer_order) {
                $customer_order->production_status = 3;
                $customer_order->update();
            }
            $responseBody = $this->responseBody(true, "ScheduleStatusController", "production status", 'Start');
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function production_status_hold(Request $request)
    {
        try {

            $id = $request->get('id');
            $customer_order = CustomerOrder::find($id);
            if ($customer_order) {
                $customer_order->production_status = 4;
                $customer_order->update();
            }
            $responseBody = $this->responseBody(true, "ScheduleStatusController", "production status", 'Hold');
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function production_status_finished(Request $request)
    {
        try {

            $id = $request->get('id');
            $customer_order = CustomerOrder::find($id);
            if ($customer_order) {
                $customer_order->production_status = 5;
                $customer_order->update();
            }
            $responseBody = $this->responseBody(true, "ScheduleStatusController", "production status", 'Finished');
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function production_status_delivered(Request $request)
    {
        try {

            $id = $request->get('id');
            $customer_order = CustomerOrder::find($id);
            if ($customer_order) {
                $customer_order->production_status = 6;
                $customer_order->update();
            }
            $responseBody = $this->responseBody(true, "ScheduleStatusController", "production status", 'Delivered');
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function getProductionStatus()
    {
        try {

            $status = ProductionStatus::all();
            $responseBody = $this->responseBody(true, "ScheduleStatusController", "getProductionStatus", $status);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "ScheduleStatusController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
