class MachineryModal {

    static ORDER_PLAN_DATA_ID = 0;
    static PRODUCT_PRIMARY_ID = 0;
    static QUANTITY_PER_HOUR = 0;
    constructor(parent) {

        $.ajax({
            url: 'MachineryModal',
            type: 'GET',
            async: false,
            success: function (data) {
                parent.html($(data).find('#modal').html());
            }
        });




    }


    show() {
        $('#cmbFactory').on('change', function () {
            MachineryModal.QUANTITY_PER_HOUR = MachineryModal.quantityPerHour($('#cmbMachine').val());
            MachineryModal.getAllocatedSummaryData(MachineryModal.ORDER_PLAN_DATA_ID, MachineryModal.PRODUCT_PRIMARY_ID, $('#cmbMachine').val(), $(this).val());
            MachineryModal.loadMachinesToFactory($(this).val());
        
        });

        $('#cmbMachine').on('change', function () {
            MachineryModal.QUANTITY_PER_HOUR = MachineryModal.quantityPerHour($(this).val());
            MachineryModal.getAllocatedSummaryData(MachineryModal.ORDER_PLAN_DATA_ID, MachineryModal.PRODUCT_PRIMARY_ID, $(this).val(), $('#cmbFactory').val());
        });

        $('#machinePlanModal').modal('show');
    }

    hide() {
        $('#machinePlanModal').modal('hide');
    }



    getSelectedModalData(order_plan_data_id, product_primary_id) {

        MachineryModal.ORDER_PLAN_DATA_ID = order_plan_data_id;
        MachineryModal.PRODUCT_PRIMARY_ID = product_primary_id;
        $.ajax({
            type: 'GET',
            url: '/pd/ProductionScheduleCreateController/getSelectedProductData/' + order_plan_data_id + "/" + product_primary_id,
            async: false,
            success: function (response) {
                console.log(response.data.result);
                if (response.data.success) {
                    $('#lblProductCode').text(": " + response.data.result.product_code);
                    $('#lblProductName').text(": " + response.data.result.product_name);
                    $('#lblFactoryPO').text(": " + response.data.result.factory_po);
                    $('#lblCustomerPO').text(": " + response.data.result.customer_po);
                    $('#lblProductionQty').text(": " + response.data.result.quantity);
                    $('#lblAllocateQty').text(": " + response.data.result.allocated_quantity);
                    var factory = response.data.result.factory;
                    $('#cmbFactory').empty();
                    $('#lblFactory').text("Factory : (" + factory.length + ")");
                    console.log(factory);
                    for (var i = 0; i < factory.length; i++) {
                        var factory_name = factory[i]["name"];
                        $('#cmbFactory').append("<option value=" + factory[i]["factory_id"] + ">" + factory_name + "</option>");
                    }

                    var ordered_factory = response.data.result.ordered_factory;
                    if (ordered_factory.length > 0) {
                        setSelectedOption('cmbFactory', ordered_factory[0].factory_id);
                        $('#cmbFactory').change();
                    }

                    MachineryModal.loadMachinesToFactory($('#cmbFactory').val());

                   /* var machine = response.data.result.machine;
                    $('#cmbMachine').empty();
                    $('#lblMachine').text("Machine : (" + machine.length + ")");
                    for (var i = 0; i < machine.length; i++) {
                        var machinery_name = machine[i]["machinery_no"] + "-" + machine[i]["machinery_name"];
                        $('#cmbMachine').append("<option value=" + machine[i]["machinery_id"] + ">" + machinery_name + "</option>");
                    }*/

                    MachineryModal.QUANTITY_PER_HOUR = MachineryModal.quantityPerHour($('#cmbMachine').val());
                    MachineryModal.getAllocatedSummaryData(order_plan_data_id, product_primary_id, $('#cmbMachine').val(), $('#cmbFactory').val());

                }

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();
            },
            complete: function () {

            }
        });
    }


    static loadMachinesToFactory(id) {
        $.ajax({
            type: 'GET',
            url: '/pd/ProductionScheduleCreateController/loadMachinesToFactory/' + id,
            async: false,
            success: function (response) {
                console.log(response.result)
                if (response.success) {
                    $('#cmbMachine').empty();
                    //$('#lblMachineEdit').text("Machine : (" + response.result.length + ")");
                    $('#cmbMachine').append('<option selected disabled>--Select Here--</option>');
                    for (i = 0; i < response.result.length; i++) {
                        var id = response.result[i]['machinery_id'];
                        var no = response.result[i]['machinery_no'];
                        var name = response.result[i]['machinery_name'];
                        var nn = no + "-" + name;
                        $('#cmbMachine').append('<option value="' + id + '">' + nn + '</option>');
                    }


                }
            }, error: function (data) {
                console.log('something went wrong');
            }
        });
    }



    static getAllocatedSummaryData(order_id, product_id, machine_id, site_id) {

        $.ajax({
            type: 'GET',
            url: '/pd/ProductionScheduleCreateController/getAllocatedMachineData/' + order_id + "/" + product_id + "/" + machine_id + "/" + site_id,
            async: false,
            beforeSend: function () {
                //progress(true);
            },
            success: function (response) {
                console.log(response.data.result);
                $('#tblAllocateProduct').empty();
                if (response.data.success) {

                    var result_arr = [];
                    for (i = 0; i < response.data.result.length; i++) {
                        var date = response.data.result[i]['date'];
                        var from = response.data.result[i]['from'];
                        var to = response.data.result[i]['to'];
                        var quantity = response.data.result[i]['quantity'];
                        var maxout = MachineryModal.maxOutPut(from, to);
                        var allocated = MachineryModal.getAllocatedQuantityFromDate(order_id, product_id, machine_id, date, from, to);
                        var shift = response.data.result[i]['shift_name'];

                        var row = '<tr><td>' + date + '</td>';
                        row += '<td>' + from + '</td>';
                        row += '<td>' + to + '</td>';
                        row += '<td style="text-align:right;">' + quantity + '</td>';
                        row += '<td style="text-align:right;">' + maxout + '</td>';
                        row += '<td style="text-align:right;">' + allocated + '</td>';
                        row += '<td>' + shift + '</td></tr>';
                        $('#tblAllocateProduct').append(row);

                    }

                }


            },
            error: function (data) {

            },
            complete: function () {
                //progress(false);
            }
        });

    }



    static maxOutPut(from, to) {

        return (parseFloat(to) - parseFloat(from)) * this.QUANTITY_PER_HOUR;
    }



    static getAllocatedQuantityFromDate(order_id, product_id, machine_id, date, from, to) {

        var quantity = 0;
        $.ajax({
            type: 'GET',
            url: '/pd/ProductionScheduleCreateController/getAllocatedQuantityFromDate/' + order_id + "/" + product_id + "/" + machine_id + "/" + date + "/" + from + "/" + to,
            async: false,
            success: function (response) {
                console.log(response.data.result);
                if (response.data.result != null) {
                    quantity = response.data.result;
                }
            },
            error: function (data) {

            },
            complete: function () {

            }
        });
        return quantity;
    }



    static quantityPerHour(machine_id) {
        var quantity = 0;
        $.ajax({
            type: 'GET',
            url: '/pd/ProductionScheduleCreateController/quantityPerHour/' + machine_id,
            async: false,
            success: function (response) {
                console.log(response.data.result);

                quantity = parseFloat(response.data.result);
            },
            error: function (data) {

            },
            complete: function () {

            }
        });
        return quantity;
    }





}



