class MachineryModal {

    static ORDER_PLAN_DATA_ID = 0;
    static PRODUCT_PRIMARY_ID = 0;
    static QUANTITY_PER_HOUR = 0;
    static FACTORY_IDS = [];
    static MACHINERY_IDS = [];

    constructor(parent) {

        $.ajax({
            url: 'MachineryModal',
            type: 'GET',
            async: false,
            success: function (data) {
                parent.html($(data).find('#modal').html());
            }
        });

    }


    show() {
        $('#cmbFactory').on('change', function () {
            MachineryModal.QUANTITY_PER_HOUR = MachineryModal.quantityPerHour($('#cmbMachine').val());
            MachineryModal.getAllocatedSummaryData(MachineryModal.ORDER_PLAN_DATA_ID, MachineryModal.PRODUCT_PRIMARY_ID, $('#cmbMachine').val(), $(this).val());
            MachineryModal.loadMachinesToFactory($(this).val());
        });

        $('#cmbMachine').on('change', function () {
            MachineryModal.QUANTITY_PER_HOUR = MachineryModal.quantityPerHour($(this).val());
            MachineryModal.getAllocatedSummaryData(MachineryModal.ORDER_PLAN_DATA_ID, MachineryModal.PRODUCT_PRIMARY_ID, $(this).val(), $('#cmbFactory').val());
        });

        $('#machinePlanModal').modal('show');
    }

    hide() {
        $('#machinePlanModal').modal('hide');
    }

    getSelectedModalData(order_plan_data_id, product_primary_id) {

        MachineryModal.ORDER_PLAN_DATA_ID = order_plan_data_id;
        MachineryModal.PRODUCT_PRIMARY_ID = product_primary_id;
        $.ajax({
            type: 'GET',
            url: '/pd/ProductionScheduleCreateController/getSelectedProductData/' + order_plan_data_id + "/" + product_primary_id,
            async: false,
            success: function (response) {
                console.log(response.data.result);
                if (response.data.success) {
                    $('#lblProductCode').text(": " + response.data.result.product_code);
                    $('#lblProductName').text(": " + response.data.result.product_name);
                    $('#lblFactoryPO').text(": " + response.data.result.factory_po);
                    $('#lblCustomerPO').text(": " + response.data.result.customer_po);
                    $('#lblProductionQty').text(": " + response.data.result.quantity);
                    $('#lblAllocateQty').text(": " + response.data.result.allocated_quantity);
                   
                    var factory_id = undefined;
                    var machinery_id = undefined;

                    var ordered_machine = response.data.result.ordered_machine;
                    if (ordered_machine.length > 0) {
                        let factory_ids = [];
                        let machinery_ids = [];

                        // Collect all factory and machinery IDs
                        ordered_machine.forEach(function (machine) {
                            factory_ids.push(machine.factory_id);
                            machinery_ids.push(machine.machinery_id);
                        });

                        // Remove duplicates using Set
                        factory_ids = [...new Set(factory_ids)];
                        machinery_ids = [...new Set(machinery_ids)];

                        // Store in class
                        MachineryModal.FACTORY_IDS = factory_ids;
                        MachineryModal.MACHINERY_IDS = machinery_ids;

                        // Show only allocated factories
                        MachineryModal.showAllocatedFactories(response.data.result.factory);
                        
                        factory_id = factory_ids[0];
                        machinery_id = machinery_ids[0];
                        //set factory value
                        $("#cmbFactory").val(ordered_machine[0].factory_id);
                        $("#cmbFactory").trigger("change");

                        MachineryModal.loadMachinesToFactory(ordered_machine[0].factory_id);
                       
                    }

                    // if (factory_id != undefined && machinery_id != undefined) {
                    //     MachineryModal.QUANTITY_PER_HOUR = MachineryModal.quantityPerHour(machinery_id);
                        
                    //     MachineryModal.getAllocatedSummaryData(
                    //         MachineryModal.ORDER_PLAN_DATA_ID,
                    //         MachineryModal.PRODUCT_PRIMARY_ID,
                    //         machinery_id,
                    //         factory_id
                    //     );
                    // }
                 
                }

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();
            },
            complete: function () {

            }
        });
    }

    static showAllocatedFactories(factories) {
        $('#cmbFactory').empty();
        $('#lblFactory').text("Factory : (" + MachineryModal.FACTORY_IDS.length + ")");
        
        factories.forEach(factory => {
            if (MachineryModal.FACTORY_IDS.includes(parseInt(factory.factory_id))) {
                $('#cmbFactory').append(`<option value="${factory.factory_id}">${factory.name}</option>`);
            }
        });
    }

    static loadMachinesToFactory(id) {
        $.ajax({
            type: 'GET',
            url: '/pd/ProductionScheduleCreateController/loadMachinesToFactory/' + id,
            async: false,
            success: function (response) {
                console.log(response.result)
                if (response.success) {
                    $('#cmbMachine').empty();
                    //$('#lblMachineEdit').text("Machine : (" + response.result.length + ")");
                    $('#cmbMachine').append('<option selected disabled>-- Select Here --</option>');
                    response.result.forEach(machine => {
                        if (MachineryModal.MACHINERY_IDS.includes(parseInt(machine.machinery_id))) {
                            let machineName = `${machine.machinery_no}-${machine.machinery_name}`;
                            $('#cmbMachine').append(`<option value="${machine.machinery_id}">${machineName}</option>`);
                        }
                    });
                }
            }, error: function (data) {
                console.log('something went wrong');
            }
        });
    }


    static getAllocatedSummaryData(order_id, product_id, machine_id, site_id) {

        $.ajax({
            type: 'GET',
            url: '/pd/ProductionScheduleCreateController/getAllocatedMachineData/' + order_id + "/" + product_id + "/" + machine_id + "/" + site_id,
            async: false,
            beforeSend: function () {
                //progress(true);
            },
            success: function (response) {
                console.log(response.data.result);
                $('#tblAllocateProduct').empty();
                if (response.data.success) {

                    var result_arr = [];
                    for (i = 0; i < response.data.result.length; i++) {
                        var date = response.data.result[i]['date'];
                        var from = response.data.result[i]['from'];
                        var to = response.data.result[i]['to'];
                        var quantity = response.data.result[i]['quantity'];
                        var maxout = MachineryModal.maxOutPut(from, to);
                        var allocated = MachineryModal.getAllocatedQuantityFromDate(order_id, product_id, machine_id, date, from, to);
                        var shift = response.data.result[i]['shift_name'];

                        var row = '<tr><td>' + date + '</td>';
                        row += '<td>' + from + '</td>';
                        row += '<td>' + to + '</td>';
                        row += '<td style="text-align:right;">' + quantity + '</td>';
                        row += '<td style="text-align:right;">' + maxout + '</td>';
                        row += '<td style="text-align:right;">' + allocated + '</td>';
                        row += '<td>' + shift + '</td></tr>';
                        $('#tblAllocateProduct').append(row);

                    }

                }


            },
            error: function (data) {

            },
            complete: function () {
                //progress(false);
            }
        });

    }



    static maxOutPut(from, to) {

        return (parseFloat(to) - parseFloat(from)) * this.QUANTITY_PER_HOUR;
    }



    static getAllocatedQuantityFromDate(order_id, product_id, machine_id, date, from, to) {

        var quantity = 0;
        $.ajax({
            type: 'GET',
            url: '/pd/ProductionScheduleCreateController/getAllocatedQuantityFromDate/' + order_id + "/" + product_id + "/" + machine_id + "/" + date + "/" + from + "/" + to,
            async: false,
            success: function (response) {
                console.log(response.data.result);
                if (response.data.result != null) {
                    quantity = response.data.result;
                }
            },
            error: function (data) {

            },
            complete: function () {

            }
        });
        return quantity;
    }



    static quantityPerHour(machine_id) {
        var quantity = 0;
        $.ajax({
            type: 'GET',
            url: '/pd/ProductionScheduleCreateController/quantityPerHour/' + machine_id,
            async: false,
            success: function (response) {
                console.log(response.data.result);

                quantity = parseFloat(response.data.result);
            },
            error: function (data) {

            },
            complete: function () {

            }
        });
        return quantity;
    }





}



