/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 Created on : Dec 2, 2020, 8:24:42 AM
 Author     : Sampath
 */

var components = document.getElementsByClassName('auto-complete');

var component_arr = [];
var selected_input = null;

for (i = 0; i < components.length; i++) {
    components[i].addEventListener("input", keyTypeEvent);
    components[i].setAttribute("data-id", "");
    components[i].setAttribute("autocomplete", "off");
    component_arr.push({
        "inp_id": components[i].id,
        "pop_id": "popup-" + components[i].id,
        "data": [],
    });
}


for (i = 0; i < component_arr.length; i++) {

    autocompleteComponent(component_arr[i].inp_id, component_arr[i].pop_id);
    document.getElementById(component_arr[i].inp_id).addEventListener("mousedown", mousePressedEvent);

}



function autocompleteComponent(inp_id, pop_id) {
    var input = document.getElementById(inp_id);
    var popup = popupWidget(pop_id);


    var parent_row_div = document.createElement("DIV");
    parent_row_div.setAttribute("class", "row");
    input.parentNode.appendChild(parent_row_div);

    var parent_col_div = document.createElement("DIV");
    parent_col_div.setAttribute("class", "col-md-12");
    parent_row_div.appendChild(parent_col_div);

    var child_row1_div = document.createElement("DIV");
    child_row1_div.setAttribute("class", "row");
    parent_col_div.appendChild(child_row1_div);

    var child_col1_div = document.createElement("DIV");
    child_col1_div.setAttribute("class", "col-md-12");
    child_col1_div.appendChild(input);
    child_row1_div.appendChild(child_col1_div);


    var child_row2_div = document.createElement("DIV");
    child_row2_div.setAttribute("class", "row");
    parent_col_div.appendChild(child_row2_div);

    var child_col2_div = document.createElement("DIV");
    child_col2_div.setAttribute("class", "col-md-12");
    child_col2_div.appendChild(popup);
    child_row2_div.appendChild(child_col2_div);


}


function popupWidget(pop_id) {

    var popup = document.createElement("DIV");
    popup.setAttribute("class", "row popup-widget");
    popup.setAttribute("id", pop_id);
    return popup;
}


function mousePressedEvent(event) {

    for (i = 0; i < component_arr.length; i++) {
        if (component_arr[i].inp_id == event.target.id) {
            selected_input = document.getElementById(component_arr[i].inp_id);
            document.getElementById(component_arr[i].pop_id).style.display = "inline-block";
        } else {
            document.getElementById(component_arr[i].pop_id).style.display = "none";
        }
    }

    appendElement(selected_input);

}


window.addEventListener("click", function (event) {


    for (i = 0; i < component_arr.length; i++) {
        if (component_arr[i].inp_id == event.srcElement.id) {
            return;
        }
        document.getElementById(component_arr[i].pop_id).style.display = "none";
    }
});


function setAutocompleteArrayData(id, arrayData) {

    for (i = 0; i < component_arr.length; i++) {
        if (component_arr[i].inp_id == id) {
            component_arr[i].data = arrayData;
            break;
        }
    }
}


function appendElement(input) {

    var popup = null;
    var data = [];
    for (i = 0; i < component_arr.length; i++) {
        if (component_arr[i].inp_id == input.id) {
            popup = document.getElementById(component_arr[i].pop_id);
            data = component_arr[i].data;
            break;
        }
    }


    if (popup != null) {
        popup.innerHTML = ""
        if (data.length == 0) {
            popup.style.display = "none";
            return;
        }
        for (i = 0; i < data.length; i++) {
            if (data[i].img == "") {
                appendOption(popup, data[i]);
            } else if (data[i].img != "") {
                appendOption_with_img(popup, data[i]);
            }
        }
    }


}



function appendOption(popup, data) {

    popup.style.padding = "5px";
    popup.style.marginLeft = "0px";
    var row_div = document.createElement("DIV");
    row_div.setAttribute("class", "row");
    popup.appendChild(row_div);

    var col_div = document.createElement("DIV");
    col_div.setAttribute("class", "col-md-12");
    row_div.appendChild(col_div);

    var option = document.createElement("LABEL");
    option.setAttribute("class", "option form-control");
    option.setAttribute("id", data.id);
    option.addEventListener("mousedown", optionMousePressed);
    option.addEventListener("mouseover", optionMoveEvent);
    option.addEventListener("mouseout", optionOuteEvent);
    option.innerHTML = data.value;
    col_div.appendChild(option);

}

function appendOption_with_img(popup, data) {
    popup.style.padding = "5px";
    popup.style.marginLeft = "0px";
    var row_div = document.createElement("DIV");
    row_div.setAttribute("class", "row");
    popup.appendChild(row_div);

    var col1_div = document.createElement("DIV");
    col1_div.setAttribute("class", "col-md-2");
    row_div.appendChild(col1_div);

    var col2_div = document.createElement("DIV");
    col2_div.setAttribute("class", "col-md-10");
    row_div.appendChild(col2_div);


    var image = document.createElement("img");
    image.setAttribute("class", "img img_option img-thumbnail");
    image.setAttribute("src", data.img);
    col1_div.appendChild(image);

    var option = document.createElement("LABEL");
    option.setAttribute("class", "option form-control");
    option.setAttribute("id", data.id);
    option.addEventListener("mousedown", optionMousePressed);
    option.addEventListener("mouseover", optionMoveEvent);
    option.addEventListener("mouseout", optionOuteEvent);
    option.innerHTML = data.value;
    col2_div.appendChild(option);
}


function optionMousePressed(event) {
    selected_input.value = event.target.textContent;
    selected_input.setAttribute("data-id", event.target.id);
    $('#' + selected_input.id).trigger('change');
    autoCompleteSelectedOption(selected_input, { "id": event.target.id, "value": event.target.textContent });

}


function optionMoveEvent(event) {
    event.target.style.backgroundColor = "#1E90FF";
}

function optionOuteEvent(event) {
    event.target.style.backgroundColor = "transparent";
}


function keyTypeEvent(event) {

    var array_data = [];
    var popup = null;
    for (i = 0; i < component_arr.length; i++) {
        if (component_arr[i].inp_id == selected_input.id) {
            array_data = component_arr[i].data;
            popup = document.getElementById(component_arr[i].pop_id);
            break;
        }
    }

    var data = [];
    for (i = 0; i < array_data.length; i++) {
        if (array_data[i].value) {
            var bool = array_data[i].value.toLowerCase().includes(event.target.value.toLowerCase());
            if (bool) {
                data.push(array_data[i]);
            }
        }
    }


    if (popup != null) {
        popup.scrollTo(0, 0);
        popup.innerHTML = ""
        if (data.length == 0) {
            popup.style.display = "none";
            return;
        } else {
            popup.style.display = "inline-block";
        }
        for (i = 0; i < data.length; i++) {
            if (data[i].img == "") {
                appendOption(popup, data[i]);
            } else if (data[i].img != "") {
                appendOption_with_img(popup, data[i]);
            }
        }
    }

}


(function ($) {
    $.fn.optionID = function () {
        return $('#' + this[0].id).attr('data-id');
    };
})(jQuery);

(function ($) {
    $.fn.optionValue = function () {
        return $('#' + this[0].id).val();
    };
})(jQuery);


(function ($) {
    $.fn.setData = function (arrayData) {
        setAutocompleteArrayData(this[0].id, arrayData);
    };
}
)(jQuery);



function autoCompleteSelectedOption(input, data) { }




