$(document).ready(function () {

    $('#tblProductionPlan').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "date" },
            { "data": "factory_po" },
            { "data": "machine" },
            { "data": "product" },
            { "data": "shift" },
            { "data": "hour" },
            { "data": "quantity" },
            { "data": "edit", className: "edit" },
            { "data": "view", className: "view" },
            { "data": "approve_icon", className: "approve_icon" },
            { "data": "delete", className: "delete" },
        ],
        columnDefs: [
            { width: 100, targets: 0 },
            { width: 100, targets: 1 },
            { width: 50, targets: 5, className: "text-right" },
            { width: 100, targets: 6, className: "text-right" },
            { width: 40, targets: 7 },
            { width: 40, targets: 8 },
            { width: 40, targets: 9 },
            { width: 40, targets: 10 },
        ],
    });

    allDailyProduction();

    $('#btnAddDailyProductionModel').on('click', function () {

        $('#txtDate').val('');
        $('#txtSupervisor').attr("data-id", '');
        $('#txtSupervisor').val('');
        $('#cmbManuFacturingOrderNo').empty('');
        $('#cmbProduct').empty('');
        $('#cmbMachine').empty();
        $('#cmbShift').empty();
        $('#txtRefferanceNo').val('');
        $('#txtHour').val(0);
        $('#txtQuantity').val(0);
        $('#txtRemark').val('');
        $('#btnAction').show();
        $('#btnAction').text('Save');
        $('#dailyProductionModal').modal('show');
    });

});




function allDailyProduction() {
    $('#dailyProductionModal').modal('hide');
    $.ajax({
        type: "GET",
        url: "/pd/DailyProductionListController/allDailyProduction",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(response);
            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {


                    var id = response.data.result[i]['id'];
                    var date = response.data.result[i]['date'];
                    var factory_po = response.data.result[i]['factory_po_num'];
                    var machine = response.data.result[i]['machinery_name'];
                    var product = response.data.result[i]['product_name'];
                    var shift = response.data.result[i]['shift_name'];
                    var hour = response.data.result[i]['hour'];
                    var quantity = response.data.result[i]['quantity'];
                    var status = response.data.result[i]['status'];
                    var string_id = "'" + id + "'";

                    var approve_icon = '<a href="#"><i class="fa fa-times-circle-o fa-3x text-danger" aria-hidden="true" onclick="approve(' + string_id + ',' + 1 + ')"></i></a>';
                    var disabled = "";
                    if (status == 1) {
                        approve_icon = '<i class="fa fa-check-circle-o fa-3x text-success" aria-hidden="true"></i>';
                        disabled = "disabled";
                    }

                    data.push({
                        "date": date,
                        "factory_po": factory_po,
                        "machine": machine,
                        "product": product,
                        "shift": shift,
                        "hour": hour,
                        "quantity": parseFloat(quantity).toFixed(2),
                        "edit": '<button class="btn btn-primary" onclick="edit(' + string_id + ')" ' + disabled + '><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        "view": '<button class="btn btn-success" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        "approve_icon": approve_icon,
                        "delete": '<button class="btn btn-danger" onclick="_delete(' + string_id + ')" ' + disabled + '><i class="fa fa-trash" aria-hidden="true" ></i></button>'

                    });
                }

                var table = $('#tblProductionPlan').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}


function edit(id) {
    //location.href = "/pd/daily_production?id=" + id + "&action=edit";
    daily_production_id = id;
    getDailyProduction(id);
    $('#dailyProductionModal').modal('show');
    $('#btnAction').show();
    $('#btnAction').text('Update');

}



function view(id) {
    //location.href = "/pd/daily_production?id=" + id + "&action=view";
    daily_production_id = id;
    getDailyProduction(id);
    $('#dailyProductionModal').modal('show');
    $('#btnAction').hide();

}



function _delete(id) {
    $.ajax({
        type: 'DELETE',
        url: '/pd/DailyProductionListController/delete/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Daily production has been deleted successfully...")
                allDailyProduction();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}


function approve(id, status) {

    swal({
        title: "Are you sure?",
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                status_change(id, status);
            }
        });


}



function status_change(id, status) {
    $.ajax({
        type: "POST",
        url: '/pd/DailyProductionController/status_change/' + id,
        data: {
            "status": status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                if (status == 1) {
                    showSuccessMessage('Approved.');
                } else if (status == 2) {
                    showSuccessMessage('Rejected.');
                }
                allDailyProduction();


            }

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}





/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}