$(document).ready(function () {

    $(function () {
        $("#tabs").tabs();
    });

    $('input[name="txtDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    $('input[name="txtDate"]').on('apply.daterangepicker', function (ev, picker) {

        getProducedQuantity(picker.startDate.format('YYYY-MM-D'));
        tableScheduleOnGoing(picker.startDate.format('YYYY-MM-D'));

    });




    getProducedQuantity($('#txtDate').val());
    tableScheduleOnGoing($('#txtDate').val());
    createTabsToSites();

});


function getProducedQuantity(date) {
    $.ajax({
        type: "GET",
        url: "/pd/dashboard/tableProducedQuantity/" + date,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            var result = response.result;
            console.log(result);
            $("#myTable > tbody").empty();
            var bg_color = ["table-Light", "table-info"];
            for (var i = 0; i < result.length; i++) {

                var html = '<tr class="' + bg_color[i % 2] + '">';

                html += '<td style="max-width:100px;min-width:100px;">';
                html += result[i].purchase_order;
                html += '</td>';

                html += '<td style="max-width:100px;min-width:100px;">';
                html += result[i].factory_po_num;
                html += '</td>';

                html += '<td>';
                html += result[i].customer_name;
                html += '</td>';

                html += '<td>';
                html += result[i].product_name;
                html += '</td>';

                html += '<td style="max-width:100px; text-align:right;">';
                html += result[i].ordered_quantity;
                html += '</td>';

                html += '<td style="max-width:100px; text-align:right;">';
                html += result[i].producedQuantity;
                html += '</td>';

                html += '</tr>';
                $("#myTable > tbody").append(html);
            }




        },
        error: function (error) {
            console.log(error);

        },
        complete: function () {

        }
    });
}






function tableScheduleOnGoing(date) {
    $.ajax({
        type: "GET",
        url: "/pd/dashboard/tableScheduleOnGoing/" + date,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            var result = response.result;
            console.log(result);
            $("#tableOngoing > tbody").empty();
            var bg_color = ["table-Light", "table-info"];
            for (var i = 0; i < result.length; i++) {

                var html = '<tr class="' + bg_color[i % 2] + '">';

                html += '<td style="max-width:100px;min-width:100px;">';
                html += result[i].purchase_order;
                html += '</td>';

                html += '<td style="max-width:100px;min-width:100px;">';
                html += result[i].factory_po_num;
                html += '</td>';

                html += '<td>';
                html += result[i].customer_name;
                html += '</td>';

                html += '<td>';
                html += result[i].product_name;
                html += '</td>';

                html += '<td style="max-width:100px; text-align:right;">';
                html += result[i].ordered_quantity;
                html += '</td>';

                html += '<td style="max-width:100px; text-align:right;">';
                html += result[i].producedQuantity;
                html += '</td>';

                html += '<td style="max-width:100px; text-align:right;">';
                html += result[i].todayQuantity;
                html += '</td>';

                html += '</tr>';
                $("#tableOngoing > tbody").append(html);
            }




        },
        error: function (error) {
            console.log(error);

        },
        complete: function () {

        }
    });
}




function createTabsToSites() {
    $.ajax({
        type: "GET",
        url: "/pd/dashboard/createTabsToSites",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            var result = response.result;
            console.log(result);
            for (var i = 0; i < result.length; i++) {
                addTab(jQuery.trim(result[i].site), (i == 0));
            }




        },
        error: function (error) {
            console.log(error);

        },
        complete: function () {

        }
    });
}




function addTab(tab_name, selected) {
    if (selected) {
        $('<li class="nav-item"><a class="nav-link active" id="pills-' + tab_name + '-tab" data-toggle="pill" href="#tb' + tab_name + '" role="tab" aria-controls="pills-' + tab_name + '" aria-selected="' + selected + '">' + tab_name + '</a></li>')
            .appendTo("#tabs ul");

        $('<div class="tab-pane fade active show" id="tb' + tab_name + '" role="tabpanel" aria-labelledby="pills-' + tab_name + '-tab"><div class="row"><div class="col-md-12">' + tab_name + '</div></div></div>')
            .appendTo("#tab-content");
    } else {
        $('<li class="nav-item"><a class="nav-link" id="pills-' + tab_name + '-tab" data-toggle="pill" href="#tb' + tab_name + '" role="tab" aria-controls="pills-' + tab_name + '" aria-selected="' + selected + '">' + tab_name + '</a></li>')
            .appendTo("#tabs ul");
        $('<div class="tab-pane fade" id="tb' + tab_name + '" role="tabpanel" aria-labelledby="pills-' + tab_name + '-tab"><div class="row"><div class="col-md-12">' + tab_name + '</div></div></div>')
            .appendTo("#tab-content");
    }
}