function showHREditModal(customer_order_plan_data_id, product_primary_id) {
    FG_PRODUCT_ID = product_primary_id;
    clearAllocatedHRTable();
    CUSTOMER_ORDER_PLAN_DATA_ID = customer_order_plan_data_id;
    showAllocateHRModal(customer_order_plan_data_id, product_primary_id);


}


function clearAllocatedHRTable() {
    $('#tblAllocateHREdit').empty();
    addBOMRow(0);
}


function showAllocateHRModal(customer_order_plan_data_id, product_primary_id) {

    getMachineryShifts(customer_order_plan_data_id);
    getSelectedProductDataToHRModal(customer_order_plan_data_id,product_primary_id);
    getSaveProductionTeam();
    $('#allocateHRModal').modal('show');
}




function getMachineryShifts(customer_order_plan_data_id) {
    $.ajax({
        type: 'GET',
        url: '/pd/ProductionScheduleCreateController/getMachineryShifts/' + customer_order_plan_data_id,
        async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {
                var array = response.data.result;
                $('#cmbShiftHREdit').empty();
                for (var i = 0; i < array.length; i++) {
                    $('#cmbShiftHREdit').append('<option value="' + array[i].shift_id + '">' + array[i].shift_name + '</option>');
                }
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }
    });
}







function getSelectedProductDataToHRModal(order_id, product_id) {
    $.ajax({
        type: 'GET',
        url: '/pd/ProductionScheduleCreateController/getSelectedProductData/' + order_id + "/" + product_id,
        async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {
                $('#lblHRProductCodeEdit').text(": " + response.data.result.product_code);
                $('#lblHRProductNameEdit').text(": " + response.data.result.product_name);
                $('#lblHRFactoryPOEdit').text(": " + response.data.result.factory_po);
                $('#lblHRCustomerPOEdit').text(": " + response.data.result.customer_po);
                $('#lblHRProductionQtyEdit').text(": " + response.data.result.quantity);
                $('#lblHRAllocateQtyEdit').text(": " + response.data.result.allocated_quantity);
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }
    });
}





function getSaveProductionTeam() {


    $.ajax({
        type: 'GET',
        url: '/pd/ProductionScheduleListController/getSaveProductionTeam/' + CUSTOMER_ORDER_PLAN_DATA_ID + "/" + FG_PRODUCT_ID+"/"+$('#cmbShiftHREdit').val(),
        async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {
                var data = response.data.result;
                $('#tblAllocateHREdit').empty();
                if (data.length > 0) {
                    for (var i = 0; i < data.length; i++) {
                        var lbl_id = "lblDesignation" + i;
                        var string_lbl_id = "'" + lbl_id + "'";
                        var txt_id = "txtNO_H" + i;
                        var string_txt_id = "'" + txt_id + "'";
                        $('#cmbShiftHREdit').val(data[i].shift_id).change();
                        $('#tblAllocateHREdit').append('<tr><td><label id="' + lbl_id + '" data-id="' + data[i].designation_id + '">' + data[i].designation + '</label></td><td style="width:100px"><input type="text" class="form-control" id="' + string_txt_id + '" style="width:100px" value="' + data[i].no_of_heads + '"></td></tr>');
                    }
                }else{
                    getProductionTeam();
                }
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }
    });
}




function dataSourceHR() {

    var collection = {};
    var table = document.getElementById('tblAllocateHREdit'),
        rows = table.getElementsByTagName('tr'),
        i, j, cells, customerId;

    for (i = 0, j = rows.length; i < j; ++i) {
        cells = rows[i].getElementsByTagName('td');
        if (!cells.length) {
            continue;
        }
        var data = {
            "designation_id": $('#' + cells[0].childNodes[0].id).attr("data-id"),
            "no_of_heads": cells[1].childNodes[0].value,
        };
        collection[i] = JSON.stringify(data);





    }
    console.log(collection);
    return collection;

};


function saveAllocateToHR() {

    $.ajax({
        type: "POST",
        url: '/pd/ProductionScheduleListController/saveAllocateToHR',
        data: {
            "customer_order_plan_data_id": CUSTOMER_ORDER_PLAN_DATA_ID,
            "fg_product_id": FG_PRODUCT_ID,
            "shift_id": $('#cmbShiftHREdit').val(),
            'data': dataSourceHR(),
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Data has been saved successful');
                clearAllocatedHRTable();
                $('#allocateHRModal').modal('hide');
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
            $('#allocateHRModal').modal('hide');
        }

    });
}



function getProductionTeam() {
    $.ajax({
        type: 'GET',
        url: '/pp/allocateMachine/getProductionTeam',
        async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {
                var data = response.data.result;
                $('#tblAllocateHREdit').empty();
                for (var i = 0; i < data.length; i++) {
                    var lbl_id = "lblDesignation" + i;
                    var string_lbl_id = "'" + lbl_id + "'";
                    var txt_id = "txtNO_H" + i;
                    var string_txt_id = "'" + txt_id + "'";
                    $('#tblAllocateHREdit').append('<tr><td><label id="' + lbl_id + '" data-id="' + data[i].designation_id + '">' + data[i].designation + '</label></td><td style="width:100px"><input type="text" class="form-control" id="' + string_txt_id + '" style="width:100px"></td></tr>');
                }
            }

        },
        error: function (data) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }
    });
}

