var action = "save";
var tableData = undefined;
var FG_ID = undefined;
var PRODUCT_FROM_MANUFACTURING = [];
var UOM_FROM_MANUFACTURING = [];
$(document).ready(function () {
    $('.status_btn').hide();
    $('input[name="trans_date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });


    allStores();
    allManufacturingNumber();
    newReferanceID(15);
    $('#cmbStores').on('change', function () {
        newReferanceID($(this).val());
    });

    setSelectedOption('cmbStores',15);




    var productChooser = $('#productChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
            { "data": "value1" },
        ],
        columnDefs: [
            { width: 50, targets: 0 },
            { width: 200, targets: 1 },
            { width: 300, targets: 2 },
        ],
    });

    var product_data = allProduct();
    console.log(product_data);
    productChooser.setDataSource(product_data);


    tableData = $('#tblData').transactionTable({
        thead: ['ProductPrimaryID', 'ProductID', 'Product Name', 'Unit', 'Qty', 'Comment', 'Remove'],
        data_chooser: [{ 'col': 2 }],
        chooser: productChooser,
        column_def: { 1: 100 },
        auto_focus: 2,
        row_type: [
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'select', 'value': [], 'align': 'left', 'width': '100%' },
            {
                'type': 'select', 'value': [], 'align': 'left', 'width': '100px'
            },
            { 'type': 'text', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '200px' },
            { 'type': 'remove', 'value': 'X', 'align': 'center', 'width': '50px' }],
    });



    productChooser.on('select', function (event, data) {
        var selected_row = tableData.getSelectedRow();
        var cells = selected_row.getElementsByTagName('td');
        cells[0].childNodes[0].value = data[0];
        cells[1].childNodes[0].value = data[1];
        cells[2].childNodes[0].value = data[2];
        var input = productChooser.getInput();
        input.focus();


        var product_id = data[0];
        var uom = getProduct_Uom(product_id);
        $('#' + cells[3].childNodes[0].id).empty();
        $('#' + cells[3].childNodes[0].id).append('<option value="' + uom.id + '">' + uom.value + '</option>');
    });



    $('#cmbManufacturingOrder').on('change', function () {
        PRODUCT_FROM_MANUFACTURING = allProductFromManuFacturingOrder($(this).val());
        tableData.clear();
        tableData.add_empty_row();
    });


    $('#btnSave').on('click', function () {


        if ($(this).text() == 'Save') {
            saveFinishedGoods();
        } else {
            updateFinishedGoods();
        }
    });



    if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('?');
        var id = param[0].split('=')[1].split('&')[0];
        action = param[0].split('=')[2].split('&')[0];
        FG_ID = id;
        getFinishedGoods(id);
        if (action == 'edit') {
            $('#btnSave').text('Update');
            $('.status_btn').hide();
        } else if (action == 'view') {
            $('#btnSave').hide();
            $('.status_btn').show();
        }

    } else {
        tableData.add_empty_row();
    }




    $('#btnApproveFinishedGoods').on('click', function () {
        change_status_confirmation(FG_ID, 1, "Are you sure want to approve?");
    });
    $('#btnRejectFinishedGoods').on('click', function () {
        change_status_confirmation(FG_ID, 2, "Are you sure want to reject?");
    });



});


function add_row_event(table, data) {

    var table_childs = table.tableChilds();

    var index = table_childs.length - 1;
    $('#' + table_childs[index][2].id).empty();
    $('#' + table_childs[index][2].id).append('<option selected="true" disabled="disabled">-- Select Products --</option>');
    for (var i = 0; i < PRODUCT_FROM_MANUFACTURING.length; i++) {
        $('#' + table_childs[index][2].id).append('<option value="' + PRODUCT_FROM_MANUFACTURING[i].product_primary_id + '"  data-id="' + PRODUCT_FROM_MANUFACTURING[i].product_id + '">' + PRODUCT_FROM_MANUFACTURING[i].product_name + '</option>');
    }
    $('#' + table_childs[index][2].id).on('change', function () {
        var datasource = table.dataSource();
        for(var i2 = 0; i2 < datasource.length; i2++){
            if(datasource[i2][0] == $(this).val()){
                showWarningMessage('Already added '+$('option:selected', this).text());
                return;
            }
        }
        $('#' + table_childs[index][0].id).val($(this).val());
        $('#' + table_childs[index][1].id).val($('option:selected', this).attr('data-id'));
        var uom = getProduct_Uom($(this).val());
        $('#' + table_childs[index][3].id).empty();
        $('#' + table_childs[index][3].id).append('<option value="' + uom.id + '">' + uom.value + '</option>');
    });

}




function allStores() {
    $.ajax({
        type: "GET",
        url: "/pd/FinishedGoodsController/allStores",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbStores').append('<option value="' + res[i].id + '">' + res[i].name + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function newReferanceID(storeID) {
    var referanceID = newID("/pd/FinishedGoodsController/refferanceMaxID", storeID);
    $('#txtRefferance').val(referanceID);
}



function allManufacturingNumber() {
    $.ajax({
        type: "GET",
        url: "/pd/FinishedGoodsController/allManufacturingNumber",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            $('#cmbManufacturingOrder').append('<option selected="true" disabled="disabled">-- Select Order --</option>');
            for (var i = 0; i < res.length; i++) {
                $('#cmbManufacturingOrder').append('<option value="' + res[i].customer_order_plan_id + '">' + res[i].manufacturing_order_number + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function allProduct() {
    var product_data = [];
    $.ajax({
        type: "GET",
        url: "/pd/FinishedGoodsController/allProduct",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            product_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

    return product_data;
}


function allProductFromManuFacturingOrder(order) {
    var product_data = [];
    $.ajax({
        type: "GET",
        url: "/pd/FinishedGoodsController/allProductFromManuFacturingOrder/" + order,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            product_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

    return product_data;
}


function getProduct_Uom(id) {
    var unit = undefined;
    $.ajax({
        type: "GET",
        url: "/pd/FinishedGoodsController/getUom/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            unit = response.data.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return unit;
}

function triggerRowInputs(id, selected_row) {

    if (id == "tblData") {
        var cells = selected_row.getElementsByTagName('td');
        var product = $('#' + cells[0].childNodes[0].id);
        var quantity = $('#' + cells[3].childNodes[0].id);
        quantity.on('input', function () {
            var av_qty = getAvailableQty(product.val(), $('#cmbStores').val());
            var qty = parseFloat(quantity.val());
            if (qty > av_qty) {
                showAlert("Available quantity is " + av_qty);
                quantity.val(av_qty);
            }
        });
    }

}




function saveFinishedGoods() {


    var fg_data = {};
    var fg_data_arr = tableData.dataSource();
    if (fg_data_arr.length == 0) {
        showWarningMessage("Invalied Finished Goods (Empty list)");
        return;
    }
    for (var i = 0; i < fg_data_arr.length; i++) {
        if (!fg_data_arr[i][0]) {
            showWarningMessage("You shuld fill empty row in The list");
            return;
        }
        if (!fg_data_arr[i][3]) {
            showWarningMessage(fg_data_arr[i][1] + " Invalied Quantity");
            return;
        }
        fg_data[i] = JSON.stringify({ "product_id": fg_data_arr[i][0], "product_name": fg_data_arr[i][2], "unit_id": fg_data_arr[i][3], "qty": fg_data_arr[i][4], "comments": fg_data_arr[i][5], });
    }


    $.ajax({
        type: "POST",
        url: '/pd/FinishedGoodsController/save',
        data: {
            'refferance_id': $('#txtRefferance').val(),
            'ref_external_id': $('#txtRefferance').val(),
            'trans_date': $('#txtGrnDate').val(),
            'store_id': $('#cmbStores').val(),
            'mi_type': $('#cmbMiType').val(),
            'customer_order_plan_id': $('#cmbManufacturingOrder').val(),
            'manufacturing_order_number': $('#cmbManufacturingOrder option:selected').text(),
            'remarks': $('#txtRemarks').val(),
            'fg_data': fg_data,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                toastr.success('data saved');
                location.href = '/pd/finished_goods';
            } else {
                showErrorMessage();
            }
            //location.reload();

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}




function getFinishedGoods(id) {
    $.ajax({
        type: "GET",
        url: "/pd/FinishedGoodsController/getFinishedGoods/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);

            $('#txtRefferance').val(res.external_id);
            $('#txtGrnDate').val(res.trans_date);
            $('#txtRemarks').val(res.remarks);
            setSelectedOption('cmbStores', res.store_id);
            setSelectedOption('cmbManufacturingOrder', res.customer_order_plan_id);
            PRODUCT_FROM_MANUFACTURING = allProductFromManuFacturingOrder(res.customer_order_plan_id);



            var request_data = res.data;
            for (var i = 0; i < request_data.length; i++) {
                tableData.addRow(
                    [
                        { 'type': 'string', 'val': request_data[i].product_primary_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'string', 'val': request_data[i].product_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'select', 'val': request_data[i].product, 'align': 'left', 'width': '100%' },
                        {
                            'type': 'select', 'val': request_data[i].uom, 'align': 'left', 'width': '100px'
                        },
                        { 'type': 'text', 'val': request_data[i].quantity, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].comments, 'align': 'left', 'width': '200px' },
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );

                var table_childs = tableData.tableChilds();
                setSelectedOption(table_childs[i][2].id,request_data[i].product_primary_id);
            }



        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

}




function updateFinishedGoods() {


    var fg_data = {};
    var fg_data_arr = tableData.dataSource();
    if (fg_data_arr.length == 0) {
        showWarningMessage("Invalied Finished Goods (Empty list)");
        return;
    }
    for (var i = 0; i < fg_data_arr.length; i++) {
        if (!fg_data_arr[i][0]) {
            showWarningMessage("You shuld fill empty row in The list");
            return;
        }
        if (!fg_data_arr[i][3]) {
            showWarningMessage(fg_data_arr[i][1] + " Invalied Quantity");
            return;
        }
        fg_data[i] = JSON.stringify({ "product_id": fg_data_arr[i][0], "product_name": fg_data_arr[i][2], "unit_id": fg_data_arr[i][3], "qty": fg_data_arr[i][4], "comments": fg_data_arr[i][5], });
    }


    $.ajax({
        type: "PUT",
        url: '/pd/FinishedGoodsController/update/' + FG_ID,
        data: {
            'refferance_id': $('#txtRefferance').val(),
            'ref_external_id': $('#txtRefferance').val(),
            'trans_date': $('#txtGrnDate').val(),
            'store_id': $('#cmbStores').val(),
            'mi_type': $('#cmbMiType').val(),
            'customer_order_plan_id': $('#cmbManufacturingOrder').val(),
            'manufacturing_order_number': $('#cmbManufacturingOrder option:selected').text(),
            'remarks': $('#txtRemarks').val(),
            'fg_data': fg_data,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                toastr.success('data saved');
                location.href = '/pd/finished_goods_list';
            } else {
                showErrorMessage();
            }
            //location.reload();

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}



function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}





function change_status_confirmation(id, status, msg) {
    swal({
        title: msg,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                change_status(id, status);
            }
        });

}

function change_status(id, status) {

    $.ajax({
        type: "PUT",
        url: '/pd/FinishedGoodsController/change_status/' + id,
        data: {
            status: status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            // document.getElementById('btnApproveGrn').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                if (status == 1) {
                    toastr.success("Finished Goods approved.");
                } else if (status == 2) {
                    toastr.success("Finished Goods rejected.");
                }

            } else {
                showErrorMessage();
            }
            location.href = '/pd/finished_goods_list';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
            // document.getElementById('approve'+id).innerHTML = '<i class="fa fa-times" aria-hidden="true"></i>';
        }

    });
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}