$(document).ready(function () {

    $('#myTable').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "reference_no" },
            { "data": "customer" },
            { "data": "date" },
            { "data": "edit", className: "edit" },
            { "data": "view", className: "view" },
            { "data": "approve", className: "approve" },
            { "data": "delete", className: "delete" },
        ],
        columnDefs: [
            { width: 200, targets: 0 },
            { width: 200, targets: 2 },
            { width: 30, targets: 3 },
            { width: 30, targets: 4 },
            { width: 30, targets: 5 },
            { width: 30, targets: 6 },

        ],
    });

    allFinishedGoods();

});


function allFinishedGoods() {
    $.ajax({
        type: "GET",
        url: "/pd/FinishedGoodsListController/allFinishedGoods",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['internal_id'];
                    var reference_no = response.data.result[i]['external_id'];
                    var name = response.data.result[i]['customer_name'];
                    var date = response.data.result[i]['trans_date'];
                    var status = response.data.result[i]['status'];
                    var string_id = "'" + id + "'";

                    /*var approve_btn = '<i class="fa fa-times" aria-hidden="true"></i>';
                    if (status == 1) {
                        approve_btn = '<i class="fa fa-check" aria-hidden="true"></i>';
                    }*/


                    var approve_icon = '';
                    var disabled = "";
                    if (status == 1) {
                        approve_icon = '<i class="fa fa-check-circle-o fa-3x text-success" aria-hidden="true"></i>';
                        disabled = "disabled";
                    } else if (status == 2) {
                        approve_icon = '<i class="fa fa-times-circle-o fa-3x text-danger" aria-hidden="true"></i>';
                        disabled = "disabled";
                    }

                    data.push({
                        "reference_no": reference_no,
                        "customer": name,
                        "date": date,
                        "edit": '<button class="btn btn-primary" onclick="edit(' + string_id + ')" '+disabled+'><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        "view": '<button class="btn btn-success" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        "approve": approve_icon,
                        "delete": '<button class="btn btn-danger" onclick="_delete(' + string_id + ')" '+disabled+'><i class="fa fa-trash" aria-hidden="true"></i></button>'
                    });
                }

                var table = $('#myTable').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },

        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}


function edit(id) {
    location.href = "/pd/finished_goods?id=" + id + "&action=edit";
}



function view(id) {
    location.href = "/pd/finished_goods?id=" + id + "&action=view";
}


function _delete(id) {

    $.ajax({
        type: 'DELETE',
        url: '/pd/FinishedGoodsListController/deleteFinishedGoods/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Finished Goods has been deleted successfully...");
                allFinishedGoods();

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }



    });


}


/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}