var total_psc_amount = 0;
var total_weight = 0;
$(document).ready(function () {

    var table = $('#tblPallatizingList').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "pallet_no" },
            { "data": "factory_po" },
            { "data": "date" },
            { "data": "weight" },
            { "data": "edit", className: "edit" },
            { "data": "view", className: "view" },
            { "data": "print", className: "print" },
            { "data": "approve", className: "view" },
            { "data": "delete", className: "delete" },
        ],
        columnDefs: [
            { width: 30, targets: 4 },
            { width: 30, targets: 5 },
            { width: 30, targets: 6 },
            { width: 30, targets: 7 },
            { width: 30, targets: 8 }
        ],
    });

    allPallatizingData();

});


function allPallatizingData() {
    $.ajax({
        type: "GET",
        url: "/pd/PallatizingListController/allPallatizingData",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['pallatizing_header_id'];
                    var factory_po = response.data.result[i]['factory_po_num'];
                    var order_id = response.data.result[i]['order_id'];
                    var pallet_no = response.data.result[i]['pallet_no'];
                    var date = response.data.result[i]['pallatize_date'];
                    var weight = response.data.result[i]['pallet_weight'];
                    var status = response.data.result[i]['status'];
                    var string_id = "'" + id + "'";
                    var string_order_id = "'" + order_id + "'";

                    var approve_icon = '';
                    var disabled = "";
                    if (status == 1) {
                        approve_icon = '<i class="fa fa-check-circle-o fa-3x text-success" aria-hidden="true"></i>';
                        disabled = "disabled";
                    } else if (status == 2) {
                        approve_icon = '<i class="fa fa-times-circle-o fa-3x text-danger" aria-hidden="true"></i>';
                        disabled = "disabled";
                    }
                    data.push({
                        "pallet_no": pallet_no,
                        "factory_po": factory_po,
                        "date": date,
                        "weight": weight,
                        "edit": '<button class="btn btn-primary" onclick="edit(' + string_id + ')" ' + disabled + '><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        "view": '<button class="btn btn-success" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        "print": '<button class="btn btn-warning" onclick="print(' + string_order_id + ')"><i class="fa fa-print" aria-hidden="true"></i></button>',
                        "approve": approve_icon,
                        "delete": '<button class="btn btn-danger" onclick="delete_confirmation(' + string_id + ')" ' + disabled + '><i class="fa fa-trash" aria-hidden="true"></i></button>'
                    });
                }

                var table = $('#tblPallatizingList').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },

        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function edit(id) {
    location.href = "/pd/pallatizing_details?id=" + id + "&action=edit";
}


function view(id) {
    location.href = "/pd/pallatizing_details?id=" + id + "&action=view";
}




function delete_confirmation(id) {
    swal({
        title: "Are you sure want delete?",
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                _delete(id);
            }
        });

}



function _delete(id) {
    $.ajax({
        type: 'DELETE',
        url: '/pd/PallatizingListController/deletePallet/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Pallatizing Details has been deleted successfully...")
                allPallatizingData();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}


function print(id) {

    total_psc_amount = 0;
    total_weight = 0;
    $.ajax({
        type: "GET",
        url: "/pd/PallatizingListController/pallatizingPrint/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            //$('.btn').prop("disabled", true);
            //document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            var result = response.data.result;
            console.log(result);
            pallatizingPrint(result, 'PRINT');

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            //$('#btnPrint').text('Print');
            //$('.btn').prop("disabled", false);
        }

    });

}



function pallatizingPrint(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];

    var header_data = result.header;


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName(), fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            //[{ text: '\n', fontSize: 8, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'PALLATIZING DETAILS', fontSize: 14, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{
                                table: {
                                    widths: ['*', 150],
                                    headerRows: 1,
                                    body: [
                                        [{ text: '', fontSize: 9, bold: false, alignment: 'right', border: [false, false, false, false] }, { text: 'Document No: FO/PR/04', fontSize: 9, bold: false, alignment: 'right', border: [false, false, false, false] }],
                                        [{ text: '', fontSize: 9, bold: false, alignment: 'right', border: [false, false, false, false] }, { text: 'Issue Date:  17/12/2017', fontSize: 9, bold: false, alignment: 'right', border: [false, false, false, false] }],
                                        /*[{ text: '', fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Store : ' + header_data.store, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: '', fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Supplier Ref No : ' + header_data.supplier_ref_no, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: '', fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'PO No. : ' + header_data.po_no, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: '', fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Transport By : ' + header_data.transport_by, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: '', fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Vehicle No : ' + header_data.vehicle_no, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],*/


                                    ],

                                }, border: [false, false, false, false]
                            }],
                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var footer_data = result.header;
    var Body = [
        {
            table: {
                widths: [64, 102, 87, 217, 59, '*'],
                headerRows: 0,

                body: [
                    [
                        { text: 'PO :', fontSize: 9, bold: false, alignment: 'right', border: [true, true, false, true] },
                        { text: result[0].factory_po_num, fontSize: 9, bold: false, alignment: 'left', border: [true, true, true, true] },
                        { text: 'ORDER NAME :', fontSize: 9, bold: false, alignment: 'right', border: [true, true, true, true] },
                        { text: result[0].customer_name, fontSize: 9, bold: false, alignment: 'left', border: [true, true, true, true] },
                        { text: 'FACTORY :', fontSize: 9, bold: false, alignment: 'right', border: [true, true, true, true] },
                        { text: result[0].site, fontSize: 9, bold: false, alignment: 'left', border: [true, true, true, true] },
                    ],


                ],
            },
        },
        {
            table: {
                widths: [25, 30, 30, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 25, 25, 25, 25, 25, '*', '*'],
                headerRows: 1,
                body: pallatizingPrintBody(result),
                //body:[{text:""},{text:""},{text:""},{text:""}],

            },
        },
        {
            table: {
                widths: [463, 25, 93, 25, '*'],
                headerRows: 0,

                body: [
                    [
                        { text: 'Total :', fontSize: 8, bold: false, alignment: 'left', border: [true, false, false, true] },
                        { text: parseFloat(total_psc_amount).toFixed(0), fontSize: 8, bold: false, alignment: 'right', border: [true, false, false, true] },
                        { text: '', fontSize: 8, bold: false, alignment: 'center', border: [true, false, false, true] },
                        { text: parseFloat(total_weight).toFixed(0), fontSize: 8, bold: false, alignment: 'right', border: [true, false, false, true] },
                        { text: '', fontSize: 8, bold: false, alignment: 'center', border: [true, false, true, true] },
                    ],


                ],
            },
        },
        //{ canvas: [{ type: 'line', x1: 0, y1: 0, x2: 515, y2: 0, lineWidth: 1 }] },
        { text: '', margin: [5, 2, 10, 20] },
        {
            table: {
                widths: [80, 100, '*', 160, 100,],
                headerRows: 0,

                body: [
                    [
                        { text: 'Checked By', fontSize: 9, bold: false, alignment: 'left', border: [true, true, true, true], margin: [0, 0, 0, 0] },
                        { text: '', fontSize: 9, bold: false, alignment: 'center', border: [true, true, true, true], margin: [0, 0, 0, 15] },

                        { text: '', fontSize: 9, bold: false, alignment: 'center', border: [false, false, false, false], margin: [0, 0, 0, 15] },

                        { text: 'Inspected By (Head of the supervisor)', fontSize: 9, bold: false, alignment: 'left', border: [true, true, true, true], margin: [0, 0, 0, 0] },
                        { text: result[0].supervisor, fontSize: 9, bold: false, alignment: 'center', border: [true, true, true, true], margin: [0, 0, 0, 15] },


                    ],
                    [
                        { text: 'Inspected Date', fontSize: 9, bold: false, alignment: 'left', border: [true, true, true, true], margin: [0, 0, 0, 0] },
                        { text: '', fontSize: 9, bold: false, alignment: 'center', border: [true, true, true, true], margin: [0, 0, 0, 0] },

                        { text: '', fontSize: 9, bold: false, alignment: 'center', border: [false, false, false, false], margin: [0, 0, 0, 15] },

                        { text: 'Date', fontSize: 9, bold: false, alignment: 'left', border: [true, true, true, true], margin: [0, 0, 0, 0] },
                        { text: '', fontSize: 9, bold: false, alignment: 'center', border: [true, true, true, true], margin: [0, 0, 0, 15] },

                    ],
                    [
                        { text: 'Signature', fontSize: 9, bold: false, alignment: 'left', border: [true, true, true, true], margin: [0, 0, 0, 15] },
                        { text: '', fontSize: 9, bold: false, alignment: 'center', border: [true, true, true, true], margin: [0, 0, 0, 15] },

                        { text: '', fontSize: 9, bold: false, alignment: 'center', border: [false, false, false, false], margin: [0, 0, 0, 15] },

                        { text: 'Signature', fontSize: 9, bold: false, alignment: 'left', border: [true, true, true, true], margin: [0, 0, 0, 0] },
                        { text: '', fontSize: 9, bold: false, alignment: 'center', border: [true, true, true, true], margin: [0, 0, 0, 15] },

                    ],

                ],
            },


        },

    ];




    var Footer = [

        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function pallatizingPrintBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Pallet #', fontSize: font_size, bold: true, alignment: 'center', border: [true, false, true, false] },
    { text: 'Pallatize Date', fontSize: font_size, bold: true, alignment: 'center', border: [true, false, true, false] },
    { text: 'RCL Numbers', fontSize: font_size, bold: true, alignment: 'center', border: [true, false, true, false] },
    { text: 'L1-Qty', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'L2-Qty', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'L3-Qty', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'L4-Qty', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'L5-Qty', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'L6-Qty', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'L7-Qty', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'L8-Qty', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'L9-Qty', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'L10-Qty', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'L11-Qty', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'L12-Qty', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'L13-Qty', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'L14-Qty', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'L15-Qty', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'TOTAL\n(PSC)', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'Width\n(cm)', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'Length\n(cm)', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'Height\n(cm)', fontSize: font_size, bold: true, alignment: 'right', border: [true, false, true, false] },
    { text: 'Pallet Weight(Kg)', fontSize: font_size, bold: true, alignment: 'center', border: [true, false, true, false] },
    { text: 'Signature\nof\nSupervisor', fontSize: font_size, bold: true, alignment: 'center', border: [true, false, true, false] },
    { text: 'Pallet\nlabel\nNumber', fontSize: font_size, bold: true, alignment: 'center', border: [true, false, true, false] },
    ]);





    for (var i = 0; i < result.length; i++) {
        const layers = result[i].layers.split(",");
        var total_psc = parseFloat(layers[0]) + parseFloat(layers[1]) + parseFloat(layers[2]) + parseFloat(layers[3]) + parseFloat(layers[4]) + parseFloat(layers[5]) + parseFloat(layers[6]) + parseFloat(layers[7]) + parseFloat(layers[8]) + parseFloat(layers[9]) + parseFloat(layers[10]) + parseFloat(layers[11]) + parseFloat(layers[12]) + parseFloat(layers[13]) + parseFloat(layers[14]);
        total_psc_amount += parseFloat(total_psc);
        total_weight += parseFloat(result[i].pallet_weight);
        body.push([
            { text: result[i].pallet_no, fontSize: font_size, alignment: 'center', border: [true, true, true, true] },
            { text: result[i].pallatize_date, fontSize: font_size, alignment: 'center', border: [true, true, true, true] },
            { text: result[i].employees, fontSize: font_size, alignment: 'center', border: [true, true, true, true] },
            { text: layers[0], fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: layers[1], fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: layers[2], fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: layers[3], fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: layers[4], fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: layers[5], fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: layers[6], fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: layers[7], fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: layers[8], fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: layers[9], fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: layers[10], fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: layers[11], fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: layers[12], fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: layers[13], fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: layers[14], fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: total_psc, fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: result[i].pallet_width, fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: result[i].pallet_length, fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: result[i].pallet_height, fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: result[i].pallet_weight, fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: '', fontSize: font_size, alignment: 'center', border: [true, true, true, true] },
            { text: '', fontSize: font_size, alignment: 'center', border: [true, true, true, true] },
        ]);
    }


    return body;
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}

