$(document).ready(function () {

    $('#tblProductionPlan').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "factory" },
            { "data": "machine" },
            { "data": "breakdown_time" },
            { "data": "status" },
            { "data": "orders", className: "orders" },
        ],
        columnDefs: [
            { width: 140, targets: 4 },
        ],
    });

    allPendingMachineBreakdown();

    $('#btnAddDailyProductionModel').on('click', function () {

        //$('#txtDate').val('');
        $('#cmbMachine').empty();
        $('#txtBreakdownTime').val('');
        $('#txtReasonOfBreakdown').val('');
        $('#txtRecoveredTime').val('');
        $('#txtRecoveryDetails').val('');
        $('#txtTechnicalInstruction').val('');
        $('.updateInput').hide();
        $('#btnAction').show();
        $('#btnAction').text('Save');
        $('#dailyProductionModal').modal('show');
    });

});




function allPendingMachineBreakdown() {
    $('#dailyProductionModal').modal('hide');
    $.ajax({
        type: "GET",
        url: "/pd/PendingMachineBreakdownController/allPendingMachineBreakdown",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(response);
            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {


                    var id = response.data.result[i]['id'];
                    var factory = response.data.result[i]['site'];
                    var machine = response.data.result[i]['machinery_name'];
                    var breakdown_time = response.data.result[i]['breakdown_time'];
                    var status = response.data.result[i]['status'];
                    var orders = response.data.result[i]['orders'];
                    var string_id = "'" + id + "'";

                    var status_icon = '<div style="text-align:center;"><span class="badge bg-primary text-primary-bright ">Pending</span><div>';
                    if (status == 0) {
                        status_icon = '<div style="text-align:center;"><span class="badge bg-primary text-primary-bright ">Pending</span></div>';
                    } else if (status == 1) {
                        status_icon = '<div style="text-align:center;"><span class="badge bg-success text-success-bright ">Recovered</span></div>';
                    } else if (status == 2) {
                        status_icon = '<div style="text-align:center;"><span class="badge bg-warning text-warning-bright ">Not Possible</span></div>';
                    }

                    data.push({
                        "factory": factory,
                        "machine": machine,
                        "breakdown_time": breakdown_time,
                        "status": status_icon,
                        "orders": '<div class="row"> <div class="col-md-2" style="vertical-align: middle;"><span style="font-size:18px;height:100%,padding:10px;width:100%;font-weight: bold;">' + orders + '</span></div><div class="col-md-6"><button class="btn btn-primary" style="width:100%" onclick="more(' + string_id + ')">More</button></div></div>',

                    });
                }

                var table = $('#tblProductionPlan').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}





function more(id) {


    $.ajax({
        type: "GET",
        url: "/pd/PendingMachineBreakdownController/getPendingMachineBreakdownData/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(response);
            $('#tblPendingBreakdown').empty();
            if (response.data.success) {
                for (i = 0; i < res.length; i++) {
                    $row = '<tr>';
                    $row += '<td>'+res[i].factory_po_num+'</td>';
                    $row += '<td>'+res[i].product_id+'</td>';
                    $row += '<td>'+res[i].product_name+'</td>';
                    $row += '<td>'+res[i].quantity+'</td>';
                    $row += '<td>'+res[i].date+'</td>';
                    $row += '<td>'+res[i].shift_name+'</td></tr>';
                    $('#tblPendingBreakdown').append($row);
                }

            }

            $('#pendingBreakdownModal').modal('show');
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });


}








/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}