
var setting_array = {
    "machine": null,
    "status": null,
};

var REPORT_ID = 1;

var MONTH_NAME = {
    1: 'january', //january
    2: 'February',//February
    3: 'March',//March
    4: 'April',//April
    5: 'May',//May
    6: 'June',//June
    7: 'July',//July
    8: 'August',//August
    9: 'September',//September
    10: 'October',//October
    11: 'November',//November
    12: 'December',//December
}


$(document).ready(function () {
    allSettings();
    showDate('DATE_RANGE');

    $('#selcMachine').prop("disabled", true);

    $('#checkMachineSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcMachine').prop("disabled", false);
            setting_array.machine = $('#selcMachine').val();
        } else {
            $('#selcMachine').prop("disabled", true);
            setting_array.machine = null;
        }
        //switch_settings('checkSiteSearch');
    });
    $('#selcMachine').on('change', function () {
        setting_array.machine = $(this).val();
    });



    $('#cmbStatus').prop("disabled", true);

    $('#checkStatusSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#cmbStatus').prop("disabled", false);
            setting_array.status = $('#cmbStatus').val();
        } else {
            $('#cmbStatus').prop("disabled", true);
            setting_array.status = null;
        }
        //switch_settings('checkSiteSearch');
    });
    $('#cmbStatus').on('change', function () {
        setting_array.status = $(this).val();
    });


    $('input[name="startDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    $('input[name="startDate"]').on('apply.daterangepicker', function (ev, picker) {

        setDateRangeToDatePicker('endDate', picker.startDate.format('YYYY-MM-D'));

    });

    $('input[name="endDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    setDateRangeToDatePicker('endDate', $('input[name="startDate"]').val());

});


function showDate(args) {

    if (args == 'YEAR_MONTH') {
        $('#divDate1').hide();
        $('#divDate2').show();
    } else {
        $('#divDate1').show();
        $('#divDate2').hide();
    }

    if (args == 'SINGLE_DATE') {
        $('#endDate').hide();
    } else {
        $('#endDate').show();
    }


}


function allSettings() {
    $.ajax({
        type: 'GET',
        url: '/pd/ProductionBreakdownReportController/allSettings',
        async: false,
        success: function (response) {
            console.log(response.data.result);
            $('#selcMachine').empty();
            if (response.data.success) {

                var machine_html = '<option value="disabled" disabled="" selected="">Select here</option>';
                $.each(response.data.result, function (index, value) {
                    var name = value.machinery_no + "-" + value.machinery_name;
                    machine_html += '<option value="' + value.machinery_id + '">' + name + '</option>';
                })
                $('#selcMachine').html(machine_html);

            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}









function settings() {

    return "machine=" + setting_array.machine;
}


function createReport(flag) {



    if (REPORT_ID == 0) {
        showWarningMessage("Please select Report");
        return;
    }


    if (REPORT_ID == 1) {

        //showProductionRecordsReport('','PRINT');
        $.ajax({
            type: "GET",
            url: "/pd/ProductionRecordsReportController/productionBreakdownReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            //url: "/pd/ProductionRecordsReportController/productionRecordsReport",
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                showProductionBreakdownReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });

    }

}




function showProductionBreakdownReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo Lanka Pvt Ltd', fontSize: 12, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 0, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Machine Breakdown (From ' + $('#txtDateFrom').val() + " To " + $('#txtDateTo').val() + ")", fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: ['*', 80, 50, '*', '*', '*'],
                headerRows: 1,
                body: productionBreakdownReportBody(result),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function productionBreakdownReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Factory', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Date', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Month', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Machine', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Reason', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Down Time(Hour)', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    for (var i = 0; i < result.length; i++) {
        body.push([{ text: result[i].factory, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].date, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: MONTH_NAME[result[i].month], fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].machine_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].note, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].hours, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    }
    return body;
}



function _export() {
    createReport('EXPORT');
}

/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}