var outside_factory_id = undefined;
$(document).ready(function () {


    $('input[name="date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    $('input[name="date"]').on('apply.daterangepicker', function (ev, picker) {


    });


    $('#cmbFactory').on('change',function(){
        manufacturingOrderNumber($(this).val());
    });







    $('#btnAction').on('click', function () {
        if ($('#txtDate').val() == '') {
            showWarningMessage('Please select date...!')
            return;
        }
        if ($('#cmbFactory').val() == null) {
            showWarningMessage('Please select factory')
            return;
        }
        if ($('#cmbManuFacturingOrderNo').val() == null) {
            showWarningMessage('Please select manufacturing order number')
            return;
        }
        if ($('#txtQuantity').val() == '') {
            showWarningMessage('Please enter day quantity..!')
            return;
        }
        if ($(this).text() == 'Save') {
            save();
        } else if ($(this).text() == 'Update') {
            update();
        }
    });







    /* if (window.location.search.length > 0) {
         var sPageURL = window.location.search.substring(1);
         var param = sPageURL.split('?');
         daily_production_id = param[0].split('=')[1].split('&')[0];
         action = param[0].split('=')[2].split('&')[0];
 
         getDailyProduction(daily_production_id);
         if (action == 'edit') {
             $('#btnAction').text('Update');
         } else if (action == 'view') {
             $('#btnAction').hide();
         }
 
     } else {
         $('#btnAction').text('Save');
     }*/


    $('#cmbMachine').on('change', function () {
        getShift($(this).val(), $('#txtDate').val());
    });


});





function manufacturingOrderNumber(id) {

    $.ajax({
        type: "GET",
        url: "/pd/ProductionRecordSupervisorOutsideController/manufacturingOrderNumber/"+id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            if (response.data.success) {

                var html = '<option selected="true" disabled>-- Select Here --</option>';
                $.each(response.data.result, function (index, value) {
                    var manufacturing_order = value.manufacturing_order_number + "-" + value.product_name;
                    html += '<option value="' + value.customer_order_plan_data_id + '">' + manufacturing_order + '</option>';
                });
                $('#cmbManuFacturingOrderNo').html(html);
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function outsideFactories() {

    $.ajax({
        type: "GET",
        url: "/pd/ProductionRecordSupervisorOutsideController/outsideFactories",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            if (response.data.success) {

                var html = '<option selected="true" disabled>-- Select Here --</option>';
                $.each(response.data.result, function (index, value) {
                    var factory = value.factory_id + " - " + value.name;
                    html += '<option value="' + value.outside_factory_id + '">' + factory + '</option>';
                });
                $('#cmbFactory').html(html);
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}






function save() {

    var date = $('#txtDate').val();
    var factory_id = $('#cmbFactory').val();
    var manufacturing_order_no = $('#cmbManuFacturingOrderNo').val();
    var quantity = $('#txtQuantity').val();
    var remark = $('#txtRemark').val();


    $.ajax({
        type: "POST",
        url: '/pd/ProductionRecordSupervisorOutsideController/save',
        data: {
            "date": date,
            "factory_id": factory_id,
            "manufacturing_order_no": manufacturing_order_no,
            "quantity": quantity,
            "remark": remark,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Data has been save success..!');
                $('#dailyProductionModal').hide();
                allOutsideFactories();

            }

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}





function getOutside(id) {
    $.ajax({
        type: "GET",
        url: "/pd/ProductionRecordSupervisorOutsideController/getOutside/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            outsideFactories();
            $('#txtDate').val(res.date);
            setSelectedOption("cmbFactory", res.outside_factory_id);
            manufacturingOrderNumber(res.outside_factory_id);
            setSelectedOption("cmbManuFacturingOrderNo", res.customer_order_plan_data_id);
            $('#txtQuantity').val(res.quantity);
            $('#txtRemark').val(res.remark);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function update() {

    var date = $('#txtDate').val();
    var factory_id = $('#cmbFactory').val();
    var manufacturing_order_no = $('#cmbManuFacturingOrderNo').val();
    var quantity = $('#txtQuantity').val();
    var remark = $('#txtRemark').val();


    $.ajax({
        type: "PUT",
        url: '/pd/ProductionRecordSupervisorOutsideController/update/' + outside_factory_id,
        data: {
            "date": date,
            "factory_id": factory_id,
            "manufacturing_order_no": manufacturing_order_no,
            "quantity": quantity,
            "remark": remark,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Data has been updated success..!');
                $('#dailyProductionModal').hide();
                allOutsideFactories();

            }

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}






function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}