$(document).ready(function () {

    $('#tblProductionPlan').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "date" },
            { "data": "outside_factory" },
            { "data": "factory_po" },
            { "data": "quantity" },
            { "data": "remark" },
            { "data": "edit", className: "edit" },
            { "data": "view", className: "view" },
            { "data": "approve_icon", className: "approve_icon" },
            { "data": "delete", className: "delete" },
        ],
        columnDefs: [
            { width: 100, targets: 0 },
            { width: 100, targets: 2 },
            { width: 100, targets: 3 },
            { width: 40, targets: 5 },
            { width: 40, targets: 6 },
            { width: 40, targets: 7 },
            { width: 40, targets: 8 },
        ],
    });

    allOutsideFactories();

    $('#btnAddDailyProductionModel').on('click', function () {

        $('#modalForm').trigger("reset");
        $('#btnAction').show();
        $('#dailyProductionModal').modal('show');
        outsideFactories();
    });

});




function allOutsideFactories() {
    $('#dailyProductionModal').modal('hide');
    $.ajax({
        type: "GET",
        url: "/pd/ProductionRecordSupervisorOutsideController/allOutsideFactories",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(response);
            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {


                    var id = response.data.result[i]['id'];
                    var date = response.data.result[i]['date'];
                    var outside_factory = response.data.result[i]['factory_id'];
                    var factory_po = response.data.result[i]['manufacturing_order_no'];
                    var quantity = response.data.result[i]['quantity'];
                    var remark = response.data.result[i]['remark'];
                    var status = response.data.result[i]['status'];
                    var string_id = "'" + id + "'";

                    var approve_icon =  '<a href="#"><i class="fa fa-times-circle-o fa-3x text-danger" aria-hidden="true" onclick="approve(' + string_id + ',' + 1 + ')"></i></a>';
                    var disabled = "";
                    if (status == 1) {
                        approve_icon = '<i class="fa fa-check-circle-o fa-3x text-success" aria-hidden="true"></i>';
                        disabled = "disabled";
                    }


                    data.push({
                        "date": date,
                        "outside_factory": outside_factory,
                        "factory_po": factory_po,
                        "quantity": parseFloat(quantity).toFixed(2),
                        "remark": remark,
                        "edit": '<button class="btn btn-primary" onclick="edit(' + string_id + ')"  ' + disabled + '><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        "view": '<button class="btn btn-success" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        "approve_icon": approve_icon,
                        "delete": '<button class="btn btn-danger" onclick="_delete(' + string_id + ')"  ' + disabled + '><i class="fa fa-trash" aria-hidden="true"></i></button>'

                    });
                }

                var table = $('#tblProductionPlan').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}


function edit(id) {
    //location.href = "/pd/daily_production?id=" + id + "&action=edit";
    outside_factory_id = id;
    getOutside(id);
    $('#dailyProductionModal').modal('show');
    $('#btnAction').show();
    $('#btnAction').text('Update');

}



function view(id) {
    //location.href = "/pd/daily_production?id=" + id + "&action=view";
    outside_factory_id = id;
    getOutside(id);
    $('#dailyProductionModal').modal('show');
    $('#btnAction').hide();

}



function _delete(id) {
    $.ajax({
        type: 'DELETE',
        url: '/pd/ProductionRecordSupervisorOutsideController/delete/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Outside Factory has been deleted successfully...")
                allOutsideFactories();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}


function approve(id, status) {

    swal({
        title: "Are you sure?",
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                status_change(id, status);
            }
        });


}



function status_change(id, status) {
    $.ajax({
        type: "POST",
        url: '/pd/ProductionRecordSupervisorOutsideController/status_change/' + id,
        data: {
            "status": status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                if (status == 1) {
                    showSuccessMessage('Approved.');
                } else if (status == 2) {
                    showSuccessMessage('Rejected.');
                }
                allOutsideFactories();


            }

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}


/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}