
var MACHINE_QUANTITY_PER_HOUR = 0;
var CUSTOMER_ORDER_PLAN_DATA_ID = undefined;
var CUSTOMER_SELECTED_ORDER_PLAN_ID = undefined;
var PRODUCT_PRIMARY_ID = undefined;
var CUSTOMER_ORDER_PLAN_ID = undefined;
var FG_PRODUCT_ID = undefined;
var productChooser = null;
var REMAINING_QTY = undefined;
var HIDDEN_QTY = undefined;
var TABLE_REMAINING_QTY = undefined;

$(document).ready(function () {

    var allocated_machines_table = $("#allocated_machines_table").DataTable({
        responsive: true,
        paging: false, 
        searching: false, 
        info: false, 
        ordering: false, 
        lengthChange: false, 
        order: [],
        columns: [
            { data: "machinery_id" },
            { data: "factory_id" },
            { data: "factory" },
            { data: "machine" },
        ],
        columnDefs: [
            { width: 50, targets: 0, visible: false },
            { width: 50, targets: 1, visible: false },
            { width: 50, targets: 2 },
            { width: 100, targets: 3 },
            // , visible: false
        ],
    });

    allOrderPlan();
    allOrderPlanForSelect();

    $('input[name="date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {format: 'YYYY-MM-DD',}
    });

    $('input[name="date"]').on('change', function () {
        loadMachinePlan();
    });

    $('#cmbCustomerOrder').on('change', function () {
        var order_id = $(this).val();
        getOrderPlanData(order_id);
    });

    $("#cmbCustomerOrder1").on("change", function () {
        var order_id = $(this).attr("data-id");
        CUSTOMER_SELECTED_ORDER_PLAN_ID = order_id;
        getOrderPlanData(order_id);
    });

    $('#cmbProduct').on('change', function () {
        var product_primary_id = $(this).val();
        var customer_order_plan_data_id = $('#cmbProduct option:selected').attr('data-id');
        console.log("product_id:" + product_primary_id + "order_id:" + customer_order_plan_data_id);
        clearAllocatedTable();
        getSelectedProductData(customer_order_plan_data_id, product_primary_id);
        factories();
        loadFactoryFilter();
        allShiftFilter();

        CUSTOMER_ORDER_PLAN_DATA_ID = customer_order_plan_data_id;
        PRODUCT_PRIMARY_ID = product_primary_id;
        FG_PRODUCT_ID = product_primary_id;
    });

    $("#cmbFactory").change(function () {
        loadMachinesToFactory(this.value, 'cmbMachine');
        clearAllocatedTable();
    });

    $("#cmbMachine").change(function () {
        MACHINE_QUANTITY_PER_HOUR = quantityPerHour(this.value);
        clearAllocatedTable();
        getAllocatedData(CUSTOMER_ORDER_PLAN_DATA_ID, PRODUCT_PRIMARY_ID, $(this).val());
    });

    $('#btnSaveMachintoProduct').on('click', function () {
        saveAllocateToMachine();
    });

    $('#cmbFactoryFilter').on('change', function () {
        loadMachinesToFactory(this.value, 'cmbMachineFilter');
    });

    $('#cmbMachineFilter').on('change', function () {
        loadMachinePlan();
    });

    $('#cmbShiftFilter').on('change', function () {
        loadMachinePlan();
    });

});


function clearAllocatedTable() {
    $('#tblAllocateProduct').empty();
    addMachineRow(0);
}

function allOrderPlan() {

    $.ajax({
        type: "GET",
        url: "/pd/allocateMachine/allOrderPlan",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            console.log(response);
            $('#cmbCustomerOrder').empty();
            $('#cmbCustomerOrder').append('<option selected disabled>--Select Here--</option>');
            if (response.data.success) {
                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['customer_order_plan_id'];
                    order_id = response.data.result[i]['order_id'];
                    var trans_date = response.data.result[i]['trans_date'];
                    var delivery_date = response.data.result[i]['trans_date'];
                    var from_date = response.data.result[i]['from_date'];
                    var to_date = response.data.result[i]['to_date'];
                    var description = response.data.result[i]['description'];
                    var manufacturing_order_number = response.data.result[i]['manufacturing_order_number'];
                    var purchase_order = response.data.result[i]['purchase_order'];

                    $('#cmbCustomerOrder').append('<option value="' + id + '">' + manufacturing_order_number + ' - ' + purchase_order + '</option>');
                }
            } else {showErrorMessage();}
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {}
    });

}

function allOrderPlanForSelect() {
    $.ajax({
        type: "GET",
        url: "/pd/allocateMachine/allOrderPlanForSelect",
        async: false,
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                $("#cmbCustomerOrder1").empty();
                $("#cmbCustomerOrder1").setData(response.data.result);
            }
        },
        error: function (data) {},
        complete: function () {},
    });
}

function getOrderPlanData(order_id) {

    $.ajax({
        type: "GET",
        url: "/pd/allocateMachine/allOrderPlanData/" + order_id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            showProgress();
        },
        success: function (response) {
            console.log(response);

            $('#cmbProduct').empty();
            $('#cmbProduct').append('<option selected disabled>--Select Here--</option>');
            if (response.data.success) {
                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['customer_order_plan_data_id'];
                    var product_primary_id = response.data.result[i]['product_primary_id'];
                    var product_id = response.data.result[i]['product_id'];
                    var product_name = response.data.result[i]['product_name'];
                    var quantity = response.data.result[i]['quantity'];
                    var string_id = "'" + id + "'";
                    var string_product_id = "'" + product_primary_id + "'";
                    $('#cmbProduct').append('<option value="' + product_primary_id + '" data-id="' + id + '">' + product_id + ' - ' + product_name + '</option>');
                }
            } else {showErrorMessage();}
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {
            hideProgress();
        }

    });

}

function getSelectedProductData(customer_order_plan_data_id, product_primary_id) {

    $("#show_allocated_machine").html("");

    $.ajax({
        type: 'GET',
        url: '/pd/allocateMachine/getSelectedProductData/' + customer_order_plan_data_id + "/" + product_primary_id + "/0",
        beforeSend: function () {
            showProgress();
        },
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {
                $("#lblProductCode").text(": " + response.data.result.product_code);
                $("#lblProductName").text(": " + response.data.result.product_name);
                $("#lblFactoryPO").text(": " + response.data.result.factory_po);
                $("#lblCustomerPO").text(": " + response.data.result.customer_po);
                $("#lblProductionQty").text(": " + response.data.result.quantity);
                $("#lblProductionQty").attr("data-id",response.data.result.quantity);
                $("#lblAllocateQty").text(": " + response.data.result.allocated_quantity);
                $("#lblAllocateQty").attr("data-id",response.data.result.allocated_quantity);
                $("#cmbFactory").trigger("change");

                let remaining_qty = response.data.result.quantity - response.data.result.allocated_quantity;
                $("#lblRemainderQty").text(": " + remaining_qty);
                $("#lblRemainderQty").attr("data-id", remaining_qty);
                $("#hiddenRemainderQty").val(remaining_qty);
                
                REMAINING_QTY = remaining_qty;

                if (response.data.result.allocated_quantity > 0) {
                    
                    let show_allocated_machine_button = `
                        <a href="javascript:void(0);" onclick="showAllocatedMachineModal('${customer_order_plan_data_id}', '${product_primary_id}')">
                            <i class="fa fa-info-circle fa-lg text-primary" aria-hidden="true"></i>
                        </a>`;

                    $("#show_allocated_machine").html(
                        show_allocated_machine_button
                    );
                }
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {
            hideProgress();
        }
    });
}
 
function showAllocatedMachineModal(customer_order_plan_data_id, product_primary_id) {
    
    $.ajax({
        type: "GET",
        url:"/pd/allocateMachine/checkAllocatedMachineData/" + customer_order_plan_data_id +
            "/" + product_primary_id,
        //async: false,
        beforeSend: function () { showProgress(); },
        
        success: function (response) {
            console.log(response.data.result);
            var result = response.data.result;
            if (result.length > 0) {
                var data = [];
                for (i = 0; i < response.data.result.length; i++) {
                    let machinery_id = response.data.result[i]["machinery_id"];
                    let machinery_no = response.data.result[i]["machinery_no"];
                    let machinery_name = response.data.result[i]["machinery_name"];
                    let factory_id = response.data.result[i]["factory_id"];
                    let factory_name = response.data.result[i]["factory_name"];

                    // var string_id = "'" + id + "'";
                    data.push({
                        machinery_id: machinery_id,
                        factory_id: factory_id,
                        factory: factory_name,
                        machine: machinery_no + "-" + machinery_name,
                    });
                }

                var table = $("#allocated_machines_table").DataTable();
                table.clear();
                table.rows.add(data).draw();
                
            }
        },
        error: function (data) {},
        complete: function () {
            hideProgress();
        },
    });

    $("#showAllocatedMachineModal").modal("toggle");

}

function quantityPerHour(machine_id) {
    var quantity = 0;
    $.ajax({
        type: 'GET',
        url: '/pd/allocateMachine/quantityPerHour/' + machine_id + "/" + PRODUCT_PRIMARY_ID,
        async: false,
        success: function (response) {
            console.log(response.data.result);
            quantity = response.data.result;
        },
        error: function (data) {},
        complete: function () {}
    });
    return quantity;
}

function getAllocatedData(order_id, product_id, machine_id) {
    $.ajax({
        type: "GET",
        url:"/pd/allocateMachine/getAllocatedData/" +order_id +"/" +product_id +"/" +machine_id,
        //async: false,
        beforeSend: function () {
            showProgress();
        },
        success: function (response) {
            console.log(response.data.result);
            var result = response.data.result;
            if (result.length > 0) {
                var childarray = { btn_id: 0 };
                $("#tblAllocateProduct").empty();
                for (var i = 0; i < result.length; i++) {
                    childarray = addMachineRow(childarray.btn_id);
                    childarray.date.val(result[i].date);
                    childarray.from.val(result[i].from);
                    childarray.to.val(result[i].to).trigger("input");
                    childarray.quantity.val(result[i].quantity);
                    childarray.quantity.attr("class", "form-control-sm oldQty");
                    childarray.quantity_hidden.val(result[i].quantity);
                    childarray.quantity_hidden.attr("class","form-control-sm hiddenQty");
                    childarray.shift.val(result[i].shift_id);
                    childarray.date.trigger("apply.daterangepicker");
                }
                addMachineRow(childarray.btn_id);
            }
            getUpdatedAllocatedQty(CUSTOMER_ORDER_PLAN_DATA_ID,PRODUCT_PRIMARY_ID);
        },
        error: function (data) {},
        complete: function () {hideProgress();},
    });
}

//get updated allocated qty
function getUpdatedAllocatedQty(customer_order_plan_data_id, product_primary_id) {

    $.ajax({
        type: 'GET',
        url: '/pd/allocateMachine/getSelectedProductData/' + customer_order_plan_data_id + "/" + product_primary_id + "/0",
        beforeSend: function () {
            showProgress();
        },
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {
                let totalHiddenQty = 0;
                let remaining_qty = response.data.result.quantity - response.data.result.allocated_quantity;
                $("#lblRemainderQty").text(": " + remaining_qty);
                $("#lblRemainderQty").attr("data-id", remaining_qty);
                $("#hiddenRemainderQty").val(remaining_qty);
                REMAINING_QTY = remaining_qty;

                $(".hiddenQty").each(function () {
                    totalHiddenQty += parseFloat($(this).val()) || 0;
                });
                HIDDEN_QTY = totalHiddenQty;
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {
            hideProgress();
        }
    });
}

//
$("#allocated_machines_table tbody").on("click", "tr", function () {

    var table = $("#allocated_machines_table").DataTable(); // Ensure correct reference
    if ($(this).hasClass("selected")) {
        $(this).removeClass("selected");
    } else {
        var rowData = table.row($(this)).data(); // Ensure the correct row selection
        if (rowData) {
            var machinery_id = rowData.machinery_id;
            var factory_id = rowData.factory_id;
            $('#cmbFactory').val(factory_id);

            // Load machines and set machine value after machines are loaded
            $.ajax({
                type: 'GET',
                url: '/pd/allocateMachine/loadMachinesToFactory/' + factory_id,
                success: function (response) {
                    if (response.success) {
                        // Populate machine dropdown
                        $('#cmbMachine').empty();
                        $('#cmbMachine').append('<option selected disabled>--Select Here--</option>');
                        
                        var machine = response.result["machine"];
                        for (i = 0; i < machine.length; i++) {
                            var id = machine[i]['machinery_id'];
                            var no = machine[i]['machinery_no'];
                            var name = machine[i]['machinery_name'];
                            var nn = no + "-" + name;
                            $('#cmbMachine').append('<option value="' + id + '">' + nn + '</option>');
                        }
                        
                        // Now set the machine value
                        $("#cmbMachine").val(machinery_id);
                        $("#cmbMachine").trigger('change');
                        
                        // Set quantity per hour and get allocated data
                        MACHINE_QUANTITY_PER_HOUR = quantityPerHour(machinery_id);
                        clearAllocatedTable();
                        getAllocatedData(CUSTOMER_ORDER_PLAN_DATA_ID, PRODUCT_PRIMARY_ID, machinery_id);
                        $("#showAllocatedMachineModal").modal("hide");
                        clearAllocatedTable();
                    }
                },
                error: function (error) {
                    console.error('Error loading machines:', error);
                }
            });
            
        } else {
            console.error("No data found for the selected row.");
            $("#showAllocatedMachineModal").modal("hide");
        }
    }
});

// Highlight row on hover
$("#allocated_machines_table tbody").on("mouseenter", "tr", function () {
    $(this).addClass("hover-highlight"); // Add class on hover
}).on("mouseleave", "tr", function () {
    $(this).removeClass("hover-highlight"); // Remove class when not hovering
});

function factories() {
    $.ajax({
        type: 'GET',
        url: '/pd/allocateMachine/factories',
        // async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {

                var html = '<option selected disabled>--Select Here--</option>';
                $('#cmbFactory').empty();
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.factory_id + '">' + value.name + '</option>';
                })
                $('#cmbFactory').html(html);
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}

function loadFactoryFilter() {
    $.ajax({
        type: 'GET',
        url: '/pd/allocateMachine/factories',
        //async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {

                var html = '<option selected disabled>--Select Here--</option>';
                html += '<option value="any">Any</option>';
                $('#cmbFactoryFilter').empty();
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.factory_id + '">' + value.name + '</option>';
                })
                $('#cmbFactoryFilter').html(html);
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}

function loadMachinesToFactory(factory_id, cmb_machine) {

    $.ajax({
        type: 'GET',
        url: '/pd/allocateMachine/loadMachinesToFactory/' + factory_id,
        beforeSend: function () {},
        success: function (response) {
            console.log(response.result)
            if (response.success) {
                $('#' + cmb_machine).empty();
                $('#' + cmb_machine).append('<option selected disabled>--Select Here--</option>');
                if (cmb_machine == 'cmbMachineFilter') {
                    $('#' + cmb_machine).append('<option value="any">Any</option>');
                }
                var machine = response.result["machine"];
                for (i = 0; i < machine.length; i++) {
                    var id = machine[i]['machinery_id'];
                    var no = machine[i]['machinery_no'];
                    var name = machine[i]['machinery_name'];
                    var nn = no + "-" + name;
                    $('#' + cmb_machine).append('<option value="' + id + '">' + nn + '</option>');
                }
            }
            loadMachinePlan();
        }, error: function (data) {
            console.log('something went wrong');
        }
    });
}

function loadMachinePlan() {

    var factory_id = $('#cmbFactoryFilter').val();
    var machine_id = $('#cmbMachineFilter').val();
    $.ajax({
        type: 'GET',
        url: '/pd/allocateMachine/loadMachinePlan/' + factory_id + "/" + machine_id + "/" + $('#txtFromDateFilter').val() + "/" + $('#txtToDateFilter').val(),
        beforeSend: function () {
            showProgress();
        },
        success: function (response) {
            console.log(response.result)
            if (response.success) {
                var nestedData = [];
                var machine = response.result["machine"];
                var allocated = response.result["allocated"];
                var holiday = response.result["holiday"];

                for (i = 0; i < machine.length; i++) {
                    var machine_id = machine[i]['machinery_id'];
                    var no = machine[i]['machinery_no'];
                    var name = machine[i]['machinery_name'];
                    var status = machine[i]['status'];
                    var factory = machine[i]['factory'];
                    var nn = no + "-" + name;


                    var from_date_split = $('#txtFromDateFilter').val().split("-");
                    var to_date_split = $('#txtToDateFilter').val().split("-");
                    var from_date = (new Date(from_date_split[0], from_date_split[1], from_date_split[2]).getTime() / (24 * 3600 * 1000));
                    var to_date = (new Date(to_date_split[0], to_date_split[1], to_date_split[2]).getTime() / (24 * 3600 * 1000));


                    var machinePlan = [];
                    var shift = shiftArray();
                    var count = 0;
                    for (i2 = from_date; i2 <= to_date; i2++) {
                        count += i2;

                        for (i3 = 0; i3 < shift.length; i3++) {
                            var date = new Date(i2 * (24 * 3600 * 1000));
                            var date_str = date.getFullYear() + "-" + appendZero("" + date.getMonth()) + "-" + appendZero("" + date.getDate());
                            var day_name = getDayName(new Date(date_str  + 'T00:00:00'));

                            var allocated_quantity = 0;
                            for (ii = 0; ii < allocated.length; ii++) {
                                if (allocated[ii]["date"] == date_str && machine_id == allocated[ii]["machinery_id"] && shift[i3]["shift_id"] == allocated[ii]["shift_id"]) {
                                    allocated_quantity = allocated[ii]["quantity"];

                                }
                            }


                            var is_holiday = false;
                            for (var hi = 0; hi < holiday.length; hi++) {
                                if (holiday[hi].holyday_date == date_str) {
                                    is_holiday = true;
                                    break;
                                }
                            }


                            if ($('#cmbShiftFilter').val() == 'any' || $('#cmbShiftFilter').val() == null) {
                                machinePlan.push({
                                    is_holiday: is_holiday,
                                    day_name: day_name,
                                    machinery_id: machine_id,
                                    shift_id: shift[i3]["shift_id"],
                                    date: date_str,
                                    shift: shift[i3]["shift_name"],
                                    allocated: allocated_quantity,//getMachineAllocatedQuantity(machine_id, date_str),
                                });
                            } else if ($('#cmbShiftFilter').val() == shift[i3]["shift_id"]) {
                                machinePlan.push({
                                    is_holiday: is_holiday,
                                    day_name: day_name,
                                    machinery_id: machine_id,
                                    shift_id: shift[i3]["shift_id"],
                                    date: date_str,
                                    shift: shift[i3]["shift_name"],
                                    allocated: allocated_quantity,//getMachineAllocatedQuantity(machine_id, date_str),
                                });
                            }
                        }
                    }

                    var status_name = "Normal";
                    if (status == 0) {
                        status_name = "Breakdown";
                    }

                    nestedData.push({
                        factory: factory,
                        machine: nn,
                        status: status_name,
                        machinePlan: machinePlan,
                    });
                }
                initTabulator(nestedData);
                hideProgress();

            }
        }, error: function (data) {
            console.log('something went wrong');
        }
    });
}

function getDayName(date) {
    // Use toLocaleDateString with options to get the day name
    return date.toLocaleDateString('en-US', { weekday: 'long' });
}

function getMachineAllocatedQuantity(machine_id, date) {
    var quantity = 0;
    $.ajax({
        type: 'GET',
        //async: false,
        url: '/pd/allocateMachine/getMachineAllocatedQuantity/' + machine_id + "/" + date,
        beforeSend: function () {},
        success: function (response) {
            console.log(response.result)
        }, error: function (data) {
            console.log('something went wrong');
        }
    });
    return quantity;
}

function appendZero(val) {
    if (val.length == 1) {
        val = "0" + val;
    }
    return val;
}

function addMachineRow(id) {
    $('#' + id).text("Remove");
    $('#' + id).attr('class', 'btn btn-danger remove');
    $('#' + id).attr('onclick', '');

    var btn_id = guidGenerator();
    var txtDate_id = "txtDate" + guidGenerator();
    var txtFrom_id = "txtFrom" + guidGenerator();
    var txtTo_id = "txtTo" + guidGenerator();
    var txtQty_id = "txtQty" + guidGenerator();
    var txtAllocatedQty_id = "allocatedQty" + guidGenerator();
    var txtOutput_id = "txtQty" + guidGenerator();
    var cmb_id = "cmb" + guidGenerator();
    var hidden_txtQty_id = "hiddenQty" + guidGenerator();

    var string_txtFrom_id = "'" + txtFrom_id + "'";
    var string_txtTo_id = "'" + txtTo_id + "'";
    var string_txtQty_id = "'" + txtQty_id + "'";
    var string_txtOutput_id = "'" + txtOutput_id + "'";
    var string_id = "'" + btn_id + "'";
    var string_hidden_txtQty_id = "'" + hidden_txtQty_id + "'";

    var row = '<tr id="' + id + '"><td><input id="' + txtDate_id + '" data-id="' + txtAllocatedQty_id + '" data-id2="' + txtFrom_id + '" data-id3="' + txtTo_id + '" type="text" class="form-control-sm" style="width:130px; border:1px solid gray;" name="dteDate" id="dteDate" autocomplete="off"></td>';
    row += '<td><input id="' + txtFrom_id + '" type="text" class="form-control-sm" style="width:80px; border:1px solid gray;" autocomplete="off" oninput="calculateOutput(' + string_txtFrom_id + ',' + string_txtTo_id + ',' + string_txtQty_id + ',' + string_txtOutput_id + ')"></td>';
    row += '<td><input id="' + txtTo_id + '" type="text" class="form-control-sm" style="width:80px; border:1px solid gray;" autocomplete="off" oninput="calculateOutput(' + string_txtFrom_id + ',' + string_txtTo_id + ',' + string_txtQty_id + ',' + string_txtOutput_id + ')"></td>';
    row += '<td><input id="' + txtQty_id + '" type="text" class="form-control-sm newQty" style="width:100px;text-align:right; border:1px solid gray;"  autocomplete="off" oninput="isCapacityExeeded(' + string_txtQty_id + ',' + string_txtOutput_id + ');setRemainingQty();validate_to_allocatedQty_to_productionQty()"></td>';
    row += '<td><input id="' + txtOutput_id + '" type="text" class="form-control-sm" style="width:100px;text-align:right; border:1px solid gray;" id="date" autocomplete="off" oninput="isCapacityExeeded(' + string_txtQty_id + ',' + string_txtOutput_id + ');"></td>';
    row += '<td><input id = "' + txtAllocatedQty_id + '" type="text" class="form-control-sm" style="width:100px; border:1px solid gray;" id="date" autocomplete="off"></td>';
    row += '<td><select id="' + cmb_id + '" class="form-control" style="width:200px;"></select></td>';
    row += '<td><input id="' + hidden_txtQty_id + '" type="hidden" class="form-control-sm hiddenQty" style="width:100px;text-align:right; border:1px solid gray;"  autocomplete="off"></td>';
    row += '<td><button type="button" id="' + btn_id + '" class="btn btn-primary" onclick="setHiddenQty();addMachineRow(' + string_id + ')">Add</button></td></tr>';
    $('#tblAllocateProduct').append(row);


    $(".remove").click(function () {
        $(this).closest("tr").remove();
        setRemainingQty();
    });


    $('input[name="dteDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }
    });
    $('#' + txtDate_id).val('');
    $('input[name="dteDate"]').on('apply.daterangepicker', function (ev, picker) {
        var from = $('#' + $(this).attr('data-id2')).val();
        var to = $('#' + $(this).attr('data-id3')).val();
        var allocatedQty = getAllocatedQuantityFromDate(CUSTOMER_ORDER_PLAN_DATA_ID, PRODUCT_PRIMARY_ID, $('#cmbMachine').val(), $(this).val(), from, to);
        $('#' + $(this).attr('data-id')).val(allocatedQty);
    });

    $('#' + cmb_id).on('change', function () {
        get_from_to($(this).val(), txtFrom_id, txtTo_id);
    });

    allShift(cmb_id);
    return {
        "btn_id": btn_id,
        "date": $('#' + txtDate_id),
        "from": $('#' + txtFrom_id),
        "to": $('#' + txtTo_id),
        "quantity": $('#' + txtQty_id),
        "output": $('#' + txtOutput_id),
        "allocate": $('#' + txtAllocatedQty_id),
        "shift": $('#' + cmb_id),
        "quantity_hidden": $('#' + hidden_txtQty_id)
    };
}

function guidGenerator() {
    var S4 = function () {
        return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
    };
    return (S4() + S4());
}

function allShift(id) {
    $.ajax({
        type: 'GET',
        url: '/pd/allocateMachine/allShift',
        async: false,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {

                var html = '';
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.shift_id + '">' + value.shift_name + '</option>';
                })
                $('#' + id).html(html);
                $('#' + id).change();
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}

function allShiftFilter() {
    $.ajax({
        type: 'GET',
        url: '/pd/allocateMachine/allShift',
        async: false,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {

                var html = '<option selected disabled>--Select Here--</option>';
                html += '<option value="any">Any</option>';
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.shift_id + '">' + value.shift_name + '</option>';
                })
                $('#cmbShiftFilter').html(html);
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}

function shiftArray() {
    var shift = [];
    $.ajax({
        type: 'GET',
        url: '/pd/allocateMachine/allShift',
        async: false,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {
                $.each(response.data.result, function (index, value) {
                    shift.push({ "shift_id": value.shift_id, "shift_name": value.shift_name });
                });
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
    return shift;
}

function get_from_to(shift_id, from_id, to_id) {
    $.ajax({
        type: 'GET',
        url: '/pd/allocateMachine/get_from_to/' + shift_id,
        async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {
                $('#' + from_id).val(response.data.result.from);
                $('#' + to_id).val(response.data.result.to);

            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}

function getAllocatedQuantityFromDate(order_id, product_id, machine_id, date, from, to) {

    var quantity = 0;
    $.ajax({
        type: 'GET',
        url: '/pd/allocateMachine/getAllocatedQuantityFromDate/' + order_id + "/" + product_id + "/" + machine_id + "/" + date + "/" + from + "/" + to,
        async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.result != null) {
                quantity = response.data.result;
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
    return quantity;
}

function calculateOutput(from_id, to_id, qty_id, output_id) {
    var from = $('#' + from_id).val();
    var to = $('#' + to_id).val();
    var qty = $('#' + qty_id).val();
    var output = (to - from) * MACHINE_QUANTITY_PER_HOUR;
    if (output < 0) {
        output = 0;
    }
    $('#' + output_id).val(output);
}

//check capacity exeeded
function isCapacityExeeded(qty_id, output_id) {
    var qty = parseFloat($('#' + qty_id).val());
    var output = parseFloat($('#' + output_id).val());
    if (qty > output) {
        showWarningMessage("Maximum capacity exeeded.<br>Quantity :" + qty + "<br>Max Output Qty :" + output);
    }
}

// check remaining qty using table data
function setRemainingQty() {
    let productionQty = parseFloat($("#lblProductionQty").attr("data-id")) || 0; // Get Production Qty
    let allocatedQty = parseFloat($("#lblAllocatedQty").attr("data-id")) || 0; // Get Allocated Qty

    let totalHiddenQty = 0; // Sum of hidden quantities
    let totalQuantity = 0; // Sum of current quantities

    // Calculate total hidden quantity
    $(".hiddenQty").each(function () {
        totalHiddenQty += parseFloat($(this).val()) || 0;
    });

    // Calculate total entered quantity
    $(".oldQty").each(function () {
        totalQuantity += parseFloat($(this).val()) || 0;
    });
    
    $(".newQty").each(function () {
        totalQuantity += parseFloat($(this).val()) || 0;
    });

    let tableRemaining = HIDDEN_QTY - totalQuantity;
    TABLE_REMAINING_QTY = tableRemaining;
 
    // Remaining Quantity Formula
    let remainingQty = REMAINING_QTY + TABLE_REMAINING_QTY ;

    // Update the Remaining Qty field
    $("#lblRemainderQty").text(": " + remainingQty);
    $("#lblRemainderQty").attr("data-id", remainingQty);
}

//when change the Qty in the table
$(document).on("input", ".newQty", function () {
    setRemainingQty();
});

//set hidden qty value in the table
function setHiddenQty() {
    setRemainingQty();
}

function validate_to_allocatedQty_to_productionQty() {
    var allocated_qty = parseFloat($('#lblAllocateQty').attr('data-id'));
    var production_qty = parseFloat($('#lblProductionQty').attr('data-id'));
    var qty_array = $('.newQty').map((_, el) => el.value).get();
    var new_allocated_qty = 0;
    for (var i = 0; i < qty_array.length; i++) {
        new_allocated_qty += parseFloat(qty_array[i]);
    }
    if (parseFloat(allocated_qty + new_allocated_qty) > production_qty) {
        showWarningMessage("Maximum capacity exeeded.<br>Production Qty :" + production_qty + "<br>Allocated Qty :" + parseFloat(allocated_qty + new_allocated_qty));
    }
}

function saveAllocateToMachine() {
    
    console.log(dataSource());
    $.ajax({
        type: "POST",
        url: '/pd/allocateMachine/saveAllocateToMachine',
        data: {
            "customer_order_plan_data_id": CUSTOMER_ORDER_PLAN_DATA_ID,
            'machinery_id': $('#cmbMachine').val(),
            "product_primary_id": PRODUCT_PRIMARY_ID,
            'data': dataSource(),
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Data has been saved successful');
                clearAllocatedTable();
                $('#cmbMachine').prop('selectedIndex', 0);
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
            $('#allocateMachineModal').modal('hide');
        }

    });
}






function dataSource() {

    var collection = {};
    var table = document.getElementById('tblAllocateProduct'),
        rows = table.getElementsByTagName('tr'),
        i, j, cells, customerId;

    for (i = 0, j = rows.length; i < j; ++i) {
        cells = rows[i].getElementsByTagName('td');
        if (!cells.length) {
            continue;
        }
        var data = {
            "date": cells[0].childNodes[0].value,
            "from": cells[1].childNodes[0].value,
            "to": cells[2].childNodes[0].value,
            "quantity": cells[3].childNodes[0].value,
            "output": cells[4].childNodes[0].value,
            "allocated": cells[5].childNodes[0].value,
            "shift": cells[6].childNodes[0].value,
        };
        collection[i] = JSON.stringify(data);



    }

    return collection;

};


/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}

/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}

function initTabulator(nestedData) {
    // Define table
    var table = new Tabulator("#example-table", {
        height: "20000px",
        layout: "fitColumns",
        columnDefaults: {
            resizable: false,
        },
        data: nestedData,
        columns: [
            { title: "Factory", field: "factory" },
            { title: "Machine", field: "machine" },
            { title: "Status", field: "status" }
        ],
        rowFormatter: function (row) {
            var data = row.getData();
            if (data.status != "Normal") {
                row.getElement().style.color = "red";
            } else {
                row.getElement().style.color = "black";
            }
            // Create and style holder elements
            var holderEl = document.createElement("div");
            var tableEl = document.createElement("div");

            holderEl.style.boxSizing = "border-box";
            holderEl.style.padding = "10px 30px 10px 10px";
            holderEl.style.borderTop = "1px solid #333";
            holderEl.style.borderBottom = "1px solid #333"; // Corrected typo

            tableEl.style.border = "1px solid #333";

            holderEl.appendChild(tableEl);
            row.getElement().appendChild(holderEl);

            var subTable = new Tabulator(tableEl, {
                data: row.getData().machinePlan,
                columns: [
                    { title: "Date", field: "date" },
                    { title: "Day", field: "day_name" },
                    { title: "Shift", field: "shift" },
                    { title: "Allocated", field: "allocated" }
                ],
                rowFormatter: function (row) {
                    var data = row.getData();
                    // Apply color to sub-table rows based on condition
                    if (data.is_holiday) {
                        row.getElement().style.color = "red";
                    } else {
                        row.getElement().style.color = "black";
                    }
                }
            });

            subTable.on("rowClick", function (e, row) {
                var data = row.getData();
                // $('#lbl_customer_order').text($('#cmbCustomerOrder option:selected').text());
                $('#lbl_customer_order').text($('#cmbCustomerOrder1 option:selected').text());
                $('#lbl_product_code').text($('#lblProductCode').text());
                $('#lbl_product_name').text($('#lblProductName').text());
                $('#lbl_shift').text(data.shift);
                $('#lbl_allocated_quantity').text(data.allocated);
                getAllocatedQuantityData(data.machinery_id, data.shift_id, data.date);
                $('#allocateMachineModal').modal('toggle');
            });
        },
    });

    table.on("rowClick", function (e, row) {
        var data = row.getData();
        // Handle row click for main table if needed
    });
}


function getAllocatedQuantityData(machine_id, shift_id, date) {
    $.ajax({
        type: 'GET',
        url: '/pd/allocateMachine/getAllocatedQuantityData/' + machine_id + "/" + shift_id + "/" + date,
        async: false,
        success: function (response) {
            var data = response.data.result;
            console.log(response.data.result);
            $('#tblAllocatedQuantityData').empty();
            for (var i = 0; i < data.length; i++) {
                var from_to = data[i].from + ' - ' + data[i].to;
                var quantity = data[i].quantity;
                $('#tblAllocatedQuantityData').append('<tr><td>' + from_to + '</td><td>' + quantity + '</td></tr>');
            }

        },
        error: function (data) {

        },
        complete: function () {

        }
    });

}




