
var CUSTOMER_ORDER_PLAN_DATA_ID = undefined;
var FG_PRODUCT_ID = undefined;

$(document).ready(function () {
    var table = $('#table_product_plan').DataTable({
        responsive: true,
        scrollX: true,
        "pageLength": 100,
        "order": [],
        "columns": [
            { "data": "date" },
            { "data": "customer_po" },
            { "data": "factory_po" },
            { "data": "product_id" },
            { "data": "product_name" },
            { "data": "from_date" },
            { "data": "to_date" },
            { "data": "machine_plan" },
            { "data": "add" },

        ],
        columnDefs: [
            { width: 100, targets: 0 },
            { width: 150, targets: 1 },
            { width: 150, targets: 2 },
            { width: 150, targets: 3 },
            { width: 200, targets: 5 },
            { width: 100, targets: 6 },
            { width: 80, targets: 7 },
            { width: 80, targets: 8 },
        ],
    });

    allDailyProduction();

});



function allDailyProduction() {
    $.ajax({
        type: "GET",
        url: "/pd/ProductionScheduleCreateController/productionPlan",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(response);
            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {
                    var customer_order_plan_id = response.data.result[i]['customer_order_plan_id'];
                    var customer_order_plan_data_id = response.data.result[i]['customer_order_plan_data_id'];
                    var order_id = response.data.result[i]['order_id'];
                    var product_primary_id = response.data.result[i]['product_primary_id'];
                    var date = response.data.result[i]['trans_date'];
                    var customer_po = response.data.result[i]['purchase_order'];
                    var factory_po_num = response.data.result[i]['factory_po_num'];
                    var product_id = response.data.result[i]['product_id'];
                    var product_name = response.data.result[i]['product_name'];
                    var from_date = response.data.result[i]['from_date'];
                    var to_date = response.data.result[i]['to_date'];

                    var string_customer_order_plan_data_id = "'" + customer_order_plan_data_id + "'";
                    var string_order_id = "'" + order_id + "'";
                    var string_product_primary_id = "'" + product_primary_id + "'";

                    var action_button = '<div class="dropdown">';
                    action_button += '<button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">';
                    action_button += ' View';
                    action_button += '</button>';
                    action_button += '<div class="dropdown-menu">';
                    action_button += '<a class="dropdown-item" href="#" onclick="showMachinePlanModal(' + string_customer_order_plan_data_id + ',' + string_product_primary_id + ')">Machine Plan</a>';
                    action_button += '<a class="dropdown-item" href="#" onclick="showMaterialModal(' + string_customer_order_plan_data_id + ',' + string_product_primary_id + ')">Material</a>';
                    action_button += '<a class="dropdown-item" href="#" onclick="showHRModal(' + string_customer_order_plan_data_id + ',' + string_product_primary_id + ')">Human Resource</a>';
                    //action_button += '<a class="dropdown-item" href="#" onclick="">Order Details</a>';
                    action_button += '</div></div>'

                    var string_customer_order_plan_id = "'" + customer_order_plan_id + "'";
                    var string_product_id = "'" + product_id + "'";
                    var string_product_name = "";
                    if (product_name) {
                        string_product_name = "'" + product_name.replace("'", "") + "'";
                    }
                    var string_factory_po = "'" + factory_po_num + "'";
                    var add_button = '<button type="button" onclick="add(' + string_customer_order_plan_id + ',' + string_product_primary_id + ',' + string_product_id + ',' + string_product_name + ',' + string_factory_po + ',' + string_order_id + ',' + string_customer_order_plan_data_id + ')" class="btn btn-primary">In House</button>';
                    var outside_button = '<button type="button" onclick="showOutside(' + string_customer_order_plan_data_id + ',' + string_customer_order_plan_id + ',' + string_product_primary_id + ',' + string_product_id + ',' + string_product_name + ',' + string_factory_po + ',' + string_order_id + ')" class="btn btn-primary">Outside</button>';


                    data.push({
                        "date": date,
                        "customer_po": customer_po,
                        "factory_po": factory_po_num,
                        "product_id": product_id,
                        "product_name": product_name,
                        "from_date": from_date,
                        "to_date": to_date,
                        "machine_plan": action_button,
                        "add": '<div class="row"><div class ="col-md-6">' + add_button + '</div><div class ="col-md-6">' + outside_button + '</div></div>',
                    });
                }

                var table = $('#table_product_plan').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function showMachinePlanModal(order_plan_data_id, product_primary_id) {

    var machineryModal = new MachineryModal($('#machineryModalDiv'));
    machineryModal.getSelectedModalData(order_plan_data_id, product_primary_id);
    machineryModal.show();


}


function showMaterialModal(order_plan_data_id, product_primary_id) {

    var bomModal = new BomModal($('#bomModalDiv'));
    bomModal.getSelectedModalData(order_plan_data_id, product_primary_id);
    bomModal.show();

}

function showHRModal(order_plan_data_id, product_primary_id) {

    var hrModal = new HrModal($('#hrModalDiv'));
    hrModal.getSelectedModalData(order_plan_data_id, product_primary_id);
    hrModal.show();
}














function add(customer_order_plan_id, product_primary_id, product_id, product_name, factory_po, order_id, customer_order_plan_data_id) {


    swal({
        title: "Add to production schedule",
        text: "Are you sure.?\nFactory PO :" + factory_po + "\nProduct ID :" + product_id + "\nProduct Name :" + product_name,
        icon: "warning",
        buttons: true,
        buttons: [
            'No',
            'Yes'
        ],
        dangerMode: true,
    });

    $('.swal-button').on('click', function (event) {
        if ($(this).text() == 'Yes') {
            if (!isAllocatedMaterials(product_primary_id, customer_order_plan_data_id)) {
                showWarningMessage("Material resource is not allocated.");
                return;
            }
            if (!isAllocatedMachineries(product_primary_id, customer_order_plan_data_id)) {
                showWarningMessage("Machineries not allocated.");
                return;
            }
            $.ajax({
                type: "POST",
                url: '/pd/ProductionScheduleCreateController/add',
                data: {
                    "customer_order_plan_data_id": customer_order_plan_data_id,
                    "order_id": order_id,
                    "customer_order_plan_id": customer_order_plan_id,
                    "factory_type": 0,
                    "product_primary_id": product_primary_id,
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                timeout: 800000,
                beforeSend: function () {
                },
                success: function (response) {
                    console.log(response);
                    if (response.data.success) {
                        showSuccessMessage('Data added.');
                    }
                },
                error: function (error) {
                    console.log(error);
                    toastr.error('Something went wrong');
                },
                complete: function () {
                    allDailyProduction();
                }

            });
        }
    });

}




function showAlert(title, message) {


}


function isAllocatedMaterials(product_primary_id, order_plan_data_id) {

    var bool = false;
    $.ajax({
        type: "GET",
        url: "/pd/ProductionScheduleCreateController/isAllocatedMaterials/" + product_primary_id + "/" + order_plan_data_id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            bool = response.data.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return bool;
}



function isAllocatedMachineries(product_primary_id, order_plan_data_id) {

    var bool = false;
    $.ajax({
        type: "GET",
        url: "/pd/ProductionScheduleCreateController/isAllocatedMachineries/" + product_primary_id + "/" + order_plan_data_id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            bool = response.data.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return bool;
}









/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}