
var QUANTITY_PER_HOUR = 0;
var CUSTOMER_ORDER_PLAN_DATA_ID = undefined;
var FG_PRODUCT_ID = undefined;
var MACHINERY_PLAN_ID = undefined;
var productChooser = null;
$(document).ready(function () {
    var table = $('#table_product_plan').DataTable({
        responsive: true,
        scrollX: false,
        "pageLength": 100,
        "order": [],
        "columns": [
            { "data": "date" },
            { "data": "customer_po" },
            { "data": "factory_po" },
            { "data": "product_id" },
            { "data": "product_name" },
            { "data": "from_date" },
            { "data": "to_date" },
            { "data": "edit" },
            { "data": "view" },
            { "data": "delete" },

        ],
        columnDefs: [
            { width: 100, targets: 0 },
            { width: 150, targets: 1 },
            { width: 80, targets: 2 },
            { width: 150, targets: 3 },
            { width: 100, targets: 5 },
            { width: 100, targets: 6 },
            { width: 100, targets: 7 },
            { width: 100, targets: 8 },
            { width: 80, targets: 9 },

        ],
    });
    table.column(9).visible(false);

    allDailyProduction();

    $("#cmbFactoryEdit").change(function () {
        loadMachinesToFactory(this.value);
        clearAllocatedMachineTable();
    });

    /*$("#cmbMachineEdit").change(function () {
        MACHINE_QUANTITY_PER_HOUR = quantityPerHour(this.value);
        clearAllocatedMachineTable();
        getAllocatedData(CUSTOMER_ORDER_PLAN_DATA_ID, FG_PRODUCT_ID, $("#cmbMachineEdit").val());
        //getAllocatedData(CUSTOMER_ORDER_PLAN_DATA_ID, PRODUCT_PRIMARY_ID, $(this).val());
    });*/

    $('#btnSaveMachintoProduct').on('click', function () {

        saveAllocateToMachine();
    });


    $('#btnSaveBOMtoProduct').on('click', function () {

        saveScheduleToBOM();
    });


    $('#btnSaveHRtoProduct').on('click', function () {

        saveAllocateToHR();
    });



    productChooser = $('#productChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
        ],
        columnDefs: [
            { width: 200, targets: 0 },
            { width: 300, targets: 1 },
        ],
    });

    var product_data = allRawMaterialProducts();
    //console.log(product_data);
    productChooser.setDataSource(product_data);


    productChooser.on('select', function (event, data) {
        var input = productChooser.getInput();
        input.focus();

        var product_id = data[0];
        var product_name = data[1];
        input.attr("data-id", product_id);
        input.val(product_name);

    });



});




function factories() {
    $.ajax({
        type: 'GET',
        url: '/pd/ProductionScheduleCreateController/factories',
        async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {

                var html = '';
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.site_id + '">' + value.site + '</option>';
                })
                $('#cmbFactoryEdit').html(html);
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });


}


function allDailyProduction() {
    $.ajax({
        type: "GET",
        url: "/pd/ProductionScheduleListController/productionPlanOutside",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(response);
            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {
                    /*var customer_order_plan_id = response.data.result[i]['customer_order_plan_id'];
                    var customer_order_plan_data_id = response.data.result[i]['customer_order_plan_data_id'];
                    var customer_order_id = response.data.result[i]['order_id'];
                    var order_id = response.data.result[i]['customer_order_plan_data_id'];
                    var product_primary_id = response.data.result[i]['product_primary_id'];
                    var machine_id = response.data.result[i]['machinery_id'];
                    var machinery_plan_id = response.data.result[i]['machinery_plan_id'];
                    var daily_production_id = response.data.result[i]['daily_production_id'];
                    var date = response.data.result[i]['trans_date'];
                    var customer_po = response.data.result[i]['purchase_order'];
                    var factory_po_num = response.data.result[i]['factory_po_num'];
                    var product_id = response.data.result[i]['product_id'];
                    var product_name = response.data.result[i]['product_name'];
                    var from_date = response.data.result[i]['from_date'];
                    var to_date = response.data.result[i]['to_date'];
                    var factory = response.data.result[i]['factory'];

                    var string_customer_order_id = "'" + customer_order_id + "'";
                    var string_order_id = "'" + order_id + "'";
                    var string_product_primary_id = "'" + product_primary_id + "'";
                    var string_machine_id = "'" + machine_id + "'";
                    var string_machinery_plan_id = "'" + machinery_plan_id + "'";
                    var string_customer_order_plan_id = "'" + customer_order_plan_id + "'";
                    var string_customer_order_plan_data_id = "'" + customer_order_plan_data_id + "'";*/

                    var machinery_plan_id = response.data.result[i]['machinery_plan_id'];
                    var customer_order_plan_id = response.data.result[i]['customer_order_plan_id'];
                    var customer_order_plan_data_id = response.data.result[i]['customer_order_plan_data_id'];
                    var order_id = response.data.result[i]['order_id'];
                    var product_primary_id = response.data.result[i]['product_primary_id'];
                    var date = response.data.result[i]['trans_date'];
                    var customer_po = response.data.result[i]['purchase_order'];
                    var factory_po_num = response.data.result[i]['factory_po_num'];
                    var product_id = response.data.result[i]['product_id'];
                    var product_name = response.data.result[i]['product_name'];
                    var from_date = response.data.result[i]['from_date'];
                    var to_date = response.data.result[i]['to_date'];

                    var string_customer_order_plan_data_id = "'" + customer_order_plan_data_id + "'";
                    var string_order_id = "'" + order_id + "'";
                    var string_product_primary_id = "'" + product_primary_id + "'";
                    var string_machinery_plan_id = "'" + machinery_plan_id + "'";
                    var string_machine_id = "";
                    var string_customer_order_plan_id = "";
                    var string_customer_order_id = "";


                    var edit_button = '<div class="dropdown">';
                    edit_button += '<button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">';
                    edit_button += ' Edit';
                    edit_button += '</button>';
                    edit_button += '<div class="dropdown-menu">';
                    edit_button += '<a class="dropdown-item" href="#" onclick="showMachinePlanEditModal(' + string_customer_order_plan_data_id + ',' + string_product_primary_id + ',' + string_machinery_plan_id + ')">Machine Plan</a>';
                    edit_button += '<a class="dropdown-item" href="#" onclick="showMaterialEditModal(' + string_customer_order_plan_data_id + ',' + string_product_primary_id + ',' + string_machine_id + ')">Material</a>';
                    edit_button += '<a class="dropdown-item" href="#" onclick="showHREditModal(' + string_customer_order_plan_data_id + ',' + string_product_primary_id + ',' + string_machine_id + ')">Human Resource</a>';
                    //action_button += '<a class="dropdown-item" href="#" onclick="">Order Details</a>';
                    edit_button += '</div></div>'

                    var view_button = '<div class="dropdown">';
                    view_button += '<button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">';
                    view_button += ' View';
                    view_button += '</button>';
                    view_button += '<div class="dropdown-menu">';
                    view_button += '<a class="dropdown-item" href="#" onclick="showMachinePlanModal(' + string_customer_order_plan_data_id + ',' + string_product_primary_id + ')">Machine Plan</a>';
                    view_button += '<a class="dropdown-item" href="#" onclick="showMaterialModal(' + string_customer_order_plan_data_id + ',' + string_product_primary_id + ')">Material</a>';
                    view_button += '<a class="dropdown-item" href="#" onclick="showHRModal(' + string_customer_order_plan_data_id + ',' + string_product_primary_id + ')">Human Resource</a>';
                    view_button += '</div></div>'

                    var delete_button = '<button type="button" class="btn btn-danger" onclick="_delete(' + string_customer_order_plan_data_id + ',' + string_customer_order_plan_id + ',' + string_customer_order_id + ')" ><i class="fa fa-trash" aria-hidden="true"></i></button>';

                    data.push({
                        "date": date,
                        "customer_po": customer_po,
                        "factory_po": factory_po_num,
                        "product_id": product_id,
                        "product_name": product_name,
                        "from_date": from_date,
                        "to_date": to_date,
                        "edit": edit_button,
                        "view": view_button,
                        "delete": delete_button
                    });
                }

                var table = $('#table_product_plan').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function _delete(order_id, customer_order_plan_id, customer_order_id) {

    $.ajax({
        type: 'DELETE',
        url: '/pd/ProductionScheduleListController/delete/' + order_id + "/" + customer_order_plan_id + "/" + customer_order_id,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Daily production has been deleted successfully...")
                allDailyProduction();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}




function showMachinePlanModal(order_id, product_id) {

    var machineryModal = new MachineryModal($('#machineryModalDiv'));
    machineryModal.getSelectedModalData(order_id, product_id);
    machineryModal.show();


}


function showMaterialModal(order_id, product_id) {

    var bomModal = new BomModal($('#bomModalDiv'));
    bomModal.getSelectedModalData(order_id, product_id);
    bomModal.show();

}

function showHRModal(order_id, product_id) {

    var hrModal = new HrModal($('#hrModalDiv'));
    hrModal.getSelectedModalData(order_id, product_id);
    hrModal.show();
}




function isProductionStart(order_plan_data_id) {

    var bool = false;
    $.ajax({
        type: 'GET',
        url: '/pd/ProductionScheduleCreateController/isProductionStart/' + order_plan_data_id,
        async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {

                bool = response.data.result;
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });

    return bool;
}






/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}





