$(document).ready(function () {

    $('#tblProductionPlan').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "factory" },
            { "data": "machine" },
            { "data": "breakdown_time" },
            { "data": "status" },
            { "data": "edit", className: "edit" },
            { "data": "view", className: "view" },
            { "data": "delete", className: "delete" },
        ],
        columnDefs: [
            { width: 50, targets: 3},
            { width: 40, targets: 4},
            { width: 40, targets: 5},
            { width: 40, targets: 6},
        ],
    });

    allDailyProduction();

    $('#btnAddDailyProductionModel').on('click', function () {

        //$('#txtDate').val('');
        allSite();
        $('#cmbMachine').empty();
        $('#txtBreakdownTime').val('');
        $('#txtReasonOfBreakdown').val('');
        $('#txtRecoveredTime').val('');
        $('#txtRecoveryDetails').val('');
        $('#txtTechnicalInstruction').val('');
        $('.updateInput').hide();
        $('#btnAction').show();
        $('#btnAction').text('Save');
        $('#dailyProductionModal').modal('show');
    });

});




function allDailyProduction() {
    $('#dailyProductionModal').modal('hide');
    $.ajax({
        type: "GET",
        url: "/pd/ReasonOfBreakdownController/allDailyProduction",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(response);
            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {


                    var id = response.data.result[i]['id'];
                    var date = response.data.result[i]['date'];
                    var factory = response.data.result[i]['site'];
                    var machine = response.data.result[i]['machinery_name'];
                    var breakdown_time = response.data.result[i]['breakdown_time'];
                    var status = response.data.result[i]['status'];
                    var string_id = "'" + id + "'";

                    var status_icon = '<span class="badge bg-primary text-primary-bright ">New</span>';
                    if (status == 0) {
                        status_icon = '<span class="badge bg-primary text-primary-bright ">New</span>';
                    } else if (status == 1) {
                        status_icon = '<span class="badge bg-success text-success-bright ">Recovered</span>';
                    } else if (status == 2) {
                        status_icon = '<span class="badge bg-warning text-warning-bright ">Not Possible</span>';
                    }

                    data.push({
                        "date": date,
                        "factory": factory,
                        "machine": machine,
                        "breakdown_time": breakdown_time,
                        "status": status_icon,
                        "edit": '<button class="btn btn-primary" onclick="edit(' + string_id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        "view": '<button class="btn btn-success" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        "delete": '<button class="btn btn-danger" onclick="_delete(' + string_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>'

                    });
                }

                var table = $('#tblProductionPlan').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}


function edit(id) {
    //location.href = "/pd/daily_production?id=" + id + "&action=edit";
    daily_production_id = id;
    $('.updateInput').show();
    getDailyProduction(id);
    $('#dailyProductionModal').modal('show');
    $('#btnAction').show();
    $('#btnAction').text('Update');

}



function view(id) {
    //location.href = "/pd/daily_production?id=" + id + "&action=view";
    daily_production_id = id;
    $('.updateInput').show();
    getDailyProduction(id);
    $('#dailyProductionModal').modal('show');
    $('#btnAction').hide();

}



function _delete(id) {
    $.ajax({
        type: 'DELETE',
        url: '/pd/ReasonOfBreakdownController/delete/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Reason of breakdown has been deleted successfully...")
                allDailyProduction();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}





/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}