@extends('pd::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">


<!-- Datepicker -->
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('sc:js/autocomplete/css/autocomplete.min.css') }}" type="text/css">
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/dropzone/dropzone.css') }}" type="text/css">


<meta name="csrf-token" content="{{ csrf_token() }}">
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3>Pallatizing Details</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">

        <div class="card">
            <div class="card-body">

                <div class="row">
                    <div class="col-md-11 border">
                        <div class="row border-bottom bg-light" style="padding: 10px;">
                            <h6>Pallatizing Details</h6>
                        </div>
                        <div class="row">
                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Pallet No.</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtPalletNo" name="palletNo" disabled>
                                </div>
                            </div>

                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Pallatize Date</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txt_pallatize_date" name="pallatize_date">
                                </div>
                            </div>

                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Pallet Weight(KG)</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtPalletWeight" name="palletWeight">
                                </div>
                            </div>

                        </div>



                        <div class="row">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2" style="padding: 0px;">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Length</div>
                                    </div>
                                    <!--<input type="text" class="form-control form-control-sm auto-complete" autocomplete="off" id="txtReceivedBy" name="received_by" style="min-width: 100%;">!-->
                                    <input type="text" id="txtPalletLength" name="palletLength" class="form-control form-control-sm">
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Width</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" autocomplete="off" id="txtPalletWidth" name="palletWidth">
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Height</div>
                                    </div>
                                    <input type="text" id="txtPalletHeight" name="palletHeight" class="form-control form-control-sm">
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Factory</div>
                                    </div>
                                    <select class="form-control form-control-sm" id="cmbFactory"></select>
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Order</div>
                                    </div>
                                    <select class="form-control form-control-sm" id="cmbOrder"></select>
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Supervisor</div>
                                    </div>
                                    <input type="text" id="txtSupervisor" name="supervisor" class="form-control form-control-sm" data-id=''>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped" id="tblData"></table>
                                </div>
                            </div>
                        </div>


                        <hr>


                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped" id="tblEmployee"></table>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-12 mt-2">
                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <button type="button" id="btnAttachment" class="btn btn-primary">Attachment</button>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <div class="table-responsive">
                                            <!-- Required for Responsive -->
                                            <table id="tblPalletAttachment" class="table table-striped  datatable">
                                                <thead>
                                                    <tr>
                                                        <th class="thTitle">Title</th>
                                                        <th class="thView">View</th>
                                                        <th class="thDownload">Down</th>
                                                        <th class="thDelete">Delete</th>
                                                    </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row border">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-12 mt-2 mb-2" style="text-align: right;">
                                        <button id="btnSave" class="btn btn-light form-control-sm">Save</button>
                                    </div>
                                </div>
                                <div class="row status_btn">
                                    <div class="col-md-12 mb-3" style="text-align: left;">
                                        <button type="button" class="btn btn-success text-success form-control-sm" id="btnApprovePallet">Approve</i></button>
                                        <button type="button" class="btn btn-danger text-danger form-control-sm" id="btnRejectPallet" hidden>Reject</i></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>


    <div id="productChooser"></div>
    <div id="employeeChooser"></div>
    <div id="supervisorChooser"></div>


    <!--Attachment-->
    <div class="modal fade" id="attachmentAddModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="attachmentAddModalTitle">Add attachment here</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <div class="modal-body" id="attachmentAddModalBody">
                    <div class="row">
                        <div class="col-md-12">
                            <form action="{{route('/PallatizingController/uploadAttachment')}}" class="dropzone" method="POST" id="myDropzone" name="myDropzone">
                                @csrf
                                <input type="hidden" id="order_id" name="order_id" value="">
                                <input type="hidden" id="attachmnet_token" name="attachmnet_token" value="">
                                <div class="fallback">
                                    <input name="file" type="file" multiple />
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                        </button>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JQuery !-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    @endsection

    @section('script')
    <!-- Datepicker -->
    <script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
    <!-- AutoComplete -->
    <script src="{{ Module::asset('sc:js/autocomplete/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>"></script>
    <!-- Datachooser -->
    <script src="{{ url('vendors/dropzone/dropzone.js') }}"></script>

    <script src="{{ Module::asset('sc:js/progress_widget.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ Module::asset('sc:js/data_chooser.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('pd:js/transaction_table.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/id_gen.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('pd:js/pallatizing_details.js') }}?random=<?php echo uniqid(); ?>"></script>





    @endsection