@extends('pd::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">

<!-- Datepicker -->
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">


<meta name="csrf-token" content="{{ csrf_token() }}">

<style>
    .modal-body {
        height: 250px;
        overflow-y: auto;
    }

    @media (min-height: 500px) {
        .modal-body {
            height: 400px;
        }
    }

    @media (min-height: 800px) {
        .modal-body {
            height: 600px;
        }
    }

    .modal-header {

        padding: 1rem;
    }
</style>
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Pending Machine Breakdowns List</h6>
                {{ csrf_field() }}
                <table id="tblProductionPlan" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                    <thead>
                        <tr>
                            <th>Factory</th>
                            <th>Machine</th>
                            <th>Breakdown Time</th>
                            <th>Status</th>
                            <th>Schedules In Risk</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>





<!--Daily Production Modal -->

<div class="modal fade" id="pendingBreakdownModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Schedules In Risk</h5>
            </div>

            <div class="modal-body">
                <hr>
                <div class="row">
                    <div class="col-md-12">

                        <div class="card">
                            <div class="card-body">

                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="table-responsive">
                                            <!-- Required for Responsive -->
                                            <table class="table table-sm table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>PO No</th>
                                                        <th>ProductID</th>
                                                        <th>Product Name</th>
                                                        <th>Quantity</th>
                                                        <th>Date</th>
                                                        <th>Shift</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="tblPendingBreakdown">

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                </div>
                <br>
            </div>
            <div class="modal-footer">

                <!--<button type="button" name="saveaddorder" id="btnAction" class="btn btn-primary">Save</button>!-->
                <button type="button" name="canceladdorder" id="btnCancelAddOrder" class="btn btn-warning" data-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('assets/js/examples/datatable.js') }}"></script>
<!-- Datepicker -->
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<script src="{{ Module::asset('pd:js/pending_machine_breakdown.js') }}?random=<?php echo uniqid(); ?>"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
@endsection