@extends('pd::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">

<!-- Datepicker -->
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">

<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<meta name="csrf-token" content="{{ csrf_token() }}">
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3>Production Schedule Create</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">

        <div class="card">
            <div class="card-body">


                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <!-- Required for Responsive -->
                            <table id="table_product_plan" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Customer PO</th>
                                        <th>Factory PO</th>
                                        <th>Product ID</th>
                                        <th>Product Name</th>
                                        <th>From</th>
                                        <th>To</th>
                                        <th>View</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>



            </div>

        </div>
    </div>






    <div id="machineryModalDiv"></div>
    <div id="bomModalDiv"></div>
    <div id="hrModalDiv"></div>
    <div id="outsideFactoryModalDiv"></div>




<!-- Outside factory modal!-->
    <div class="modal fade" id="outsideModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="outsideModalTitle">Outside Factory</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <form action="POST" id="taxForm">
                    {{csrf_field()}}
                    <div class="modal-body" id="outsideModalBody">

                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <label>Expected date</label>
                                        <input type="text" id="txtExpectedDate" name="date" class="form-control">
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <label>Starting Date</label>
                                        <input type="text" id="txtStartingDate" name="date" class="form-control">
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <label>Outside Factories</label>
                                        <select id="cmbOutsideFactory" class="form-control"></select>
                                    </div>
                                </div>




                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                        </button>
                        <button type="button" class="btn btn-primary" id="btnAction">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>



    <!-- JQuery !-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    @endsection

    @section('script')
    <!-- Datepicker -->
    <script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
    <!-- DataTable -->
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ Module::asset('pd:js/MachineryModal.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('pd:js/BomModal.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('pd:js/HrModal.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('pd:js/production_schedule_create.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('pd:js/OutsideFactoryModal.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('pd:js/outside_factory.js') }}?random=<?php echo uniqid(); ?>"></script>
    @endsection