@extends('pd::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/employee.css') }}" type="text/css">
<link rel="stylesheet" href="{{ Module::asset('pd:js/autocomplete2/css/autocomplete.min.css') }}">
<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/settings.css') }}" media="all" type="text/css" />
<style>
    .modal {
        height: 90vh;
    }

    .modal-body {
        max-height: calc(100vh - 200px);
        overflow-y: auto;
    }

    .hover-highlight {
        background-color: #d1e7fd !important; /* Light blue */
    }

</style>

<meta name="csrf-token" content="{{ csrf_token() }}">
<script>
    var allocate_resource_machine = "{{ Auth::user()->can('pp_production_plan_allocate_resource_machine')}} ";
    var allocate_resource_bom = "{{ Auth::user()->can('pp_production_plan_allocate_resource_bom')}} ";
    var allocate_resource_hr = "{{ Auth::user()->can('pp_production_plan_allocate_resource_hr')}} ";

</script>
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">

            <div class="card-body">
                <h6 class="card-title">Production Schedule Allocate Machine</h6>
                <div id="orderplan">

                    <div class="row mb-2">
                        <div class="col-md-6">
                            <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                            <label>Customer Order</label>
                            {{-- <select class="form-control" id="cmbCustomerOrder"></select> --}}
                            <input type="text" class="form-control auto-complete required-input" id="cmbCustomerOrder1"
                                name="customerOrder1" placeholder="Please Select Customer Order" required="">
                        </div>
                        <div class="col-md-6">
                            <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                            <label>Product</label>
                            <select class="form-control" id="cmbProduct"></select>
                        </div>
                    </div>

                    <hr>
                    <div class="row mb-2">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Product Code :</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblProductCode" name="productCode"></label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Product Name :</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblProductName" name="productName"></label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-2">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Factory PO No.</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblFactoryPO" name="factoryPO"></label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Customer PO No.</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblCustomerPO" name="customerPO"></label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-2">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Production Qty</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblProductionQty" name="productionQty"></label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Allocated Qty</label>
                                </div>
                                <div class="col-md-4">
                                    <label id="lblAllocateQty" name="allocateQty"></label>
                                </div>

                                <div class="col-md-2" id="show_allocated_machine">
                                    {{-- <button type="button" class="btn btn-primary btn-sm" onclick="showAllocatedMachineModal()"><i class="fa fa-search" aria-hidden="true"></i></button> --}}
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-2">
                        <div class="col-md-6">
                        </div>
                        <div class="col-md-6">
                           <div class="row">
                                <div class="col-md-4">
                                    <label>Remainder Qty</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblRemainderQty" name="remainderQty"></label>
                                    <input type="hidden" id="hiddenRemainderQty">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Factory</label>
                                </div>
                                <div class="col-md-6">
                                    <select id="cmbFactory" class="form-control" name="factory"></select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Machine</label>
                                </div>
                                <div class="col-md-6">
                                    <select id="cmbMachine" class="form-control" name="machine"></select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <!-- Required for Responsive -->
                                <table class="table table-sm table-striped">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>From</th>
                                            <th>To</th>
                                            <th>Quantity</th>
                                            <th>Max Output</th>
                                            <th>Allocated</th>
                                            <th>Shift</th>
                                            {{-- <th>Hidden Qty</th> --}}
                                            <th>Add</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tblAllocateProduct">

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <button type="button" name="saveaddorder" id="btnSaveMachintoProduct"
                                class="btn btn-primary">Save</button>
                        </div>
                    </div>
                    <hr>
                </div>
                <div class="row mb-3">
                    <div class="col-md-3">
                        <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                        <label>Factory</label>
                        <select class="form-control" id="cmbFactoryFilter"></select>
                    </div>
                    <div class="col-md-3">
                        <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                        <label>Machine</label>
                        <select class="form-control" id="cmbMachineFilter"></select>
                    </div>
                    <div class="col-md-3">
                        <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                        <label>Shift</label>
                        <select class="form-control" id="cmbShiftFilter"></select>
                    </div>
                    <div class="col-md-3">
                        <div class="row">
                            <div class="col-md-6">
                                <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                <label>Date From</label>
                                <input type="text" name="date" class="form-control" id="txtFromDateFilter"></select>
                            </div>
                            <div class="col-md-6">
                                <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                <label>Date To</label>
                                <input type="text" name="date" class="form-control" id="txtToDateFilter"></select>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div id="example-table"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!--Machine Modal -->

<div class="modal fade" id="allocateMachineModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Allocate Machine</h5>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-4">
                        <label>Customer Order :</label>
                    </div>
                    <div class="col-md-8">
                        <label id="lbl_customer_order">123</label>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <label>Product Code :</label>
                    </div>
                    <div class="col-md-8">
                        <label id="lbl_product_code">123</label>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <label>Product Name :</label>
                    </div>
                    <div class="col-md-8">
                        <label id="lbl_product_name">ABC</label>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <label>Shift :</label>
                    </div>
                    <div class="col-md-8">
                        <label id="lbl_shift">ABC</label>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <label>Allocated Quantity :</label>
                    </div>
                    <div class="col-md-8">
                        <label id="lbl_allocated_quantity">0.00</label>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <table class="table table-sm table-striped">
                        <thead>
                            <tr>
                                <th>From - To</th>
                                <th>Quantity</th>
                            </tr>
                        </thead>
                        <tbody id="tblAllocatedQuantityData"></tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" name="canceladdorder" id="btnCancelAddOrder" class="btn btn-warning"
                    data-dismiss="modal">Cancel</button>

            </div>
        </div>
    </div>
</div>

<!--Allocated Machine Modal -->

<div class="modal fade" id="showAllocatedMachineModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Allocated Machine</h5>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="table-responsive">
                        <table id="allocated_machines_table" class="table datatable">
                            <thead>
                                <tr>
                                    <th class="thOrderPlan">machinery_id</th>
                                    <th class="thOrderPlan">factory_id</th>
                                    <th class="thmanufactureID">Factory</th>
                                    <th class="thOrderId">Machine</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" name="canceladdorder" id="btnCancelAddOrder" class="btn btn-warning"
                    data-dismiss="modal">Cancel</button>

            </div>
        </div>
    </div>
</div>




<!--BOM Modal -->

<div class="modal fade" id="allocateBOMModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">BOM</h5>
            </div>
            <div class="modal-body">
                <hr>
                <div class="row">
                    <div class="col-md-5 mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <label>Product Code</label>
                            </div>
                            <div class="col-md-6">
                                <label id="lblBOMProductCode" name="productCode"></label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5 mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <label>Product Name</label>
                            </div>
                            <div class="col-md-6">
                                <label id="lblBOMProductName" name="productName"></label>
                            </div>
                        </div>


                    </div>
                </div>
                <div class="row">
                    <div class="col-md-5 mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <label>Factory PO No.</label>
                            </div>
                            <div class="col-md-6">
                                <label id="lblBOMFactoryPO" name="factoryPO"></label>
                            </div>
                        </div>


                    </div>
                    <div class="col-md-5 mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <label>Customer PO No.</label>
                            </div>
                            <div class="col-md-6">
                                <label id="lblBOMCustomerPO" name="customerPO"></label>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="row">
                    <div class="col-md-5 mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <label>Production Qty</label>
                            </div>
                            <div class="col-md-6">
                                <label id="lblBOMProductionQty" name="productionQty"></label>
                            </div>
                        </div>


                    </div>
                    <div class="col-md-5 mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <label>Allocated Qty</label>
                            </div>
                            <div class="col-md-4">
                                <label id="lblBOMAllocateQty" name="allocateQty"></label>
                            </div>

                        </div>

                    </div>
                </div>


                <div class="row">
                    <div class="col-md-12 mb-3">
                        <div class="row">
                            <div class="col-md-2">
                                <label id="lblBomCombo">BOM Name :</label>
                            </div>
                            <div class="col-md-8">
                                <select id="cmbBomName" class="form-control" name="bomName"></select>
                            </div>
                        </div>


                    </div>
                </div>


                <hr>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <!-- Required for Responsive -->
                            <table class="table table-sm table-striped">
                                <thead>
                                    <tr>
                                        <th>Material</th>
                                        <th>Quantity</th>
                                        <th>UOM</th>
                                        <th>Tolerance</th>
                                        <th>Add</th>
                                    </tr>
                                </thead>
                                <tbody id="tblAllocateBOM">

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">

                <button type="button" name="btnSaveBOMtoProduct" id="btnSaveBOMtoProduct"
                    class="btn btn-primary">Save</button>
                <button type="button" name="canceladdorder" id="btnCancelBOM" class="btn btn-warning"
                    data-bs-dismiss="modal">Cancel</button>
            </div>
            <br><br>
        </div>
    </div>
</div>



<!--HR Modal -->

<div class="modal fade" id="allocateHRModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">HR</h5>
            </div>
            <div class="modal-body">
                <hr>
                <div class="row">
                    <div class="col-md-5 mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <label>Product Code</label>
                            </div>
                            <div class="col-md-6">
                                <label id="lblHRProductCode" name="productCode"></label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5 mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <label>Product Name</label>
                            </div>
                            <div class="col-md-6">
                                <label id="lblHRProductName" name="productName"></label>
                            </div>
                        </div>


                    </div>
                </div>
                <div class="row">
                    <div class="col-md-5 mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <label>Factory PO No.</label>
                            </div>
                            <div class="col-md-6">
                                <label id="lblHRFactoryPO" name="factoryPO"></label>
                            </div>
                        </div>


                    </div>
                    <div class="col-md-5 mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <label>Customer PO No.</label>
                            </div>
                            <div class="col-md-6">
                                <label id="lblHRCustomerPO" name="customerPO"></label>
                            </div>
                        </div>

                    </div>

                </div>
                <div class="row">
                    <div class="col-md-5 mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <label>Production Qty</label>
                            </div>
                            <div class="col-md-6">
                                <label id="lblHRProductionQty" name="productionQty"></label>
                            </div>
                        </div>


                    </div>
                    <div class="col-md-5 mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <label>Allocated Qty</label>
                            </div>
                            <div class="col-md-6">
                                <label id="lblHRAllocateQty" name="allocateQty"></label>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="row">
                    <div class="col-md-5 mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <label>Shift.</label>
                            </div>
                            <div class="col-md-6">
                                <select id="cmbShiftHR" onclick="getSaveProductionTeam()" class="form-control"></select>
                            </div>
                        </div>


                    </div>
                    <div class="col-md-5 mb-3">
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <!-- Required for Responsive -->
                            <table class="table table-sm table-striped">
                                <thead>
                                    <tr>
                                        <th>Designation</th>
                                        <th>NO of Heads</th>
                                    </tr>
                                </thead>
                                <tbody id="tblAllocateHR">

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">

                <button type="button" name="saveaddorder" id="btnSaveHRtoProduct" class="btn btn-primary">Save</button>
                <button type="button" name="canceladdorder" id="btnCancelAddOrder" class="btn btn-warning"
                    data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>

<div id="productChooser"></div>
@endsection

<!-- App scripts -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('assets/js/examples/datatable.js') }}"></script>
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<script src="{{ Module::asset('pd:js/data_chooser.js') }}?random=<?php echo uniqid(); ?>"></script>
<!-- RequiredInput -->
<script src="{{ Module::asset('pd:js/rquired_input.min.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('pd:js/progress_widget.js') }}?random=<?php echo uniqid(); ?>"></script>
<!-- Javascript -->
<script src="{{ Module::asset('pd:js/autocomplete2/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<script src="{{ Module::asset('pd:js/components_progress.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('pd:js/production_schedule_allocate_machinery_plan.js') }}?random=<?php echo uniqid(); ?>"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<!-- Sweet alert -->
<script src="{{ url('assets/js/examples/sweet-alert.js') }}"></script>
@endsection
