@extends('pd::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">

<!-- Datepicker -->
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">

<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&amp;display=swap" rel="stylesheet">
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<meta name="csrf-token" content="{{ csrf_token() }}">

<style>
    .tooltip-inner {
        background-color: green !important;
        color: #fff;
        white-space: pre-wrap;
    }

    .bs-tooltip-bottom .arrow::before,
    .bs-tooltip-auto[x-placement^="bottom"] .arrow::before {
        border-bottom-color: green !important;
    }
</style>
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3>Production Schedule List (In House)</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">

        <div class="card">
            <div class="card-body">


                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <!-- Required for Responsive -->
                            <table id="table_product_plan" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Customer PO</th>
                                        <th>Factory PO</th>
                                        <th>Product ID</th>
                                        <th>Product Name</th>
                                        <th>From</th>
                                        <th>To</th>
                                        <th>Edit</th>
                                        <th>View</th>
                                        <th>Delete</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>



            </div>

        </div>
    </div>




    <!--Machine Modal Edit -->

    <div class="modal fade" id="machinePlanModalEdit" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">

                    <h5 class="modal-title" id="exampleModalLabelEdit">Allocate Machine</h5>
                </div>
                <div class="modal-body">
                    <hr>
                    <div class="row">
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Product Code</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblProductCodeEdit" name="productCode"></label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Product Name</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblProductNameEdit" name="productName"></label>
                                </div>
                            </div>


                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Factory PO No.</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblFactoryPOEdit" name="factoryPO"></label>
                                </div>
                            </div>


                        </div>
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Customer PO No.</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblCustomerPOEdit" name="customerPO"></label>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Production Qty</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblProductionQtyEdit" name="productionQty"></label>
                                </div>
                            </div>


                        </div>
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Allocated Qty</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblAllocateQtyEdit" name="allocateQty"></label>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label data-html="true" id="lblFactoryEdit" data-toggle="tooltip" data-placement="right" twipsy-content-set="true">Factory</label>
                                </div>
                                <div class="col-md-6">
                                    <select id="cmbFactoryEdit" class="form-control" name="factory"></select>
                                </div>
                            </div>


                        </div>
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label data-html="true"  id="lblMachineEdit" data-toggle="tooltip" data-placement="right" twipsy-content-set="true">Machine</label>
                                </div>
                                <div class="col-md-6">
                                    <select id="cmbMachineEdit" class="form-control" name="machine"></select>
                                </div>
                            </div>

                        </div>
                    </div>

                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <!-- Required for Responsive -->
                                <table class="table table-sm table-striped">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>From</th>
                                            <th>To</th>
                                            <th>Quantity</th>
                                            <th>Max Output</th>
                                            <th>Allocated</th>
                                            <th>Completed</th>
                                            <th>Shift</th>
                                            <th>Add</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody id="tblAllocateProductEdit">

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <br>
                    <br>
                    <br>
                    <br>
                </div>
                <div class="modal-footer">

                    <button type="button" name="saveaddorder" id="btnSaveMachintoProduct" class="btn btn-primary">Save</button>
                    <button type="button" name="canceladdorder" id="btnCancelAddOrder" class="btn btn-warning" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>





    <!--BOM Modal -->

    <div class="modal fade" id="allocateBOMModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">BOM</h5>
                </div>
                <div class="modal-body">
                    <hr>
                    <div class="row">
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Product Code</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblBOMProductCodeEdit" name="productCode"></label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Product Name</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblBOMProductNameEdit" name="productName"></label>
                                </div>
                            </div>


                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Factory PO No.</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblBOMFactoryPOEdit" name="factoryPO"></label>
                                </div>
                            </div>


                        </div>
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Customer PO No.</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblBOMCustomerPOEdit" name="customerPO"></label>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Production Qty</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblBOMProductionQtyEdit" name="productionQty"></label>
                                </div>
                            </div>


                        </div>
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Allocated Qty</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblBOMAllocateQtyEdit" name="allocateQty"></label>
                                </div>
                            </div>

                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <!-- Required for Responsive -->
                                <table class="table table-sm table-striped">
                                    <thead>
                                        <tr>
                                            <th>Material</th>
                                            <th>Quantity</th>
                                            <th>UOM</th>
                                            <th>Tolerance</th>
                                            <th>Add</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tblAllocateBOMEdit">

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">

                    <button type="button" name="btnSaveBOMtoProduct" id="btnSaveBOMtoProduct" class="btn btn-primary">Save</button>
                    <button type="button" name="canceladdorder" id="btnCancelBOM" class="btn btn-warning" data-dismiss="modal">Cancel</button>
                </div>
                <br><br>
            </div>
        </div>
    </div>



    <!--HR Modal -->

    <div class="modal fade" id="allocateHRModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">HR</h5>
                </div>
                <div class="modal-body">
                    <hr>
                    <div class="row">
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Product Code</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblHRProductCodeEdit" name="productCode"></label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Product Name</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblHRProductNameEdit" name="productName"></label>
                                </div>
                            </div>


                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Factory PO No.</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblHRFactoryPOEdit" name="factoryPO"></label>
                                </div>
                            </div>


                        </div>
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Customer PO No.</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblHRCustomerPOEdit" name="customerPO"></label>
                                </div>
                            </div>

                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Production Qty</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblHRProductionQtyEdit" name="productionQty"></label>
                                </div>
                            </div>


                        </div>
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Allocated Qty</label>
                                </div>
                                <div class="col-md-6">
                                    <label id="lblHRAllocateQtyEdit" name="allocateQty"></label>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-5 mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Shift.</label>
                                </div>
                                <div class="col-md-6">
                                    <select id="cmbShiftHREdit" onclick="getSaveProductionTeam()" class="form-control"></select>
                                </div>
                            </div>


                        </div>
                        <div class="col-md-5 mb-3">
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <!-- Required for Responsive -->
                                <table class="table table-sm table-striped">
                                    <thead>
                                        <tr>
                                            <th>Designation</th>
                                            <th>NO of Heads</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tblAllocateHREdit">

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">

                    <button type="button" name="saveaddorder" id="btnSaveHRtoProduct" class="btn btn-primary">Save</button>
                    <button type="button" name="canceladdorder" id="btnCancelAddOrder" class="btn btn-warning" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>


    <div id="productChooser"></div>
    <div id="machineryModalDiv"></div>
    <div id="bomModalDiv"></div>
    <div id="hrModalDiv"></div>
    <!-- JQuery !-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    @endsection

    @section('script')
    <!-- Datepicker -->
    <script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
    <!-- DataTable -->
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ Module::asset('pd:js/data_chooser.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('pd:js/MachineryModalPS.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('pd:js/BomModal.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('pd:js/HrModal.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('pd:js/production_schedule_list.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('pd:js/edit_machinery_plan.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('pd:js/edit_material.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('pd:js/edit_hr.js') }}?random=<?php echo uniqid(); ?>"></script>
    @endsection