@extends('pd::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/settings.css') }}" type="text/css">


<meta name="csrf-token" content="{{ csrf_token() }}">

<meta charset="UTF-8">
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Settings</h6>
                <div class="accordion" id="accordionExample">


                    <div class="col-md-12 mb-3">
                        <div class="card ">
                            <div class="card-header" id="headingReasonOfBreakdown">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" id="settingsModal" data-toggle="collapse" data-target="#collapseReasonOfBreakdown" aria-expanded="false" aria-controls="collapseReasonOfBreakdown" onclick="allReason()">
                                        <i class="ti-settings mr-2"></i> Reason of Breakdown
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseReasonOfBreakdown" class="collapse" aria-labelledby="headingReasonOfBreakdown" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>

                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" id="btnShowReasonModal">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>

                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Reason</th>
                                                    <th class="edit edit_reason">Edit</th>
                                                    <th class="disable disable_reason">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblReasonOfBreakdown"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>



    <div class="modal fade" id="reasonOfBreakdownModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Reason of Breakdown</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                            <label for="txtDate">Reason</label>
                            <input type="text" id="txtReason" name="reason" class="form-control" autocomplete="off">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                    </button>
                    <button type="button" class="btn btn-primary" id="btnSaveReason">Save</button>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- App scripts -->
<script src="{{ Module::asset('pd:js/settings.js') }}?random=<?php echo uniqid(); ?>"></script>
<!-- Sweet alert -->
<script src="{{ url('assets/js/examples/sweet-alert.js') }}"></script>
<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection