<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Route;
use Modules\Pd\Http\Controllers\SettingsController;
use Modules\Pd\Http\Controllers\DailyProductionController;
use Modules\Pd\Http\Controllers\DailyProductionListController;
use Modules\Pd\Http\Controllers\DailyProductionReportController;
use Modules\Pd\Http\Controllers\DashBoardController;
use Modules\Pd\Http\Controllers\FinishedGoodsController;
use Modules\Pd\Http\Controllers\FinishedGoodsListController;
use Modules\Pd\Http\Controllers\PallatizingController;
use Modules\Pd\Http\Controllers\PallatizingListController;
use Modules\Pd\Http\Controllers\PendingMachineBreakdownController;
use Modules\Pd\Http\Controllers\ProductionBreakdownReportController;
use Modules\Pd\Http\Controllers\ProductionRecordsReportController;
use Modules\Pd\Http\Controllers\ProductionRecordSupervisorOutsideController;
use Modules\Pd\Http\Controllers\ProductionScheduleCalendarController;
use Modules\Pd\Http\Controllers\ProductionScheduleCreateController;
use Modules\Pd\Http\Controllers\ProductionScheduleGanttChartController;
use Modules\Pd\Http\Controllers\ProductionScheduleListController;
use Modules\Pd\Http\Controllers\ReasonOfBreakdownController;
use Modules\Pd\Http\Controllers\ScheduleStatusController;
use Modules\Pp\Http\Controllers\GanttChartController;
use Modules\Pd\Http\Controllers\ProductionAllocateMachineController;


Route::prefix('pd')->group(function () {
    //Route::get('/', 'PpController@index');

    Route::get('/dashboard', function () {
        return view('pd::dashboard');
    })->middleware('is.logged');

    Route::get('/daily_production', function () {
        return view('pd::daily_production');
    })->middleware('is.logged');

    Route::get('/daily_production_list', function () {
        return view('pd::daily_production_list');
    })->middleware('is.logged');

    Route::get('/production_schedule_create', function () {
        return view('pd::production_schedule');
    })->middleware('is.logged');

    Route::get('/production_schedule_list', function () {
        return view('pd::production_schedule_list');
    })->middleware('is.logged');


    Route::get('/production_schedule_calendar', function () {
        return view('pd::calendar');
    })->middleware('is.logged');



    Route::get('/production_schedule_gantt_chart', function () {
        return view('pd::gantt_chart');
    })->middleware('is.logged');


    Route::get('/MachineryModal', function () {
        return view('pd::MachineryModal');
    })->middleware('is.logged');


    Route::get('/BomModal', function () {
        return view('pd::BomModal');
    })->middleware('is.logged');

    Route::get('/HrModal', function () {
        return view('pd::HrModal');
    })->middleware('is.logged');


    Route::get('/daily_production_report', function () {
        return view('pd::daily_production_report');
    })->middleware('is.logged');

    Route::get('/production_records_report', function () {
        return view('pd::production_records_report');
    })->middleware('is.logged');


    Route::get('/finished_goods', function () {
        return view('pd::finished_goods');
    })->middleware('is.logged');


    Route::get('/finished_goods_list', function () {
        return view('pd::finished_goods_list');
    })->middleware('is.logged');


    Route::get('/schedule_status', function () {
        return view('pd::schedule_status');
    })->middleware('is.logged');

    Route::get('/reason_of_breakdown', function () {
        return view('pd::reason_of_breakdown');
    })->middleware('is.logged');


    Route::get('/settings', function () {
        return view('pd::setting');
    })->middleware('is.logged');


    Route::get('/pending_machine_breakdown', function () {
        return view('pd::pending_machine_breakdown');
    })->middleware('is.logged');


    Route::get('/machine_breakdown_report', function () {
        return view('pd::production_breakdown_report');
    })->middleware('is.logged');


    Route::get('/OutsideFactoryModal', function () {
        return view('pd::OutsideFactoryModal');
    })->middleware('is.logged');


    Route::get('/production_schedule_outside_list', function () {
        return view('pd::production_schedule_outside_list');
    })->middleware('is.logged');

    Route::get('/pallatizing_details', function () {
        return view('pd::pallatizing_details');
    })->middleware('is.logged');

    Route::get('/pallatizing_details_list', function () {
        return view('pd::pallatizing_details_list');
    })->middleware('is.logged');

    Route::get('/production_record_supervisor_outside', function () {
        return view('pd::production_record_supervisor_outside');
    })->middleware('is.logged');





    /**Daily Production Controller */
    Route::get('/DailyProductionController/productionSupervisor', [DailyProductionController::class, 'productionSupervisor']);
    Route::get('/DailyProductionController/manufacturingOrderNumber/{date}', [DailyProductionController::class, 'manufacturingOrderNumber']);
    Route::get('/DailyProductionController/product/{id}', [DailyProductionController::class, 'product']);
    Route::get('/DailyProductionController/machine/{id}/{date}', [DailyProductionController::class, 'machine']);
    Route::post('/DailyProductionController/save', [DailyProductionController::class, 'save']);
    Route::post('/DailyProductionController/update/{id}', [DailyProductionController::class, 'update']);
    Route::get('/DailyProductionController/getDailyProduction/{id}', [DailyProductionController::class, 'getDailyProduction']);
    Route::get('/DailyProductionController/getShift/{id}/{date}', [DailyProductionController::class, 'getShift']);
    Route::post('/DailyProductionController/status_change/{id}', [DailyProductionController::class, 'status_change']);
    /**End of Daily Production Controller */

    /**Daily Production List Controller */
    Route::get('/DailyProductionListController/allDailyProduction', [DailyProductionListController::class, 'allDailyProduction']);
    Route::delete('/DailyProductionListController/delete/{id}', [DailyProductionListController::class, 'delete']);
    /**End of Daily Production List Controller */


    /**Production Schedule Create Controller */
    Route::get('/ProductionScheduleCreateController/productionPlan', [ProductionScheduleCreateController::class, 'productionPlan']);
    Route::get('/ProductionScheduleCreateController/getSelectedProductData/{customer_order_plan_data_id}/{product_primary_id}', [ProductionScheduleCreateController::class, 'getSelectedProductData']);
    Route::get('/ProductionScheduleCreateController/getAllocatedQuantityFromDate/{order_id}/{product_id}/{machine_id}/{date}/{from}/{to}', [ProductionScheduleCreateController::class, 'getAllocatedQuantityFromDate']);
    Route::get('/ProductionScheduleCreateController/getAllocatedData/{order_id}/{product_id}/{machine_id}', [ProductionScheduleCreateController::class, 'getAllocatedData']);
    Route::get('/ProductionScheduleCreateController/getAllocatedMachineData/{order_id}/{product_id}/{machine_id}/{site_id}', [ProductionScheduleCreateController::class, 'getAllocatedMachineData']);
    Route::get('/ProductionScheduleCreateController/quantityPerHour/{machine_id}', [ProductionScheduleCreateController::class, 'quantityPerHour']);
    Route::get('/ProductionScheduleCreateController/getSavedAllocatedBOMData/{customer_order_plan_data_id}/{fg_product_id}', [ProductionScheduleCreateController::class, 'getSavedAllocatedBOMData']);
    Route::get('/ProductionScheduleCreateController/getSaveProductionTeam/{customer_order_plan_data_id}/{fg_product_id}', [ProductionScheduleCreateController::class, 'getSaveProductionTeam']);
    Route::get('/ProductionScheduleCreateController/getMachineryShifts/{customer_order_plan_data_id}', [ProductionScheduleCreateController::class, 'getMachineryShifts']);
    Route::get('/ProductionScheduleCreateController/getSavedAllocatedDataToDetailsHR/{customer_order_plan_data_id}/{fg_product_id}/{shift_id}', [ProductionScheduleCreateController::class, 'getSavedAllocatedDataToDetailsHR']);
    Route::post('/ProductionScheduleCreateController/add', [ProductionScheduleCreateController::class, 'add']);
    Route::post('/ProductionScheduleCreateController/addOutsideFactory', [ProductionScheduleCreateController::class, 'addOutsideFactory']);
    Route::get('/ProductionScheduleCreateController/getSelectedDailyProduction/{order_id}', [ProductionScheduleCreateController::class, 'getSelectedDailyProduction']);
    Route::get('/ProductionScheduleCreateController/factories', [ProductionScheduleCreateController::class, 'factories']);
    Route::get('/ProductionScheduleCreateController/loadMachinesToFactory/{id}', [ProductionScheduleCreateController::class, 'loadMachinesToFactory']);
    Route::get('/ProductionScheduleCreateController/allShift', [ProductionScheduleCreateController::class, 'allShift']);
    Route::get('/ProductionScheduleCreateController/getSelectedProductDataToMaterial/{customer_order_plan_data_id}/{product_primary_id}', [ProductionScheduleCreateController::class, 'getSelectedProductDataToMaterial']);
    Route::get('/ProductionScheduleCreateController/getAllocatedBOMData/{product_code}/{bom_name}', [ProductionScheduleCreateController::class, 'getAllocatedBOMData']);
    Route::get('/ProductionScheduleCreateController/allRawMaterialProducts', [ProductionScheduleCreateController::class, 'allRawMaterialProducts']);
    Route::get('/ProductionScheduleCreateController/isAllocatedMaterials/{product_primary_id}/{order_plan_data_id}', [ProductionScheduleCreateController::class, 'isAllocatedMaterials']);
    Route::get('/ProductionScheduleCreateController/isAllocatedMachineries/{product_primary_id}/{order_plan_data_id}', [ProductionScheduleCreateController::class, 'isAllocatedMachineries']);
    Route::get('/ProductionScheduleCreateController/isProductionStart/{order_plan_data_id}', [ProductionScheduleCreateController::class, 'isProductionStart']);
    Route::get('/ProductionScheduleCreateController/allOutsideFactories', [ProductionScheduleCreateController::class, 'allOutsideFactories']);
    Route::put('/ProductionScheduleCreateController/breakdown/{schedule_machinery_plan_id}', [ProductionScheduleCreateController::class, 'breakdown']);
    Route::put('/ProductionScheduleCreateController/undoBreakdown/{schedule_machinery_plan_id}', [ProductionScheduleCreateController::class, 'undoBreakdown']);
    /**End of Production Schedule Create Controller */


    /**Production Schedule List Controller */
    Route::get('/ProductionScheduleListController/productionPlanInhouse', [ProductionScheduleListController::class, 'productionPlanInhouse']);
    Route::get('/ProductionScheduleListController/productionPlanOutside', [ProductionScheduleListController::class, 'productionPlanOutside']);
    Route::post('/ProductionScheduleListController/saveAllocateToMachine', [ProductionScheduleListController::class, 'saveAllocateToMachine']);
    Route::get('/ProductionScheduleListController/getAllocatedData/{order_id}/{product_id}/{machine_id}', [ProductionScheduleListController::class, 'getAllocatedData']);
    Route::get('/ProductionScheduleListController/getSavedAllocatedBOMData/{customer_order_plan_data_id}/{fg_product_id}', [ProductionScheduleListController::class, 'getSavedAllocatedBOMData']);
    Route::post('/ProductionScheduleListController/saveScheduleToBOM', [ProductionScheduleListController::class, 'saveScheduleToBOM']);
    Route::get('/ProductionScheduleListController/getSaveProductionTeam/{customer_order_plan_data_id}/{fg_product_id}/{shift_id}', [ProductionScheduleListController::class, 'getSaveProductionTeam']);
    Route::post('/ProductionScheduleListController/saveAllocateToHR', [ProductionScheduleListController::class, 'saveAllocateToHR']);
    Route::delete('/ProductionScheduleListController/delete/{order_id}/{customer_order_plan_id}/{customer_order_id}', [ProductionScheduleListController::class, 'delete']);
    Route::get('/ProductionScheduleListController/getPendingMachineBreakdownData/{machinery_id}', [ProductionScheduleListController::class, 'getPendingMachineBreakdownData']);

    /**End of Production Schedule List Controller */



    /**Production Schedule Calendar Controller */
    Route::get('/ProductionScheduleCalendarController/loadProductionPlanToCalander', [ProductionScheduleCalendarController::class, 'loadProductionPlanToCalander']);
    /**End of Production Schedule Calendar Controller */



    /** Gantt Chart */
    Route::get('/ProductionScheduleGanttChartController/createGantChart/{startDate}/{endDate}', [ProductionScheduleGanttChartController::class, 'createGantChart']);
    Route::get('/ProductionScheduleGanttChartController/ganttChartModalData/{customer_order_id}/{machine_id}/{startDate}/{endDate}', [ProductionScheduleGanttChartController::class, 'ganttChartModalData']);
    Route::get('/ProductionScheduleGanttChartController/loadProducts', [ProductionScheduleGanttChartController::class, 'loadProducts']);
    Route::get('/ProductionScheduleGanttChartController/loadMachine', [ProductionScheduleGanttChartController::class, 'loadMachine']);
    Route::get('/ProductionScheduleGanttChartController/loadOrder', [ProductionScheduleGanttChartController::class, 'loadOrder']);
    Route::get('/ProductionScheduleGanttChartController/searchGantChart/{setting}/{startDate}/{endDate}', [ProductionScheduleGanttChartController::class, 'searchGantChart']);
    /** End of Gantt Chart */


    /** Daily Production Report Controller */
    Route::get('/DailyProductionReportController/sites', [DailyProductionReportController::class, 'sites']);
    Route::get('/DailyProductionReportController/dailyProductionReport/{search_option}', [DailyProductionReportController::class, 'dailyProductionReport']);
    /** End of Daily Production Report Controller */


    /** Production Records Report Controller */
    Route::get('/ProductionRecordsReportController/allSettings', [ProductionRecordsReportController::class, 'allSettings']);
    Route::get('/ProductionRecordsReportController/productionRecordsReport/{search_option}/{date_from}/{date_to}', [ProductionRecordsReportController::class, 'productionRecordsReport']);
    /** End of Production Records Report Controller */


    /** Finished Goods Controller */
    Route::get('/FinishedGoodsController/refferanceMaxID/{store_id}', [FinishedGoodsController::class, 'refferanceMaxID']);
    Route::get('/FinishedGoodsController/allStores', [FinishedGoodsController::class, 'allStores']);
    Route::get('/FinishedGoodsController/allManufacturingNumber', [FinishedGoodsController::class, 'allManufacturingNumber']);
    Route::get('/FinishedGoodsController/allProduct', [FinishedGoodsController::class, 'allProduct']);
    Route::get('/FinishedGoodsController/allProductFromManuFacturingOrder/{id}', [FinishedGoodsController::class, 'allProductFromManuFacturingOrder']);
    Route::get('/FinishedGoodsController/getUom/{id}', [FinishedGoodsController::class, 'getUom']);
    Route::post('/FinishedGoodsController/save', [FinishedGoodsController::class, 'save']);
    Route::get('/FinishedGoodsController/getFinishedGoods/{id}', [FinishedGoodsController::class, 'getFinishedGoods']);
    Route::put('/FinishedGoodsController/update/{id}', [FinishedGoodsController::class, 'update']);
    Route::put('/FinishedGoodsController/change_status/{id}', [FinishedGoodsController::class, 'change_status']);
    /** End of Finished Goods Controller */


    /** Finished Goods List Controller */
    Route::get('/FinishedGoodsListController/allFinishedGoods', [FinishedGoodsListController::class, 'allFinishedGoods']);
    Route::delete('/FinishedGoodsListController/deleteFinishedGoods/{id}', [FinishedGoodsListController::class, 'deleteFinishedGoods']);
    /** End of Finished Goods List Controller */


    /** Schedule Status Controller */
    Route::get('/ScheduleStatusController/productionPlan', [ScheduleStatusController::class, 'productionPlan']);
    Route::post('/ScheduleStatusController/production_status_start', [ScheduleStatusController::class, 'production_status_start']);
    Route::post('/ScheduleStatusController/production_status_hold', [ScheduleStatusController::class, 'production_status_hold']);
    Route::post('/ScheduleStatusController/production_status_finished', [ScheduleStatusController::class, 'production_status_finished']);
    Route::post('/ScheduleStatusController/production_status_delivered', [ScheduleStatusController::class, 'production_status_delivered']);
    Route::get('/ScheduleStatusController/getProductionStatus', [ScheduleStatusController::class, 'getProductionStatus']);
    /**End of Schedule Status Controller */



    /**Machine Breakdown Controller */
    Route::get('/ReasonOfBreakdownController/productionSupervisor', [ReasonOfBreakdownController::class, 'productionSupervisor']);
    Route::get('/ReasonOfBreakdownController/manufacturingOrderNumber/{date}', [ReasonOfBreakdownController::class, 'manufacturingOrderNumber']);
    Route::get('/ReasonOfBreakdownController/product/{id}', [ReasonOfBreakdownController::class, 'product']);
    Route::get('/ReasonOfBreakdownController/machine/{id}', [ReasonOfBreakdownController::class, 'machine']);
    Route::post('/ReasonOfBreakdownController/save', [ReasonOfBreakdownController::class, 'save']);
    Route::post('/ReasonOfBreakdownController/update/{id}', [ReasonOfBreakdownController::class, 'update']);
    Route::get('/ReasonOfBreakdownController/getDailyProduction/{id}', [ReasonOfBreakdownController::class, 'getDailyProduction']);
    Route::get('/ReasonOfBreakdownController/getShift/{id}/{date}', [ReasonOfBreakdownController::class, 'getShift']);
    Route::get('/ReasonOfBreakdownController/allDailyProduction', [ReasonOfBreakdownController::class, 'allDailyProduction']);
    Route::get('/ReasonOfBreakdownController/allSite', [ReasonOfBreakdownController::class, 'allSite']);
    Route::get('/ReasonOfBreakdownController/allReason', [ReasonOfBreakdownController::class, 'allReason']);
    Route::delete('/ReasonOfBreakdownController/delete/{id}', [ReasonOfBreakdownController::class, 'delete']);
    /**End of Machine Breakdown Controller */


    /* Settings */
    Route::post('/SettingsController/saveReasonOfBreakdown', [SettingsController::class, 'saveReasonOfBreakdown']);
    Route::get('/SettingsController/allReason', [SettingsController::class, 'allReason']);
    Route::get('/SettingsController/getReason/{id}', [SettingsController::class, 'getReason']);
    Route::put('/SettingsController/updateReasonOfBreakdown/{id}', [SettingsController::class, 'updateReasonOfBreakdown']);
    Route::put('/SettingsController/disableReason/{id}', [SettingsController::class, 'disableReason']);
    /* End of Settings */

    /**Pending Machine Breakdown Controller */
    Route::get('/PendingMachineBreakdownController/allPendingMachineBreakdown', [PendingMachineBreakdownController::class, 'allPendingMachineBreakdown']);
    Route::get('/PendingMachineBreakdownController/getPendingMachineBreakdownData/{id}', [PendingMachineBreakdownController::class, 'getPendingMachineBreakdownData']);

    /**End of Pending Machine Breakdown Controller */



    /** Production Breakdown Report Controller */
    Route::get('/ProductionBreakdownReportController/allSettings', [ProductionBreakdownReportController::class, 'allSettings']);
    Route::get('/ProductionRecordsReportController/productionBreakdownReport/{search_option}/{date_from}/{date_to}', [ProductionBreakdownReportController::class, 'productionBreakdownReport']);
    /** End of Production Breakdown Report Controller */



    /** DashBoardController */
    Route::get('/dashboard/tableProducedQuantity/{date}', [DashboardController::class, 'tableProducedQuantity']);
    Route::get('/dashboard/tableScheduleOnGoing/{date}', [DashboardController::class, 'tableScheduleOnGoing']);
    Route::get('/dashboard/createTabsToSites', [DashboardController::class, 'createTabsToSites']);
    /** End of DashBoardController */


    /** Pallatizing Controller */
    Route::get('/PallatizingController/getPalletNo', [PallatizingController::class, 'getPalletNo']);
    Route::get('/PallatizingController/getGeneratedPalletNo/{order_number}', [PallatizingController::class, 'getGeneratedPalletNo']);
    Route::get('/PallatizingController/allEmployees', [PallatizingController::class, 'allEmployees']);
    Route::post('/PallatizingController/save', [PallatizingController::class, 'save']);
    Route::post('/PallatizingController/uploadAttachment', [PallatizingController::class, 'uploadAttachment'])->name('/PallatizingController/uploadAttachment');
    Route::get('/PallatizingController/allAttachment/{id}/{token}', [PallatizingController::class, 'allAttachment']);
    Route::get('/PallatizingController/getPallet/{id}', [PallatizingController::class, 'getPallet']);
    Route::put('/PallatizingController/update/{id}', [PallatizingController::class, 'update']);
    Route::delete('/PallatizingController/deleteAttachment/{id}', [PallatizingController::class, 'deleteAttachment']);
    Route::put('/PallatizingController/change_status/{id}', [PallatizingController::class, 'change_status']);
    Route::get('/PallatizingController/allFactories', [PallatizingController::class, 'allFactories']);
    Route::get('/PallatizingController/allOrders', [PallatizingController::class, 'allOrders']);
    Route::get('/PallatizingController/allOrders', [PallatizingController::class, 'allOrders']);
    Route::get('/PallatizingController/ongoingProducts/{order_id}', [PallatizingController::class, 'ongoingProducts']);
    /** End of Pallatizing Controller */


    /** Pallatizing List Controller */
    Route::get('/PallatizingListController/allPallatizingData', [PallatizingListController::class, 'allPallatizingData']);
    Route::delete('/PallatizingListController/deletePallet/{id}', [PallatizingListController::class, 'deletePallet']);
    Route::get('/PallatizingListController/pallatizingPrint/{id}', [PallatizingListController::class, 'pallatizingPrint']);
    /** End of Pallatizing List Controller */


    /** Production Record Supervisor Outside Controller */
    Route::get('/ProductionRecordSupervisorOutsideController/manufacturingOrderNumber/{id}', [ProductionRecordSupervisorOutsideController::class, 'manufacturingOrderNumber']);
    Route::get('/ProductionRecordSupervisorOutsideController/outsideFactories', [ProductionRecordSupervisorOutsideController::class, 'outsideFactories']);
    Route::post('/ProductionRecordSupervisorOutsideController/save', [ProductionRecordSupervisorOutsideController::class, 'save']);
    Route::put('/ProductionRecordSupervisorOutsideController/update/{id}', [ProductionRecordSupervisorOutsideController::class, 'update']);
    Route::get('/ProductionRecordSupervisorOutsideController/allOutsideFactories', [ProductionRecordSupervisorOutsideController::class, 'allOutsideFactories']);
    Route::get('/ProductionRecordSupervisorOutsideController/getOutside/{id}', [ProductionRecordSupervisorOutsideController::class, 'getOutside']);
    Route::delete('/ProductionRecordSupervisorOutsideController/delete/{id}', [ProductionRecordSupervisorOutsideController::class, 'delete']);
    Route::post('/ProductionRecordSupervisorOutsideController/status_change/{id}', [ProductionRecordSupervisorOutsideController::class, 'status_change']);
    /** End Of Production Record Supervisor Outside Controller */



    Route::get('/production_schedule_allocate_machine', function () {
        return view('pd::production_schedule_allocate_machine');
    })->middleware('is.logged');


    /** ALLOCATE TO RESOURCES */
    Route::get('/allocateMachine/addOrder/all', [ProductionAllocateMachineController::class, 'addorderPurchaceOrder']);
    Route::get('/allocateMachine/allOrderPlan', [ProductionAllocateMachineController::class, 'allOrderPlan']);
    Route::get('/allocateMachine/allOrderPlanData/{id}', [ProductionAllocateMachineController::class, 'allOrderPlanData']);
    Route::get('/allocateMachine/getSelectedProductData/{customer_order_plan_data_id}/{product_primary_id}/{bom_header_id}', [ProductionAllocateMachineController::class, 'getSelectedProductData']);
    Route::get('/allocateMachine/factories', [ProductionAllocateMachineController::class, 'factories']);
    Route::get('/allocateMachine/loadMachinesToFactory/{factory_id}', [ProductionAllocateMachineController::class, 'loadMachinesToFactory']);
    Route::get('/allocateMachine/loadMachinePlan/{factory_id}/{machine_id}/{fromDate}/{toDate}', [ProductionAllocateMachineController::class, 'loadMachinePlan']);
    Route::get('/allocateMachine/allShift', [ProductionAllocateMachineController::class, 'allShift']);
    Route::get('/allocateMachine/quantityPerHour/{machine_id}/{product_primary_id}', [ProductionAllocateMachineController::class, 'quantityPerHour']);
    Route::post('/allocateMachine/saveAllocateToMachine', [ProductionAllocateMachineController::class, 'saveAllocateToMachine']);
    Route::get('/allocateMachine/getAllocatedQuantityFromDate/{order_id}/{product_id}/{machine_id}/{date}/{from}/{to}', [ProductionAllocateMachineController::class, 'getAllocatedQuantityFromDate']);
    Route::get('/allocateMachine/getAllocatedData/{order_id}/{product_id}/{machine_id}', [ProductionAllocateMachineController::class, 'getAllocatedData']);
    Route::get('/allocateMachine/getAllocatedBOMData/{product_code}/{bom_name}', [ProductionAllocateMachineController::class, 'getAllocatedBOMData']);
    Route::get('/allocateMachine/allRawMaterialProducts', [ProductionAllocateMachineController::class, 'allRawMaterialProducts']);
    Route::post('/allocateMachine/saveAllocateToBOM', [ProductionAllocateMachineController::class, 'saveAllocateToBOM']);
    Route::get('/allocateMachine/getProductionTeam', [ProductionAllocateMachineController::class, 'getProductionTeam']);
    Route::post('/allocateMachine/saveAllocateToHR', [ProductionAllocateMachineController::class, 'saveAllocateToHR']);
    Route::get('/allocateMachine/getSaveProductionTeam/{customer_order_plan_data_id}/{fg_product_id}/{shift_id}', [ProductionAllocateMachineController::class, 'getSaveProductionTeam']);
    Route::get('/allocateMachine/getSavedAllocatedBOMData/{customer_order_plan_data_id}/{fg_product_id}', [ProductionAllocateMachineController::class, 'getSavedAllocatedBOMData']);
    Route::get('/producttionPlanCalander/loadProductionPlanToCalander', [ProductionAllocateMachineController::class, 'loadProductionPlanToCalander']);
    Route::get('/allocateMachine/getMachineryShifts/{customer_order_plan_data_id}', [ProductionAllocateMachineController::class, 'getMachineryShifts']);
    Route::get('/allocateMachine/allBomName/{product_id}', [ProductionAllocateMachineController::class, 'allBomName']);
    Route::get('/allocateMachine/getProductUnits', [ProductionAllocateMachineController::class, 'getProductUnits']);
    Route::get('/allocateMachine/get_from_to/{shift_id}', [ProductionAllocateMachineController::class, 'get_from_to']);
    Route::get('/allocateMachine/getMachineAllocatedQuantity/{machine_id}/{date}', [ProductionAllocateMachineController::class, 'getMachineAllocatedQuantity']);
    Route::get('/allocateMachine/getAllocatedQuantityData/{machine_id}/{shift_id}/{date}', [ProductionAllocateMachineController::class, 'getAllocatedQuantityData']);
    Route::get('/allocateMachine/allBomNameForSelect/{product_id}', [ProductionAllocateMachineController::class, 'allBomNameForSelect']);
    Route::get('/allocateMachine/allOrderPlanForSelect', [ProductionAllocateMachineController::class, 'allOrderPlanForSelect']);
    Route::get('/allocateMachine/checkAllocatedMachineData/{order_id}/{product_id}', [ProductionAllocateMachineController::class, 'checkAllocatedData']);
    /** ALLOCATE TO RESOURCES */
});
