<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGrnHeadersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sc_grn_headers', function (Blueprint $table) {
            $table->id('internal_id');
            $table->string('external_id', 100);
            $table->string('test', 100);
            $table->string('ref_internal_id',100);
            $table->string('ref_external_id',100);
            $table->date('trans_date');
            $table->string('supplier_Id', 100);
            $table->integer('received_by');
            $table->string('employee_name',100);
            $table->integer('store_id');
            $table->string('supplier_ref_no', 30);
            $table->string('purchase_order_no',30);
            $table->string('transport_by', 200);
            $table->string('vehicle_no', 30);
            $table->string('remarks', 200);
            $table->integer('status');
            $table->integer('document_no');
            $table->integer('user_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('grn_headers');
    }
}
