<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sc_product_histories', function (Blueprint $table) {
            $table->id('transaction_id');
            $table->integer('internal_id');
            $table->string('external_id', 100);
            $table->integer('document_no');
            $table->string('description', 250);
            $table->string('product_id', 25);
            $table->integer('unit_id');
            $table->double('quantity');
            $table->double('set_off');
            $table->double('cost_price');
            $table->integer('store_id');
            $table->integer('user_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_histories');
    }
}
