<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMaterialRequisitionDataTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sc_material_requisition_data', function (Blueprint $table) {
            $table->id('mr_data_id');
            $table->integer('internal_id');
            $table->string('external_id', 100);
            $table->string('product_id',100);
            $table->integer('unit_id');
            $table->double('quantity');
            $table->double('transfer_quantity')->default(0);
            $table->double('issues_quantity')->default(0);
            $table->string('comments',200)->nullable();
            $table->integer('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('material_requisition_data');
    }
}
