<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGoodsTransferHeadersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sc_goods_transfer_headers', function (Blueprint $table) {
            $table->id('internal_id');
            $table->string('external_id', 100);
            $table->string('ref_internal_id', 100);
            $table->string('ref_external_id', 100);
            $table->date('trans_date');
            $table->integer('store_from_id');
            $table->integer('store_to_id');
            $table->integer('mr_internal_id')->default(0);
            $table->integer('status');
            $table->integer('document_no');
            $table->integer('user_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('goods_transfer_headers');
    }
}
