<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGoodsTransferDataTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sc_goods_transfer_data', function (Blueprint $table) {
            $table->id('goods_transfer_data_id');
            $table->integer('internal_id');
            $table->string('external_id', 100);
            $table->string('product_id', 100);
            $table->integer('unit_id');
            $table->double('quantity');
            $table->string('comments', 200)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('goods_transfer_data');
    }
}
