<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class GoodsTransferAttachmentMR extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_goods_transfer_attachment_m_rs';
    protected $primaryKey = 'goods_transfer_attachment_mr_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'goods_transfer_attachment_mr_id',
        'goods_transfer_mr_id',
        'path',
        'token',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_goods_transfer_attachment_m_rs";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    
    /*protected static function newFactory()
    {
        return \Modules\Sc\Database\factories\GoodsTransferAttachmentMRFactory::new();
    }*/
}
