<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class GrnAttachment extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_grn_attachments';
    protected $primaryKey = 'grn_attachment_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'grn_attachment_id',
        'grn_id',
        'path',
        'token',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_grn_attachments";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
   
}
